/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.themralheatexchanger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.fluid.ElementSidedFluidHandler;
import mods.eln.fluid.TankData;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.kotlin.Metadata;
import mods.eln.shadow.kotlin.Pair;
import mods.eln.shadow.kotlin.collections.MapsKt;
import mods.eln.shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import mods.eln.shadow.kotlin.jvm.internal.Intrinsics;
import mods.eln.shadow.kotlin.jvm.internal.SourceDebugExtension;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.IProcess;
import mods.eln.sim.nbt.NbtElectricalGateInput;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.themralheatexchanger.ThermalHeatExchangerDescriptor;
import mods.eln.transparentnode.themralheatexchanger.ThermalPairing;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 E2\u00020\u0001:\u0001EB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u0004\u0018\u00010\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0\u0013H\u0016J\b\u0010-\u001a\u00020.H\u0016J7\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\u000e2\b\u00104\u001a\u0004\u0018\u00010\u000e2\b\u00105\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u00020,2\u0006\u0010#\u001a\u00020$H\u0016J0\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010#\u001a\u00020$2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020=H\u0016J\u0010\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020,2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010D\u001a\u00020.2\u0006\u0010A\u001a\u00020BH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lmods/eln/transparentnode/themralheatexchanger/ThermalHeatExchangerElement;", "Lmods/eln/node/transparent/TransparentNodeElement;", "transparentNode", "Lmods/eln/node/transparent/TransparentNode;", "descriptor", "Lmods/eln/node/transparent/TransparentNodeDescriptor;", "(Lmods/eln/node/transparent/TransparentNode;Lmods/eln/node/transparent/TransparentNodeDescriptor;)V", "electricalControlLoad", "Lmods/eln/sim/nbt/NbtElectricalGateInput;", "fluidRegulatorProcess", "Lmods/eln/sim/IProcess;", "inputMbPerTick", "", "joulesPerTick", "", "outputMbPerTick", "tank", "Lmods/eln/fluid/ElementSidedFluidHandler;", "tankMap", "", "Lnet/minecraftforge/common/util/ForgeDirection;", "Lmods/eln/fluid/TankData;", "getTankMap", "()Ljava/util/Map;", "thermalLoad", "Lmods/eln/sim/nbt/NbtThermalLoad;", "thermalPairs", "", "Lmods/eln/transparentnode/themralheatexchanger/ThermalPairing;", "getThermalPairs", "()Ljava/util/List;", "thermalRegulatorProcess", "thermalWatchdog", "Lmods/eln/sim/process/destruct/ThermalLoadWatchDog;", "getConnectionMask", "side", "Lmods/eln/misc/Direction;", "lrdu", "Lmods/eln/misc/LRDU;", "getElectricalLoad", "getFluidHandler", "Lnet/minecraftforge/fluids/IFluidHandler;", "getThermalLoad", "getWaila", "", "initialize", "", "moveFluidProcess", "outputFluid", "Lnet/minecraftforge/fluids/Fluid;", "maxMbInputPerTick", "ratio", "minTemp", "maxTemp", "(Lnet/minecraftforge/fluids/Fluid;IDLjava/lang/Double;Ljava/lang/Double;)I", "multiMeterString", "onBlockActivated", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "vx", "", "vy", "vz", "readFromNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "thermoMeterString", "writeToNBT", "Companion", "Eln"})
@SourceDebugExtension(value={"SMAP\nThermalHeatExchanger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThermalHeatExchanger.kt\nmods/eln/transparentnode/themralheatexchanger/ThermalHeatExchangerElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1855#2,2:279\n766#2:281\n857#2,2:282\n1855#2,2:284\n*S KotlinDebug\n*F\n+ 1 ThermalHeatExchanger.kt\nmods/eln/transparentnode/themralheatexchanger/ThermalHeatExchangerElement\n*L\n204#1:279,2\n115#1:281\n115#1:282,2\n115#1:284,2\n*E\n"})
public final class ThermalHeatExchangerElement
extends TransparentNodeElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ThermalPairing> thermalPairs;
    private double joulesPerTick;
    private int inputMbPerTick;
    private int outputMbPerTick;
    @NotNull
    private final NbtElectricalGateInput electricalControlLoad;
    @NotNull
    private final NbtThermalLoad thermalLoad;
    @NotNull
    private final Map<ForgeDirection, TankData> tankMap;
    @NotNull
    private final ElementSidedFluidHandler tank;
    @NotNull
    private final ThermalLoadWatchDog thermalWatchdog;
    @NotNull
    private final IProcess fluidRegulatorProcess;
    @NotNull
    private final IProcess thermalRegulatorProcess;
    @Nullable
    private static final Fluid ic2hotcoolant = FluidRegistry.getFluid((String)"ic2hotcoolant");
    @Nullable
    private static final Fluid ic2coolant = FluidRegistry.getFluid((String)"ic2coolant");
    @Nullable
    private static final Fluid hotwater = FluidRegistry.getFluid((String)"hot_water");
    @Nullable
    private static final Fluid coldwater = FluidRegistry.getFluid((String)"cold_water");
    @Nullable
    private static final Fluid ic2hotwater = FluidRegistry.getFluid((String)"ic2hotwater");
    @Nullable
    private static final Fluid steam;
    @NotNull
    private static final ForgeDirection INPUT_SIDE;
    @NotNull
    private static final ForgeDirection OUTPUT_SIDE;

    public ThermalHeatExchangerElement(@NotNull TransparentNode transparentNode, @NotNull TransparentNodeDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(transparentNode, "transparentNode");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        super(transparentNode, descriptor);
        this.thermalPairs = new ArrayList();
        this.electricalControlLoad = new NbtElectricalGateInput("control");
        this.thermalLoad = new NbtThermalLoad("thermalLoad");
        Pair[] pairArray = new Pair[]{new Pair<ForgeDirection, TankData>(INPUT_SIDE, new TankData(new FluidTank(1000), null, 0.0, 6, null)), new Pair<ForgeDirection, TankData>(OUTPUT_SIDE, new TankData(new FluidTank(1000), null, 0.0, 6, null))};
        this.tankMap = MapsKt.mapOf(pairArray);
        this.tank = new ElementSidedFluidHandler(this.tankMap);
        this.thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);
        this.fluidRegulatorProcess = arg_0 -> ThermalHeatExchangerElement.fluidRegulatorProcess$lambda$2(this, arg_0);
        this.thermalRegulatorProcess = arg_0 -> ThermalHeatExchangerElement.thermalRegulatorProcess$lambda$3(this, arg_0);
        this.electricalLoadList.add(this.electricalControlLoad);
        this.thermalLoadList.add(this.thermalLoad);
        this.getSlowPreProcessList().add(this.fluidRegulatorProcess);
        this.thermalFastProcessList.add(this.thermalRegulatorProcess);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode, 2.0, 1.0));
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.setTemperatureLimits(((ThermalHeatExchangerDescriptor)descriptor).getThermal()).setDestroys(new WorldExplosion(this).machineExplosion());
        if (ic2hotcoolant != null && ic2coolant != null) {
            this.thermalPairs.add(new ThermalPairing(ic2coolant, ic2hotcoolant, -274.2857142857143, 9, 1.0, false, 300.0, null, 128, null));
            this.thermalPairs.add(new ThermalPairing(ic2hotcoolant, ic2coolant, 274.2857142857143, 9, 1.0, false, null, null, 192, null));
        }
        if (ic2hotwater != null) {
            Fluid fluid = FluidRegistry.WATER;
            Intrinsics.checkNotNullExpressionValue(fluid, "WATER");
            this.thermalPairs.add(new ThermalPairing(ic2hotwater, fluid, 1.1111111111111112, 36, 1.0, false, 26.85, 76.85));
        }
        if (steam != null) {
            Fluid fluid = FluidRegistry.WATER;
            Intrinsics.checkNotNullExpressionValue(fluid, "WATER");
            this.thermalPairs.add(new ThermalPairing(fluid, steam, -2.2222222222222223, 36, 10.0, false, 100.0, null, 128, null));
        }
        Iterable $this$forEach$iv = this.thermalPairs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ThermalPairing it = (ThermalPairing)element$iv;
            boolean bl = false;
            this.tank.addFluidWhitelist(INPUT_SIDE, it.getInput());
            this.tank.addFluidWhitelist(OUTPUT_SIDE, it.getOutput());
            if (!it.getReversible()) continue;
            this.tank.addFluidWhitelist(OUTPUT_SIDE, it.getInput());
            this.tank.addFluidWhitelist(INPUT_SIDE, it.getOutput());
        }
    }

    @NotNull
    public final List<ThermalPairing> getThermalPairs() {
        return this.thermalPairs;
    }

    @NotNull
    public final Map<ForgeDirection, TankData> getTankMap() {
        return this.tankMap;
    }

    public final int moveFluidProcess(@NotNull Fluid outputFluid, int maxMbInputPerTick, double ratio, @Nullable Double minTemp, @Nullable Double maxTemp) {
        double shouldMoveOutputMb;
        int predictedInputMb;
        Intrinsics.checkNotNullParameter(outputFluid, "outputFluid");
        int maxMbOutputPerTick = (int)Math.ceil((double)maxMbInputPerTick * ratio);
        int canMoveOutputMb = this.tank.fill(OUTPUT_SIDE, new FluidStack(outputFluid, maxMbOutputPerTick), false);
        double inTempRange = 1.0;
        if (minTemp != null && this.thermalLoad.temperatureCelsius < minTemp) {
            inTempRange = 0.0;
        }
        if (maxTemp != null && this.thermalLoad.temperatureCelsius > maxTemp) {
            inTempRange = 0.0;
        }
        if ((predictedInputMb = (int)Math.ceil((shouldMoveOutputMb = Math.min((double)maxMbOutputPerTick * this.electricalControlLoad.getNormalized(), (double)canMoveOutputMb) * inTempRange) / ratio)) > 0) {
            FluidStack fluidStack = this.tank.drain(INPUT_SIDE, predictedInputMb, true);
            int movedInputMb = fluidStack != null ? fluidStack.amount : 0;
            this.tank.fill(OUTPUT_SIDE, new FluidStack(outputFluid, (int)((double)movedInputMb * ratio)), true);
            return movedInputMb;
        }
        return 0;
    }

    @Override
    @Nullable
    public NbtElectricalGateInput getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return side == this.front && lrdu == LRDU.Down ? this.electricalControlLoad : null;
    }

    @Override
    @Nullable
    public NbtThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return side == this.front.getInverse() && lrdu == LRDU.Down ? this.thermalLoad : null;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)side, "side");
        Intrinsics.checkNotNullParameter((Object)lrdu, "lrdu");
        return WhenMappings.$EnumSwitchMapping$0[lrdu.ordinal()] == 1 ? ((direction = side) == this.front.getInverse() ? 2 : (direction == this.front ? 4 : 0)) : 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotPercent("Ctl:", this.electricalControlLoad.getNormalized());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return Utils.plotCelsius("T:", this.thermalLoad.temperatureCelsius) + ' ' + Utils.plotPower(this.joulesPerTick * (double)20);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        Pair[] pairArray = new Pair[]{new Pair<String, String>(I18N.tr("Control", new Object[0]), Utils.plotPercent("", this.electricalControlLoad.getNormalized())), new Pair<String, String>(I18N.tr("input tank level", new Object[0]), String.valueOf(this.tank.getFluidAmount(INPUT_SIDE))), new Pair<String, String>(I18N.tr("output tank level", new Object[0]), String.valueOf(this.tank.getFluidAmount(OUTPUT_SIDE))), new Pair<String, String>(I18N.tr("input mB/t", new Object[0]), Utils.plotBuckets("", (double)this.inputMbPerTick / 1000.0)), new Pair<String, String>(I18N.tr("output mB/t", new Object[0]), Utils.plotBuckets("", (double)this.outputMbPerTick / 1000.0)), new Pair<String, String>(I18N.tr("joules per tick", new Object[0]), String.valueOf(this.joulesPerTick)), new Pair<String, String>(I18N.tr("thermal power", new Object[0]), Utils.plotPower(this.joulesPerTick * (double)20))};
        return MapsKt.mutableMapOf(pairArray);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.writeToNBT(nbt);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        super.readFromNBT(nbt);
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void initialize() {
        TransparentNodeDescriptor transparentNodeDescriptor = this.getDescriptor();
        Intrinsics.checkNotNull(transparentNodeDescriptor, "null cannot be cast to non-null type mods.eln.transparentnode.themralheatexchanger.ThermalHeatExchangerDescriptor");
        ((ThermalHeatExchangerDescriptor)transparentNodeDescriptor).getThermal().applyToThermalLoad(this.thermalLoad);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(@NotNull EntityPlayer player, @NotNull Direction side, float vx, float vy, float vz) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)side, "side");
        return false;
    }

    @Override
    @NotNull
    public IFluidHandler getFluidHandler() {
        return this.tank;
    }

    /*
     * WARNING - void declaration
     */
    private static final void fluidRegulatorProcess$lambda$2(ThermalHeatExchangerElement this$0, double it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Fluid inputFluid = this$0.tank.getFluidType(INPUT_SIDE);
        double joulesPerMb = 0.0;
        if (!((Collection)this$0.thermalPairs).isEmpty() && this$0.tank.getFluidAmount(INPUT_SIDE) > 0 && inputFluid != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this$0.thermalPairs;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ThermalPairing it2 = (ThermalPairing)element$iv$iv;
                boolean bl = false;
                if (!(it2.getInput().getID() == inputFluid.getID() || it2.getReversible() && it2.getOutput().getID() == inputFluid.getID())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ThermalPairing it3 = (ThermalPairing)element$iv;
                boolean bl = false;
                if (it3.getInput().getID() == inputFluid.getID()) {
                    this$0.inputMbPerTick = this$0.moveFluidProcess(it3.getOutput(), it3.getMaxMbInputPerTick(), it3.getRatio(), it3.getMinTemp(), it3.getMaxTemp());
                    this$0.outputMbPerTick = (int)((double)this$0.inputMbPerTick * it3.getRatio());
                    joulesPerMb = it3.getJoulesPerMb();
                    continue;
                }
                this$0.inputMbPerTick = this$0.moveFluidProcess(it3.getInput(), it3.getMaxMbInputPerTick(), it3.getRatio(), it3.getMinTemp(), it3.getMaxTemp());
                this$0.outputMbPerTick = (int)((double)this$0.inputMbPerTick * it3.getRatio());
                joulesPerMb = -it3.getJoulesPerMb();
            }
        }
        this$0.joulesPerTick = (double)this$0.outputMbPerTick * joulesPerMb;
    }

    private static final void thermalRegulatorProcess$lambda$3(ThermalHeatExchangerElement this$0, double time) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        double heatPower = this$0.joulesPerTick / (Eln.instance.thermalFrequency / Eln.instance.electricalFrequency) * 1.25 / time;
        this$0.thermalLoad.movePowerTo(heatPower);
    }

    static {
        Fluid fluid = FluidRegistry.getFluid((String)"steam");
        if (fluid == null) {
            fluid = FluidRegistry.getFluid((String)"ic2steam");
        }
        steam = fluid;
        INPUT_SIDE = ForgeDirection.DOWN;
        OUTPUT_SIDE = ForgeDirection.UP;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LRDU.values().length];
            try {
                nArray[LRDU.Down.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u0017"}, d2={"Lmods/eln/transparentnode/themralheatexchanger/ThermalHeatExchangerElement$Companion;", "", "()V", "INPUT_SIDE", "Lnet/minecraftforge/common/util/ForgeDirection;", "getINPUT_SIDE", "()Lnet/minecraftforge/common/util/ForgeDirection;", "OUTPUT_SIDE", "getOUTPUT_SIDE", "coldwater", "Lnet/minecraftforge/fluids/Fluid;", "getColdwater", "()Lnet/minecraftforge/fluids/Fluid;", "hotwater", "getHotwater", "ic2coolant", "getIc2coolant", "ic2hotcoolant", "getIc2hotcoolant", "ic2hotwater", "getIc2hotwater", "steam", "getSteam", "Eln"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Fluid getIc2hotcoolant() {
            return ic2hotcoolant;
        }

        @Nullable
        public final Fluid getIc2coolant() {
            return ic2coolant;
        }

        @Nullable
        public final Fluid getHotwater() {
            return hotwater;
        }

        @Nullable
        public final Fluid getColdwater() {
            return coldwater;
        }

        @Nullable
        public final Fluid getIc2hotwater() {
            return ic2hotwater;
        }

        @Nullable
        public final Fluid getSteam() {
            return steam;
        }

        @NotNull
        public final ForgeDirection getINPUT_SIDE() {
            return INPUT_SIDE;
        }

        @NotNull
        public final ForgeDirection getOUTPUT_SIDE() {
            return OUTPUT_SIDE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

