/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.thermaldissipatoractive;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.thermaldissipatoractive.ThermalDissipatorActiveDescriptor;
import mods.eln.transparentnode.thermaldissipatoractive.ThermalDissipatorActiveSlowProcess;
import net.minecraft.entity.player.EntityPlayer;

public class ThermalDissipatorActiveElement
extends TransparentNodeElement {
    ThermalDissipatorActiveDescriptor descriptor;
    NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    ThermalDissipatorActiveSlowProcess slowProcess = new ThermalDissipatorActiveSlowProcess(this);
    Resistor powerResistor = new Resistor(this.positiveLoad, null);
    VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog(this.positiveLoad);
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);
    public float lastPowerFactor;

    public ThermalDissipatorActiveElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.thermalLoadList.add(this.thermalLoad);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalComponentList.add(this.powerResistor);
        this.slowProcessList.add(this.slowProcess);
        this.descriptor = (ThermalDissipatorActiveDescriptor)descriptor;
        this.slowProcessList.add(new NodePeriodicPublishProcess(this.node, 4.0, 2.0));
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.setMaximumTemperature(this.descriptor.warmLimit).setDestroys(new WorldExplosion(this).machineExplosion());
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        this.slowProcessList.add(this.voltageWatchdog.setNominalVoltage(this.descriptor.nominalElectricalU).setDestroys(exp));
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (side == this.front || side == this.front.getInverse()) {
            return this.positiveLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        block5: {
            block4: {
                if (side == Direction.YN || side == Direction.YP) break block4;
                if (lrdu == LRDU.Down) break block5;
            }
            return null;
        }
        if (side == this.front || side == this.front.getInverse()) {
            return null;
        }
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        block5: {
            block4: {
                if (side == Direction.YN || side == Direction.YP) break block4;
                if (lrdu == LRDU.Down) break block5;
            }
            return 0;
        }
        if (side == this.front || side == this.front.getInverse()) {
            return 1;
        }
        return 2;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return Utils.plotVolt("U : ", this.positiveLoad.getVoltage()) + Utils.plotAmpere("I : ", this.positiveLoad.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return Utils.plotCelsius("T : ", this.thermalLoad.temperatureCelsius) + Utils.plotPower("P : ", this.thermalLoad.getPower());
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.thermalLoad);
        this.descriptor.applyTo(this.positiveLoad, this.powerResistor);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            this.lastPowerFactor = (float)(this.powerResistor.getPower() / this.descriptor.electricalNominalP);
            stream.writeFloat(this.lastPowerFactor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Temperature", new Object[0]), Utils.plotCelsius("", this.thermalLoad.temperatureCelsius));
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Thermal power", new Object[0]), Utils.plotPower("", this.thermalLoad.getPower()));
        }
        return info;
    }
}

