/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.thermaldissipatorpassive;

import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ThermalLoad;
import mods.eln.transparentnode.thermaldissipatorpassive.ThermalDissipatorPassiveElement;
import mods.eln.transparentnode.thermaldissipatorpassive.ThermalDissipatorPassiveRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class ThermalDissipatorPassiveDescriptor
extends TransparentNodeDescriptor {
    public double thermalRs;
    public double thermalRp;
    public double thermalC;
    public Obj3D obj;
    Obj3D.Obj3DPart main;
    public double warmLimit;
    public double coolLimit;
    public double nominalP;
    public double nominalT;

    public ThermalDissipatorPassiveDescriptor(String name, Obj3D obj, double warmLimit, double coolLimit, double nominalP, double nominalT, double nominalTao, double nominalConnectionDrop) {
        super(name, ThermalDissipatorPassiveElement.class, ThermalDissipatorPassiveRender.class);
        this.thermalC = nominalP * nominalTao / nominalT;
        this.thermalRp = nominalT / nominalP;
        this.thermalRs = nominalConnectionDrop / nominalP;
        this.coolLimit = coolLimit;
        this.warmLimit = warmLimit;
        this.nominalP = nominalP;
        this.nominalT = nominalT;
        Eln.simulator.checkThermalLoad(this.thermalRs, this.thermalRp, this.thermalC);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
        }
        this.voltageLevelColor = VoltageLevelColor.Thermal;
    }

    public void applyTo(ThermalLoad load) {
        load.set(this.thermalRs, this.thermalRp, this.thermalC);
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addThermal(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Used to cool down turbines.", new Object[0]));
        list.add(I18N.tr("Max. temperature: %1$\u00b0C", Utils.plotValue(this.warmLimit)));
        list.add(I18N.tr("Nominal usage:", new Object[0]));
        list.add("  " + I18N.tr("Temperature: %1$\u00b0C", Utils.plotValue(this.nominalT)));
        list.add("  " + I18N.tr("Cooling power: %1$W", Utils.plotValue(this.nominalP)));
    }

    public void draw() {
        if (this.main != null) {
            this.main.draw();
        }
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw();
        }
    }
}

