/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.thermaldissipatorpassive;

import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.thermaldissipatorpassive.ThermalDissipatorPassiveDescriptor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ThermalDissipatorPassiveElement
extends TransparentNodeElement {
    ThermalDissipatorPassiveDescriptor descriptor;
    NbtThermalLoad thermalLoad = new NbtThermalLoad("thermalLoad");
    ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog(this.thermalLoad);

    public ThermalDissipatorPassiveElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.thermalLoadList.add(this.thermalLoad);
        this.descriptor = (ThermalDissipatorPassiveDescriptor)descriptor;
        this.slowProcessList.add(this.thermalWatchdog);
        this.thermalWatchdog.setMaximumTemperature(this.descriptor.warmLimit).setDestroys(new WorldExplosion(this).machineExplosion());
    }

    @Override
    @Nullable
    public ElectricalLoad getElectricalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        block3: {
            block2: {
                if (side == Direction.YN || side == Direction.YP) break block2;
                if (lrdu == LRDU.Down) break block3;
            }
            return null;
        }
        return this.thermalLoad;
    }

    @Override
    public int getConnectionMask(@NotNull Direction side, @NotNull LRDU lrdu) {
        block3: {
            block2: {
                if (side == Direction.YN || side == Direction.YP) break block2;
                if (lrdu == LRDU.Down) break block3;
            }
            return 0;
        }
        return 2;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return "";
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return Utils.plotCelsius("T : ", this.thermalLoad.temperatureCelsius) + Utils.plotPower("P : ", this.thermalLoad.getPower());
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.thermalLoad);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        ItemStack stack = player.func_71045_bC();
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151131_as) {
            this.thermalLoad.temperatureCelsius *= 0.5;
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(Items.field_151133_ar));
            return true;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150432_aD)) {
            this.thermalLoad.temperatureCelsius *= 0.2;
            if (stack.field_77994_a != 0) {
                --stack.field_77994_a;
            } else {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Temperature", new Object[0]), Utils.plotCelsius("", this.thermalLoad.temperatureCelsius));
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Thermal power", new Object[0]), Utils.plotPower("", this.thermalLoad.getPower()));
        }
        return info;
    }
}

