/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import java.util.List;
import mods.eln.Eln;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.misc.FunctionTable;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.transparentnode.turbine.TurbineElement;
import mods.eln.transparentnode.turbine.TurbineRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class TurbineDescriptor
extends TransparentNodeDescriptor {
    final CableRenderDescriptor eRender;
    private Obj3D.Obj3DPart main;
    public final double powerOutPerDeltaU;
    public final FunctionTable TtoU;
    public final FunctionTable PoutToPin;
    public final double nominalDeltaT;
    public final double nominalU;
    final double nominalP;
    private final double thermalC;
    private final double thermalRs;
    private final double thermalRp;
    final double electricalRs;
    public final String soundFile;

    public TurbineDescriptor(String name, String modelName, CableRenderDescriptor eRender, FunctionTable TtoU, FunctionTable PoutToPin, double nominalDeltaT, double nominalU, double nominalP, double nominalPowerLost, double electricalRs, double thermalC, double DeltaTForInput, double powerOutPerDeltaU, String soundFile) {
        super(name, TurbineElement.class, TurbineRender.class);
        double nominalEff = Math.abs(1.0 - 293.15 / (nominalDeltaT + 293.15));
        this.TtoU = TtoU;
        this.PoutToPin = PoutToPin;
        this.nominalDeltaT = nominalDeltaT;
        this.nominalU = nominalU;
        this.nominalP = nominalP;
        this.thermalC = thermalC;
        this.thermalRs = DeltaTForInput / (nominalP / nominalEff);
        this.thermalRp = nominalDeltaT / nominalPowerLost;
        this.electricalRs = electricalRs;
        this.powerOutPerDeltaU = powerOutPerDeltaU;
        this.eRender = eRender;
        this.soundFile = soundFile;
        Obj3D obj = Eln.obj.getObj(modelName);
        if (obj != null) {
            this.main = obj.getPart("main");
        }
        this.voltageLevelColor = VoltageLevelColor.fromVoltage(nominalU);
    }

    public void applyTo(ThermalLoad load) {
        load.heatCapacity = this.thermalC;
        load.Rp = this.thermalRp;
        load.Rs = this.thermalRs;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addThermal(this.newItemStack());
        Data.addEnergy(this.newItemStack());
    }

    public void applyTo(ElectricalLoad load) {
        load.setSerialResistance(this.electricalRs);
    }

    void draw() {
        if (this.main != null) {
            this.main.draw();
        }
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw();
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Generates electricity using heat.", new Object[0]));
        list.add(I18N.tr("Nominal usage:", new Object[0]));
        list.add("  " + I18N.tr("Temperature difference: %1$\u00b0C", Utils.plotValue(this.nominalDeltaT)));
        list.add("  " + I18N.tr("Voltage: %1$V", Utils.plotValue(this.nominalU)));
        list.add("  " + I18N.tr("Power: %1$W", Utils.plotValue(this.nominalP)));
    }
}

