/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import mods.eln.sim.IProcess;
import mods.eln.sim.mna.SubSystem;
import mods.eln.sim.mna.misc.IRootSystemPreStepProcess;
import mods.eln.transparentnode.turbine.TurbineDescriptor;
import mods.eln.transparentnode.turbine.TurbineElement;

public class TurbineElectricalProcess
implements IProcess,
IRootSystemPreStepProcess {
    private final TurbineElement turbine;

    public TurbineElectricalProcess(TurbineElement turbine) {
        this.turbine = turbine;
    }

    @Override
    public void process(double time) {
        double Ut;
        TurbineDescriptor descriptor = this.turbine.descriptor;
        double deltaT = this.turbine.warmLoad.temperatureCelsius - this.turbine.coolLoad.temperatureCelsius;
        double targetU = descriptor.TtoU.getValue(deltaT);
        SubSystem.Thevenin th = this.turbine.positiveLoad.getSubSystem().getTh(this.turbine.positiveLoad, this.turbine.electricalPowerSourceProcess);
        if (targetU < th.voltage) {
            Ut = th.voltage;
        } else if (th.isHighImpedance()) {
            Ut = targetU;
        } else {
            double a = 1.0 / th.resistance;
            double b = descriptor.powerOutPerDeltaU - th.voltage / th.resistance;
            double c = -descriptor.powerOutPerDeltaU * targetU;
            Ut = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        }
        double i = (Ut - th.voltage) / th.resistance;
        double p = i * Ut;
        double pMax = descriptor.nominalP * 1.5;
        if (p > pMax) {
            Ut = (Math.sqrt(th.voltage * th.voltage + 4.0 * pMax * th.resistance) + th.voltage) / 2.0;
            if (Double.isNaN(Ut = Math.min(Ut, targetU))) {
                Ut = 0.0;
            }
            if (Ut < th.voltage) {
                Ut = th.voltage;
            }
        }
        this.turbine.electricalPowerSourceProcess.setVoltage(Ut);
    }

    @Override
    public void rootSystemPreStepProcess() {
        this.process(0.0);
    }
}

