/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.Resistor;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtThermalLoad;
import mods.eln.sim.process.destruct.ThermalLoadWatchDog;
import mods.eln.sim.process.destruct.VoltageStateWatchDog;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.transparentnode.turbine.TurbineDescriptor;
import mods.eln.transparentnode.turbine.TurbineElectricalProcess;
import mods.eln.transparentnode.turbine.TurbineThermalProcess;
import net.minecraft.entity.player.EntityPlayer;

public class TurbineElement
extends TransparentNodeElement {
    private final NbtElectricalLoad inputLoad = new NbtElectricalLoad("inputLoad");
    public final NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    private final Resistor inputToTurbineResistor = new Resistor(this.inputLoad, this.positiveLoad);
    public final NbtThermalLoad warmLoad = new NbtThermalLoad("warmLoad");
    public final NbtThermalLoad coolLoad = new NbtThermalLoad("coolLoad");
    public final VoltageSource electricalPowerSourceProcess = new VoltageSource("PowerSource", this.positiveLoad, null);
    private final TurbineThermalProcess turbineThermaltProcess = new TurbineThermalProcess(this);
    private final TurbineElectricalProcess turbineElectricalProcess = new TurbineElectricalProcess(this);
    final TurbineDescriptor descriptor;

    public TurbineElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (TurbineDescriptor)descriptor;
        this.electricalLoadList.add(this.inputLoad);
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalComponentList.add(this.inputToTurbineResistor);
        this.thermalLoadList.add(this.warmLoad);
        this.thermalLoadList.add(this.coolLoad);
        this.electricalComponentList.add(this.electricalPowerSourceProcess);
        this.thermalFastProcessList.add(this.turbineThermaltProcess);
        WorldExplosion exp = new WorldExplosion(this).machineExplosion();
        ThermalLoadWatchDog thermalWatchdog = new ThermalLoadWatchDog(this.warmLoad);
        this.slowProcessList.add(thermalWatchdog);
        thermalWatchdog.setMaximumTemperature(this.descriptor.nominalDeltaT * 2.0).setDestroys(exp);
        VoltageStateWatchDog voltageWatchdog = new VoltageStateWatchDog(this.positiveLoad);
        this.slowProcessList.add(voltageWatchdog.setNominalVoltage(this.descriptor.nominalU).setDestroys(exp));
        this.slowProcessList.add(new NodePeriodicPublishProcess(this.node, 1.0, 0.5));
    }

    @Override
    public void connectJob() {
        super.connectJob();
        Eln.simulator.mna.addProcess(this.turbineElectricalProcess);
    }

    @Override
    public void disconnectJob() {
        super.disconnectJob();
        Eln.simulator.mna.removeProcess(this.turbineElectricalProcess);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front) {
            return this.inputLoad;
        }
        if (side == this.front.back()) {
            return this.inputLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        if (side == this.front.left()) {
            return this.warmLoad;
        }
        if (side == this.front.right()) {
            return this.coolLoad;
        }
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu == LRDU.Down) {
            if (side == this.front) {
                return 1;
            }
            if (side == this.front.back()) {
                return 1;
            }
            if (side == this.front.left()) {
                return 2;
            }
            if (side == this.front.right()) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        if (side == this.front.left()) {
            return "";
        }
        if (side == this.front.right()) {
            return "";
        }
        if (side == this.front || side == this.front.back()) {
            return Utils.plotVolt("U+:", this.positiveLoad.getVoltage()) + Utils.plotAmpere("I+:", this.positiveLoad.getCurrent());
        }
        return Utils.plotVolt("U:", this.positiveLoad.getVoltage()) + Utils.plotAmpere("I:", this.positiveLoad.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        if (side == this.front.left()) {
            return Utils.plotCelsius("T+:", this.warmLoad.temperatureCelsius) + Utils.plotPower("P+:", this.warmLoad.getPower());
        }
        if (side == this.front.right()) {
            return Utils.plotCelsius("T-:", this.coolLoad.temperatureCelsius) + Utils.plotPower("P-:", this.coolLoad.getPower());
        }
        return Utils.plotCelsius("dT:", this.warmLoad.temperatureCelsius - this.coolLoad.temperatureCelsius) + Utils.plotPercent("Eff:", this.turbineThermaltProcess.getEfficiency());
    }

    @Override
    public void initialize() {
        this.descriptor.applyTo(this.inputLoad);
        this.inputToTurbineResistor.setResistance(this.descriptor.electricalRs * 30.0);
        this.descriptor.applyTo(this.warmLoad);
        this.descriptor.applyTo(this.coolLoad);
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    public float getLightOpacity() {
        return 1.0f;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        this.node.lrduCubeMask.getTranslate(this.front.down()).serialize(stream);
        try {
            stream.writeFloat((float)(this.warmLoad.temperatureCelsius - this.coolLoad.temperatureCelsius));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Nominal", new Object[0]) + " \u0394T", this.warmLoad.temperatureCelsius - this.coolLoad.temperatureCelsius == this.descriptor.nominalDeltaT ? I18N.tr("Yes", new Object[0]) : I18N.tr("No", new Object[0]));
        info.put(I18N.tr("Generated power", new Object[0]), Utils.plotPower("", this.electricalPowerSourceProcess.getPower()));
        if (Eln.wailaEasyMode) {
            info.put("\u0394T", Utils.plotCelsius("", this.warmLoad.temperatureCelsius - this.coolLoad.temperatureCelsius));
            info.put(I18N.tr("Voltage", new Object[0]), Utils.plotVolt("", this.electricalPowerSourceProcess.getVoltage()));
        }
        return info;
    }
}

