/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import java.io.DataInputStream;
import java.io.IOException;
import mods.eln.cable.CableRender;
import mods.eln.cable.CableRenderDescriptor;
import mods.eln.cable.CableRenderType;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.LRDUMask;
import mods.eln.misc.SlewLimiter;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sound.LoopedSound;
import mods.eln.transparentnode.turbine.TurbineDescriptor;
import net.minecraft.client.audio.ISound;
import org.lwjgl.opengl.GL11;

public class TurbineRender
extends TransparentNodeElementRender {
    private final TurbineDescriptor descriptor;
    private CableRenderType connectionType;
    private final SlewLimiter factorLimiter = new SlewLimiter(0.2f);
    private boolean cableRefresh;
    private final LRDUMask eConn = new LRDUMask();
    private final LRDUMask maskTemp = new LRDUMask();

    public TurbineRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (TurbineDescriptor)descriptor;
        this.addLoopedSound(new LoopedSound(this.descriptor.soundFile, this.coordinate(), ISound.AttenuationType.LINEAR){

            @Override
            public float func_147653_e() {
                return 0.1f * TurbineRender.this.factorLimiter.getPosition();
            }

            @Override
            public float func_147655_f() {
                return 0.9f + 0.2f * TurbineRender.this.factorLimiter.getPosition();
            }
        });
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        this.front.glRotateXnRef();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        this.descriptor.draw();
        GL11.glPopMatrix();
        if (this.cableRefresh) {
            this.cableRefresh = false;
            this.connectionType = CableRender.connectionType(this.getTileEntity(), this.eConn, this.front.down());
        }
        this.glCableTransform(this.front.down());
        this.descriptor.eRender.bindCableTexture();
        for (LRDU lrdu : LRDU.values()) {
            Utils.setGlColorFromDye(this.connectionType.otherdry[lrdu.toInt()]);
            if (!this.eConn.get(lrdu) || lrdu != this.front.down().getLRDUGoingTo(this.front) && lrdu.inverse() != this.front.down().getLRDUGoingTo(this.front)) continue;
            this.maskTemp.set(1 << lrdu.toInt());
            CableRender.drawCable(this.descriptor.eRender, this.maskTemp, this.connectionType, this.descriptor.eRender.getWidthDiv2() / 2.0f, false);
        }
    }

    @Override
    @Nullable
    public CableRenderDescriptor getCableRenderSide(@NotNull Direction side, @NotNull LRDU lrdu) {
        if (lrdu == LRDU.Down) {
            if (side == this.front) {
                return this.descriptor.eRender;
            }
            if (side == this.front.back()) {
                return this.descriptor.eRender;
            }
        }
        return null;
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        this.eConn.deserialize(stream);
        this.cableRefresh = true;
        try {
            float deltaT = stream.readFloat();
            if (deltaT >= 40.0f) {
                this.factorLimiter.setTarget((float)((double)deltaT / this.descriptor.nominalDeltaT));
            } else {
                this.factorLimiter.setTarget(0.0f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void refresh(float deltaT) {
        this.factorLimiter.step(deltaT);
        super.refresh(deltaT);
    }
}

