/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turbine;

import mods.eln.Eln;
import mods.eln.sim.IProcess;
import mods.eln.sim.mna.component.VoltageSource;
import mods.eln.transparentnode.turbine.TurbineDescriptor;
import mods.eln.transparentnode.turbine.TurbineElement;

public class TurbineThermalProcess
implements IProcess {
    private final TurbineElement turbine;
    private double efficiency = 0.0;

    public TurbineThermalProcess(TurbineElement t) {
        this.turbine = t;
    }

    public double getEfficiency() {
        return this.efficiency;
    }

    @Override
    public void process(double time) {
        TurbineDescriptor descriptor = this.turbine.descriptor;
        VoltageSource src = this.turbine.electricalPowerSourceProcess;
        this.efficiency = Math.abs(1.0 - (this.turbine.coolLoad.temperatureCelsius + 293.15) / (this.turbine.warmLoad.temperatureCelsius + 293.15));
        if (this.efficiency < 0.05) {
            this.efficiency = 0.05;
        }
        double E = src.getPower() * time / Eln.instance.heatTurbinePowerFactor;
        double Pout = E / time;
        double Pin = descriptor.PoutToPin.getValue(Pout) / this.efficiency;
        this.turbine.warmLoad.movePowerTo(-Pin);
        this.turbine.coolLoad.movePowerTo(Pin);
    }
}

