/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turret;

import java.util.Collections;
import java.util.List;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.transparentnode.turret.TurretElement;
import mods.eln.transparentnode.turret.TurretRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class TurretDescriptor
extends TransparentNodeDescriptor {
    private final Obj3D.Obj3DPart turret;
    private final Obj3D.Obj3DPart holder;
    private final Obj3D.Obj3DPart joint;
    private final Obj3D.Obj3DPart leftGun;
    private final Obj3D.Obj3DPart rightGun;
    private final Obj3D.Obj3DPart sensor;
    private final Obj3D.Obj3DPart fire;
    private final Properties properties;

    public TurretDescriptor(String name, String modelName) {
        super(name, TurretElement.class, TurretRender.class);
        Obj3D obj = Eln.obj.getObj(modelName);
        this.turret = obj.getPart("Turret");
        this.holder = obj.getPart("Holder");
        this.joint = obj.getPart("Joint");
        this.leftGun = obj.getPart("LeftGun");
        this.rightGun = obj.getPart("RightGun");
        this.sensor = obj.getPart("Sensor");
        this.fire = obj.getPart("Fire");
        this.properties = new Properties();
        this.voltageLevelColor = VoltageLevelColor.HighVoltage;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addMachine(this.newItemStack());
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        Collections.addAll(list, I18N.tr("Scans for entities and shoots if the\nentity matches the configurable filter criteria.", new Object[0]).split("\n"));
        list.add(I18N.tr("Nominal voltage: %1$V", 800));
        list.add(I18N.tr("Standby power: %1$W", Utils.plotValue(this.getProperties().basePower)));
        list.add(I18N.tr("Laser charge power: %1$W...%2$kW", 100, 10));
        list.add(I18N.tr("CAUTION: Cables can get quite hot!", new Object[0]));
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public boolean shouldUseRenderHelperEln(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.draw(null);
        }
    }

    public void draw(TurretRender render) {
        boolean enabled;
        float turretAngle = render != null ? render.getTurretAngle() : 0.0f;
        float gunPosition = render != null ? render.getGunPosition() : 0.0f;
        float gunAngle = render != null ? -render.getGunElevation() : 0.0f;
        boolean shooting = render != null && render.isShooting();
        boolean bl = enabled = render == null || render.isEnabled();
        if (this.holder != null) {
            this.holder.draw();
        }
        if (this.joint != null) {
            this.joint.draw();
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)turretAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.turret != null) {
            this.turret.draw();
        }
        if (this.sensor != null) {
            if (enabled) {
                if (render != null && render.filter != null) {
                    if (render.filterIsSpare) {
                        render.filter.glInverseColor(0.5f + 0.5f * gunPosition);
                    } else {
                        render.filter.glColor(0.5f + 0.5f * gunPosition);
                    }
                } else {
                    GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
                }
                UtilsClient.drawLight(this.sensor);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
                this.sensor.draw();
            }
        }
        GL11.glRotatef((float)gunAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glColor4f((float)0.6f, (float)0.8f, (float)1.0f, (float)0.4f);
        if (shooting && this.fire != null) {
            UtilsClient.drawLight(this.fire);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(gunPosition / 4.0f));
        if (this.leftGun != null) {
            this.leftGun.draw();
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-gunPosition / 2.0f));
        if (this.rightGun != null) {
            this.rightGun.draw();
        }
        GL11.glPopMatrix();
    }

    class Properties {
        public final float actionAngle;
        public final float detectionDistance;
        public final float aimDistance;
        public final float impulseEnergy;
        public final float gunMinElevation;
        public final float gunMaxElevation;
        public final float turretSeekAnimationSpeed;
        public final float turretAimAnimationSpeed;
        public final float gunArmAnimationSpeed;
        public final float gunDisarmAnimationSpeed;
        public final float gunAimAnimationSpeed;
        public final double minimalVoltage;
        public final double minimalVoltageHysteresisFactor;
        public final double maximalVoltage;
        public final double basePower;
        public final double chargePower;
        public final double entityDetectionInterval;

        public Properties() {
            this.actionAngle = 70.0f;
            this.detectionDistance = 12.0f;
            this.aimDistance = 15.0f;
            this.impulseEnergy = 1000.0f;
            this.gunMinElevation = -40.0f;
            this.gunMaxElevation = 70.0f;
            this.turretSeekAnimationSpeed = 40.0f;
            this.turretAimAnimationSpeed = 70.0f;
            this.gunArmAnimationSpeed = 3.0f;
            this.gunDisarmAnimationSpeed = 0.5f;
            this.gunAimAnimationSpeed = 100.0f;
            this.minimalVoltage = 600.0;
            this.minimalVoltageHysteresisFactor = 0.1;
            this.maximalVoltage = 1050.0;
            this.basePower = 25.0;
            this.chargePower = 1000.0;
            this.entityDetectionInterval = 0.25;
        }
    }
}

