/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turret;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.i18n.I18N;
import mods.eln.item.ConfigCopyToolDescriptor;
import mods.eln.item.EntitySensorFilterDescriptor;
import mods.eln.item.IConfigurable;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.AutoAcceptInventoryProxy;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.sim.nbt.NbtResistor;
import mods.eln.sixnode.lampsocket.LightBlockEntity;
import mods.eln.transparentnode.turret.TurretContainer;
import mods.eln.transparentnode.turret.TurretDescriptor;
import mods.eln.transparentnode.turret.TurretMechanicsSimulation;
import mods.eln.transparentnode.turret.TurretSlowProcess;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TurretElement
extends TransparentNodeElement
implements IConfigurable {
    public static final byte ToggleFilterMeaning = 1;
    public static final byte UnserializeChargePower = 2;
    private final TurretDescriptor descriptor;
    private final TurretMechanicsSimulation simulation;
    public double chargePower;
    public boolean filterIsSpare = false;
    public double energyBuffer = 0.0;
    final NbtElectricalLoad load = new NbtElectricalLoad("load");
    final NbtResistor powerResistor = new NbtResistor("powerResistor", this.load, null);
    final AutoAcceptInventoryProxy acceptingInventory = new AutoAcceptInventoryProxy((IInventory)new TransparentNodeElementInventory(1, 64, this)).acceptAlways(0, 1, new AutoAcceptInventoryProxy.SimpleItemDropper(this.node), EntitySensorFilterDescriptor.class);

    public TurretElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (TurretDescriptor)descriptor;
        this.chargePower = ((TurretDescriptor)descriptor).getProperties().chargePower;
        this.slowProcessList.add(new TurretSlowProcess(this));
        this.simulation = new TurretMechanicsSimulation((TurretDescriptor)descriptor);
        this.slowProcessList.add(this.simulation);
        Eln.instance.highVoltageCableDescriptor.applyTo(this.load);
        this.electricalLoadList.add(this.load);
        this.electricalComponentList.add(this.powerResistor);
    }

    @Override
    public TurretDescriptor getDescriptor() {
        return this.descriptor;
    }

    public float getTurretAngle() {
        return this.simulation.getTurretAngle();
    }

    public void setTurretAngle(float angle) {
        if (this.simulation.setTurretAngle(angle)) {
            this.needPublish();
        }
    }

    public float getGunPosition() {
        return this.simulation.getGunPosition();
    }

    public void setGunPosition(float position) {
        if (this.simulation.setGunPosition(position)) {
            this.needPublish();
        }
    }

    public void setGunElevation(float elevation) {
        if (this.simulation.setGunElevation(elevation)) {
            this.needPublish();
        }
    }

    public void setSeekMode(boolean seekModeEnabled) {
        if (seekModeEnabled != this.simulation.inSeekMode()) {
            this.needPublish();
        }
        this.simulation.setSeekMode(seekModeEnabled);
    }

    public void shoot() {
        Coordinate lightSourceCoordinate = new Coordinate();
        lightSourceCoordinate.copyFrom(this.coordinate());
        lightSourceCoordinate.move(this.front);
        LightBlockEntity.addLight(lightSourceCoordinate, 25, 2);
        if (this.simulation.shoot()) {
            this.needPublish();
        }
    }

    public boolean isTargetReached() {
        return this.simulation.isTargetReached();
    }

    public void setEnabled(boolean armed) {
        if (this.simulation.setEnabled(armed)) {
            this.needPublish();
        }
    }

    public boolean isEnabled() {
        return this.simulation.isEnabled();
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (side == this.front.back() && lrdu == LRDU.Down) {
            return this.load;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (side == this.front.back() && lrdu == LRDU.Down) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return Utils.plotUIP(this.load.getVoltage(), this.load.getCurrent());
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.connect();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return this.acceptingInventory.take(player.func_71045_bC());
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeFloat(this.simulation.getTurretTargetAngle());
            stream.writeFloat(this.simulation.getGunTargetPosition());
            stream.writeFloat(this.simulation.getGunTargetElevation());
            stream.writeBoolean(this.simulation.inSeekMode());
            stream.writeBoolean(this.simulation.isShooting());
            stream.writeBoolean(this.simulation.isEnabled());
            Utils.serialiseItemStack(stream, this.acceptingInventory.getInventory().func_70301_a(0));
            stream.writeBoolean(this.filterIsSpare);
            stream.writeFloat((float)this.chargePower);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74780_a("chargePower", this.chargePower);
        nbt.func_74757_a("filterIsSpare", this.filterIsSpare);
        nbt.func_74780_a("energyBuffer", this.energyBuffer);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.chargePower = nbt.func_74769_h("chargePower");
        this.filterIsSpare = nbt.func_74767_n("filterIsSpare");
        this.energyBuffer = nbt.func_74769_h("energyBuffer");
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public IInventory getInventory() {
        return this.acceptingInventory.getInventory();
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new TurretContainer(player, this.acceptingInventory.getInventory());
    }

    @Override
    public void inventoryChange(IInventory inventory) {
        super.inventoryChange(inventory);
        this.needPublish();
    }

    @Override
    public byte networkUnserialize(DataInputStream stream) {
        byte packetType = super.networkUnserialize(stream);
        try {
            switch (packetType) {
                case 1: {
                    this.filterIsSpare = !this.filterIsSpare;
                    this.needPublish();
                    break;
                }
                case 2: {
                    this.chargePower = stream.readFloat();
                    this.needPublish();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -128;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(I18N.tr("Charge power", new Object[0]), Utils.plotPower("", this.chargePower));
        ItemStack filterStack = this.acceptingInventory.getInventory().func_70301_a(0);
        if (filterStack != null) {
            GenericItemUsingDamageDescriptor gen = EntitySensorFilterDescriptor.getDescriptor(filterStack);
            if (gen != null && gen instanceof EntitySensorFilterDescriptor) {
                EntitySensorFilterDescriptor filter = (EntitySensorFilterDescriptor)gen;
                String target = I18N.tr("Shoot ", new Object[0]);
                if (this.filterIsSpare) {
                    target = target + "not ";
                }
                target = filter.entityClass == EntityPlayer.class ? target + I18N.tr("players", new Object[0]) : (filter.entityClass == IMob.class ? target + I18N.tr("monsters", new Object[0]) : (filter.entityClass == EntityAnimal.class ? target + I18N.tr("animals", new Object[0]) : target + I18N.tr("??", new Object[0])));
                info.put(I18N.tr("Target", new Object[0]), target);
            }
        } else if (this.filterIsSpare) {
            info.put(I18N.tr("Target", new Object[0]), I18N.tr("Shoot everything", new Object[0]));
        } else {
            info.put(I18N.tr("Target", new Object[0]), I18N.tr("Shoot nothing", new Object[0]));
        }
        if (Eln.wailaEasyMode) {
            info.put(I18N.tr("Charge level", new Object[0]), Utils.plotPercent("", this.energyBuffer / (double)this.descriptor.getProperties().impulseEnergy));
        }
        return info;
    }

    @Override
    public void readConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        if (compound.func_74764_b("chargePower")) {
            this.chargePower = compound.func_74769_h("chargePower");
            this.needPublish();
        }
        if (compound.func_74764_b("filterInvert")) {
            this.filterIsSpare = compound.func_74767_n("filterInvert");
        }
        if (ConfigCopyToolDescriptor.readGenDescriptor(compound, "filter", this.getInventory(), 0, invoker)) {
            this.needPublish();
        }
    }

    @Override
    public void writeConfigTool(NBTTagCompound compound, EntityPlayer invoker) {
        compound.func_74780_a("chargePower", this.chargePower);
        compound.func_74757_a("filterInvert", this.filterIsSpare);
        ConfigCopyToolDescriptor.writeGenDescriptor(compound, "filter", this.getInventory().func_70301_a(0));
    }
}

