/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turret;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.eln.item.EntitySensorFilterDescriptor;
import mods.eln.misc.Direction;
import mods.eln.misc.Utils;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.node.transparent.TransparentNodeElementRender;
import mods.eln.node.transparent.TransparentNodeEntity;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.transparentnode.turret.TurretDescriptor;
import mods.eln.transparentnode.turret.TurretGui;
import mods.eln.transparentnode.turret.TurretMechanicsSimulation;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class TurretRender
extends TransparentNodeElementRender {
    private final TurretDescriptor descriptor;
    private final TurretMechanicsSimulation simulation;
    private final TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(1, 1, this);
    EntitySensorFilterDescriptor filter = null;
    boolean filterIsSpare;
    float chargePower;

    public TurretRender(TransparentNodeEntity tileEntity, TransparentNodeDescriptor descriptor) {
        super(tileEntity, descriptor);
        this.descriptor = (TurretDescriptor)descriptor;
        this.simulation = new TurretMechanicsSimulation(this.descriptor);
    }

    public float getTurretAngle() {
        return this.simulation.getTurretAngle();
    }

    public float getGunPosition() {
        return this.simulation.getGunPosition();
    }

    public float getGunElevation() {
        return this.simulation.getGunElevation();
    }

    public boolean isShooting() {
        return this.simulation.isShooting();
    }

    public boolean isEnabled() {
        return this.simulation.isEnabled();
    }

    public void clientToggleFilterMeaning() {
        this.clientSendId((byte)1);
    }

    public void clientSetChargePower(float power2) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream stream = new DataOutputStream(bos);
            this.preparePacketForServer(stream);
            stream.writeByte(2);
            stream.writeFloat(power2);
            this.sendPacketToServer(bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void draw() {
        GL11.glPushMatrix();
        this.front.glRotateXnRef();
        this.descriptor.draw(this);
        GL11.glPopMatrix();
    }

    @Override
    public void refresh(float deltaT) {
        super.refresh(deltaT);
        this.simulation.process(deltaT);
    }

    @Override
    public void networkUnserialize(DataInputStream stream) {
        super.networkUnserialize(stream);
        try {
            this.simulation.setTurretAngle(stream.readFloat());
            this.simulation.setGunPosition(stream.readFloat());
            this.simulation.setGunElevation(stream.readFloat());
            this.simulation.setSeekMode(stream.readBoolean());
            if (stream.readBoolean()) {
                this.simulation.shoot();
            }
            this.simulation.setEnabled(stream.readBoolean());
            ItemStack filterStack = Utils.unserialiseItemStack(stream);
            this.filter = (EntitySensorFilterDescriptor)EntitySensorFilterDescriptor.getDescriptor(filterStack);
            this.filterIsSpare = stream.readBoolean();
            this.chargePower = stream.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public GuiScreen newGuiDraw(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new TurretGui(player, (IInventory)this.inventory, this);
    }
}

