/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.turret;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.eln.generic.GenericItemUsingDamageDescriptor;
import mods.eln.item.EntitySensorFilterDescriptor;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Utils;
import mods.eln.sim.fsm.CompositeState;
import mods.eln.sim.fsm.State;
import mods.eln.sim.fsm.StateMachine;
import mods.eln.sim.process.destruct.WorldExplosion;
import mods.eln.sound.SoundCommand;
import mods.eln.transparentnode.turret.TurretElement;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;

public class TurretSlowProcess
extends StateMachine {
    private static final Random rand = new Random();
    private double actualPower = 0.0;
    private final TurretElement element;

    public TurretSlowProcess(TurretElement element) {
        this.setInitialState(new IdleState());
        this.reset();
        this.element = element;
    }

    @Override
    public void process(double time) {
        boolean full;
        double MaximalEnergy = this.element.getDescriptor().getProperties().impulseEnergy;
        this.element.energyBuffer += this.element.powerResistor.getPower() * time;
        boolean bl = full = this.element.energyBuffer > MaximalEnergy;
        if (full) {
            this.element.energyBuffer = MaximalEnergy;
        }
        if (this.element.coordinate().getBlockExist()) {
            super.process(time);
        }
        if (this.actualPower == 0.0 || full) {
            this.element.powerResistor.highImpedance();
        } else {
            this.element.powerResistor.setResistance(this.element.load.getVoltage() * this.element.load.getVoltage() / this.actualPower);
        }
    }

    private class IdleState
    implements State {
        private IdleState() {
        }

        @Override
        public void enter() {
        }

        @Override
        public State state(double time) {
            if (((TurretSlowProcess)TurretSlowProcess.this).element.load.getVoltage() >= ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().minimalVoltage * (1.0 + ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().minimalVoltageHysteresisFactor)) {
                return new ActiveState();
            }
            return this;
        }

        @Override
        public void leave() {
        }
    }

    class ShootState
    implements State {
        private final EntityLivingBase target;

        public ShootState(EntityLivingBase target) {
            this.target = target;
        }

        @Override
        public void enter() {
            if (this.target != null) {
                this.target.field_70172_ad = 0;
                this.target.func_70097_a(new DamageSource("Unknown"), 5.0f);
                TurretSlowProcess.this.element.shoot();
                TurretSlowProcess.this.element.play(new SoundCommand("eln:LaserGun"));
            }
        }

        @Override
        public State state(double time) {
            if (this.target == null || this.target.func_110143_aJ() <= 0.0f) {
                return new SeekingState();
            }
            return new AimingState(this.target);
        }

        @Override
        public void leave() {
            ((TurretSlowProcess)TurretSlowProcess.this).element.energyBuffer = 0.0;
        }
    }

    private class AimingState
    implements State {
        private final EntityLivingBase target;

        public AimingState(EntityLivingBase target) {
            this.target = target;
        }

        @Override
        public void enter() {
            TurretSlowProcess.this.actualPower = ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().basePower + ((TurretSlowProcess)TurretSlowProcess.this).element.chargePower;
            TurretSlowProcess.this.element.setGunPosition(1.0f);
        }

        @Override
        public State state(double time) {
            GenericItemUsingDamageDescriptor gen;
            if (this.target.func_110143_aJ() <= 0.0f) {
                return new SeekingState();
            }
            Class filterClass = null;
            ItemStack filterStack = TurretSlowProcess.this.element.getInventory().func_70301_a(0);
            if (filterStack != null && (gen = EntitySensorFilterDescriptor.getDescriptor(filterStack)) != null && gen instanceof EntitySensorFilterDescriptor) {
                EntitySensorFilterDescriptor filter = (EntitySensorFilterDescriptor)gen;
                filterClass = filter.entityClass;
            }
            if (((TurretSlowProcess)TurretSlowProcess.this).element.filterIsSpare ? filterClass != null && filterClass.isAssignableFrom(this.target.getClass()) : filterClass == null || !filterClass.isAssignableFrom(this.target.getClass())) {
                return new SeekingState();
            }
            Coordinate coord = TurretSlowProcess.this.element.coordinate();
            double dx = (float)(this.target.field_70165_t - (double)coord.x - 0.5);
            double dy = (float)(this.target.field_70163_u + (double)this.target.func_70047_e() - (double)coord.y - 0.75);
            double dz = (float)(this.target.field_70161_v - (double)coord.z - 0.5);
            double entityAngle = -Math.toDegrees(Math.atan2(dz, dx));
            switch (((TurretSlowProcess)TurretSlowProcess.this).element.front) {
                case XN: {
                    if (entityAngle > 0.0) {
                        entityAngle -= 180.0;
                        break;
                    }
                    entityAngle += 180.0;
                    break;
                }
                case ZP: {
                    entityAngle += 90.0;
                    break;
                }
                case ZN: {
                    entityAngle -= 90.0;
                    break;
                }
            }
            double entityAngle2 = -Math.toDegrees(Math.asin(dy / Math.sqrt(dx * dx + dz * dz)));
            if (Math.abs(entityAngle) > (double)((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().actionAngle) {
                return new SeekingState();
            }
            TurretSlowProcess.this.element.setTurretAngle((float)entityAngle);
            TurretSlowProcess.this.element.setGunElevation((float)(-entityAngle2));
            if (Math.abs(this.target.field_70165_t - (double)coord.x) > (double)((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().aimDistance || Math.abs(this.target.field_70161_v - (double)coord.z) > (double)((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().aimDistance) {
                return new SeekingState();
            }
            ArrayList<Block> blockList = Utils.traceRay(coord.world(), (double)coord.x + 0.5, (double)coord.y + 0.5, (double)coord.z + 0.5, this.target.field_70165_t, this.target.field_70163_u + (double)this.target.func_70047_e(), this.target.field_70161_v);
            for (Block b : blockList) {
                if (!b.func_149662_c()) continue;
                return new SeekingState();
            }
            if (TurretSlowProcess.this.element.getGunPosition() == 1.0f && TurretSlowProcess.this.element.isTargetReached() && ((TurretSlowProcess)TurretSlowProcess.this).element.energyBuffer >= (double)((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().impulseEnergy) {
                return new ShootState(this.target);
            }
            return this;
        }

        @Override
        public void leave() {
        }
    }

    private class SeekingState
    implements State {
        private double lastScanWasBefore = 0.0;

        private SeekingState() {
        }

        @Override
        public void enter() {
            TurretSlowProcess.this.actualPower = ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().basePower;
            TurretSlowProcess.this.element.setGunPosition(0.0f);
            TurretSlowProcess.this.element.setGunElevation(0.0f);
            TurretSlowProcess.this.element.setSeekMode(true);
            TurretSlowProcess.this.element.setTurretAngle(((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().actionAngle);
        }

        @Override
        public State state(double time) {
            GenericItemUsingDamageDescriptor gen;
            if (TurretSlowProcess.this.element.getTurretAngle() >= ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().actionAngle) {
                TurretSlowProcess.this.element.setTurretAngle(-((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().actionAngle);
            } else if (TurretSlowProcess.this.element.getTurretAngle() <= -((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().actionAngle) {
                TurretSlowProcess.this.element.setTurretAngle(((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().actionAngle);
            }
            this.lastScanWasBefore += time;
            if (this.lastScanWasBefore < ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().entityDetectionInterval) {
                return null;
            }
            this.lastScanWasBefore = 0.0;
            Class filterClass = null;
            ItemStack filterStack = TurretSlowProcess.this.element.getInventory().func_70301_a(0);
            if (filterStack != null && (gen = EntitySensorFilterDescriptor.getDescriptor(filterStack)) != null && gen instanceof EntitySensorFilterDescriptor) {
                EntitySensorFilterDescriptor filter = (EntitySensorFilterDescriptor)gen;
                filterClass = filter.entityClass;
            }
            Coordinate coord = TurretSlowProcess.this.element.coordinate();
            AxisAlignedBB bb = coord.getAxisAlignedBB((int)((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().detectionDistance);
            List list = coord.world().func_72872_a(EntityLivingBase.class, bb);
            for (EntityLivingBase entity : list) {
                double dx = entity.field_70165_t - (double)coord.x - 0.5;
                double dz = entity.field_70161_v - (double)coord.z - 0.5;
                double entityAngle = -Math.toDegrees(Math.atan2(dz, dx));
                switch (((TurretSlowProcess)TurretSlowProcess.this).element.front) {
                    case XN: {
                        if (entityAngle > 0.0) {
                            entityAngle -= 180.0;
                            break;
                        }
                        entityAngle += 180.0;
                        break;
                    }
                    case ZP: {
                        entityAngle += 90.0;
                        break;
                    }
                    case ZN: {
                        entityAngle -= 90.0;
                        break;
                    }
                }
                if (!(Math.abs(entityAngle - (double)TurretSlowProcess.this.element.getTurretAngle()) < 15.0) || !(Math.abs(entityAngle) < (double)((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().actionAngle)) continue;
                if (((TurretSlowProcess)TurretSlowProcess.this).element.filterIsSpare ? filterClass != null && filterClass.isAssignableFrom(entity.getClass()) : filterClass == null || !filterClass.isAssignableFrom(entity.getClass())) {
                    return null;
                }
                ArrayList<Block> blockList = Utils.traceRay(coord.world(), (double)coord.x + 0.5, (double)coord.y + 0.5, (double)coord.z + 0.5, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v);
                boolean visible = true;
                for (Block b : blockList) {
                    if (!b.func_149662_c()) continue;
                    visible = false;
                    break;
                }
                if (!visible) continue;
                if (entity.func_110143_aJ() > 0.0f) {
                    TurretSlowProcess.this.element.play(new SoundCommand("eln:TurretFire").mulVolume(0.4));
                } else {
                    TurretSlowProcess.this.element.play(new SoundCommand("eln:TurretKill").mulVolume(0.4));
                }
                return new AimingState(entity);
            }
            return null;
        }

        @Override
        public void leave() {
            TurretSlowProcess.this.element.setSeekMode(false);
        }
    }

    private class WaitState
    implements State {
        private double delay = 5.0;

        private WaitState() {
        }

        @Override
        public void enter() {
        }

        @Override
        public State state(double time) {
            this.delay -= time;
            if (this.delay <= 0.0) {
                return new IdleState();
            }
            return this;
        }

        @Override
        public void leave() {
        }
    }

    private class DamageState
    implements State {
        private DamageState() {
        }

        @Override
        public void enter() {
            WorldExplosion explosion = new WorldExplosion(TurretSlowProcess.this.element).machineExplosion();
            explosion.destructImpl();
        }

        @Override
        public State state(double time) {
            return new IdleState();
        }

        @Override
        public void leave() {
        }
    }

    private class ActiveState
    extends CompositeState {
        public ActiveState() {
            this.setInitialState(new SeekingState());
        }

        @Override
        public void enter() {
            TurretSlowProcess.this.element.setEnabled(true);
            TurretSlowProcess.this.actualPower = ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().basePower;
            TurretSlowProcess.this.element.play(new SoundCommand("eln:TurretActivated").mulVolume(0.5));
            super.enter();
        }

        @Override
        public State state(double time) {
            super.state(time);
            if (((TurretSlowProcess)TurretSlowProcess.this).element.load.getVoltage() < ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().minimalVoltage * (1.0 - ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().minimalVoltageHysteresisFactor)) {
                return new WaitState();
            }
            if (((TurretSlowProcess)TurretSlowProcess.this).element.load.getVoltage() > ((TurretSlowProcess)TurretSlowProcess.this).element.getDescriptor().getProperties().maximalVoltage) {
                return new DamageState();
            }
            return this;
        }

        @Override
        public void leave() {
            TurretSlowProcess.this.element.setEnabled(false);
            TurretSlowProcess.this.actualPower = 0.0;
            TurretSlowProcess.this.element.play(new SoundCommand("eln:TurretDeactivated").mulVolume(0.5));
            super.leave();
        }
    }
}

