/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.waterturbine;

import java.util.List;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.FunctionTable;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.waterturbine.WaterTurbineElement;
import mods.eln.transparentnode.waterturbine.WaterTurbineRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public class WaterTurbineDescriptor
extends TransparentNodeDescriptor {
    Coordinate waterCoord;
    Obj3D.Obj3DPart wheel;
    Obj3D.Obj3DPart support;
    Obj3D.Obj3DPart generator;
    Obj3D obj;
    public ElectricalCableDescriptor cable;
    public double nominalPower;
    public double maxVoltage;
    public float speed;
    public String soundName;
    public float nominalVolume;
    public FunctionTable PfW;

    public WaterTurbineDescriptor(String name, Obj3D obj, ElectricalCableDescriptor cable, double nominalPower, double maxVoltage, Coordinate waterCoord, String soundName, float nominalVolume) {
        super(name, WaterTurbineElement.class, WaterTurbineRender.class);
        this.cable = cable;
        this.nominalPower = nominalPower;
        this.maxVoltage = maxVoltage;
        this.waterCoord = waterCoord;
        this.soundName = soundName;
        this.nominalVolume = nominalVolume;
        this.obj = obj;
        if (obj != null) {
            this.wheel = obj.getPart("Wheel");
            this.support = obj.getPart("Support");
            this.generator = obj.getPart("Generator");
            this.speed = 60.0f;
        }
        this.voltageLevelColor = VoltageLevelColor.LowVoltage;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    public void draw(float alpha) {
        if (this.support != null) {
            this.support.draw();
        }
        if (this.generator != null) {
            this.generator.draw();
        }
        if (this.wheel != null) {
            this.wheel.draw(alpha, 1.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public Direction getFrontFromPlace(Direction side, EntityLivingBase entityLiving) {
        return super.getFrontFromPlace(side, entityLiving);
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.objItemScale(this.obj);
            Direction.ZN.glRotateXnRef();
            this.draw(0.0f);
        }
    }

    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Generates energy using water stream.", new Object[0]));
        list.add(I18N.tr("Voltage: %1$V", Utils.plotValue(this.cable.electricalNominalVoltage)));
        list.add(I18N.tr("Power: %1$W", Utils.plotValue(this.nominalPower)));
    }

    public Coordinate getWaterCoordonate(World w) {
        Coordinate coord = new Coordinate(this.waterCoord);
        coord.setDimension(w.field_73011_w.field_76574_g);
        return coord;
    }

    @Override
    public String checkCanPlace(Coordinate coord, Direction front) {
        String str = super.checkCanPlace(coord, front);
        if (str != null) {
            return str;
        }
        if (!this.checkCanPlaceWater(coord, front)) {
            return I18N.tr("No place for water turbine!", new Object[0]);
        }
        return str;
    }

    public boolean checkCanPlaceWater(Coordinate coord, Direction front) {
        Coordinate water = new Coordinate(this.waterCoord);
        water.applyTransformation(front, coord);
        if (!coord.getBlockExist()) {
            return true;
        }
        return water.getBlock() == Blocks.field_150350_a || Utils.isWater(water);
    }
}

