/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.waterturbine;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Coordinate;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.node.transparent.TransparentNodeElementInventory;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.PowerSource;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.waterturbine.WaterTurbineContainer;
import mods.eln.transparentnode.waterturbine.WaterTurbineDescriptor;
import mods.eln.transparentnode.waterturbine.WaterTurbineSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;

public class WaterTurbineElement
extends TransparentNodeElement {
    NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    PowerSource powerSource = new PowerSource("powerSource", (State)this.positiveLoad);
    WaterTurbineSlowProcess slowProcess = new WaterTurbineSlowProcess(this);
    WaterTurbineDescriptor descriptor;
    Coordinate waterCoord;
    TransparentNodeElementInventory inventory = new TransparentNodeElementInventory(0, 64, this);

    public WaterTurbineElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (WaterTurbineDescriptor)descriptor;
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalComponentList.add(this.powerSource);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode, 2.0, 2.0));
        this.slowProcessList.add(this.slowProcess);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.front) {
            return this.positiveLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (side == this.front) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.setPhysicalValue();
        this.waterCoord = this.descriptor.getWaterCoordonate(this.node.coordinate.world());
        this.waterCoord.applyTransformation(this.front, this.node.coordinate);
        this.powerSource.setMaximumVoltage(this.descriptor.maxVoltage);
        this.powerSource.setMaximumCurrent(this.descriptor.nominalPower * 5.0 / this.descriptor.maxVoltage);
        this.connect();
    }

    private void setPhysicalValue() {
        this.descriptor.cable.applyTo(this.positiveLoad);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    @Nullable
    public Container newContainer(@NotNull Direction side, @NotNull EntityPlayer player) {
        return new WaterTurbineContainer(this.node, player, (IInventory)this.inventory);
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeFloat((float)(this.powerSource.getPower() / this.descriptor.nominalPower));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        return false;
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> wailaList = new HashMap<String, String>();
        wailaList.put(I18N.tr("Generating", new Object[0]), this.slowProcess.getWaterFactor() > 0.0 ? I18N.tr("Yes", new Object[0]) : I18N.tr("No", new Object[0]));
        wailaList.put(I18N.tr("Produced power", new Object[0]), Utils.plotPower("", this.powerSource.getEffectivePower()));
        if (Eln.wailaEasyMode) {
            wailaList.put("Voltage", Utils.plotVolt("", this.powerSource.getVoltage()));
        }
        return wailaList;
    }
}

