/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.windturbine;

import java.util.List;
import mods.eln.ghost.GhostGroup;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.FunctionTable;
import mods.eln.misc.Obj3D;
import mods.eln.misc.Utils;
import mods.eln.misc.UtilsClient;
import mods.eln.misc.VoltageLevelColor;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.sixnode.electricalcable.ElectricalCableDescriptor;
import mods.eln.transparentnode.windturbine.WindTurbineElement;
import mods.eln.transparentnode.windturbine.WindTurbineRender;
import mods.eln.wiki.Data;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class WindTurbineDescriptor
extends TransparentNodeDescriptor {
    private final Obj3D obj;
    private final Obj3D.Obj3DPart main;
    private final Obj3D.Obj3DPart rot;
    private final Obj3D.Obj3DPart halo;
    public final ElectricalCableDescriptor cable;
    final double nominalPower;
    final double maxVoltage;
    private final double maxWind;
    final int offY;
    final int rayX;
    final int rayY;
    final int rayZ;
    int blockMalusSubCount;
    final double blockMalus;
    final String soundName;
    final float nominalVolume;
    final FunctionTable PfW;
    double speed;

    public WindTurbineDescriptor(String name, Obj3D obj, ElectricalCableDescriptor cable, FunctionTable PfW, double nominalPower, double nominalWind, double maxVoltage, double maxWind, int offY, int rayX, int rayY, int rayZ, int blockMalusMinCount, double blockMalus, String soundName, float nominalVolume) {
        super(name, WindTurbineElement.class, WindTurbineRender.class);
        this.cable = cable;
        this.nominalPower = nominalPower;
        this.maxVoltage = maxVoltage;
        this.maxWind = maxWind;
        this.offY = offY;
        this.rayX = rayX;
        this.rayY = rayY;
        this.rayZ = rayZ;
        this.blockMalusSubCount = blockMalusMinCount + 1;
        this.blockMalus = blockMalus;
        this.soundName = soundName;
        this.nominalVolume = nominalVolume;
        this.PfW = PfW.duplicate(nominalWind, nominalPower);
        this.obj = obj;
        if (obj != null) {
            this.main = obj.getPart("main");
            this.rot = obj.getPart("rot");
            this.halo = obj.getPart("halo");
            if (this.rot != null) {
                this.speed = this.rot.getFloat("speed");
            }
        } else {
            this.main = null;
            this.rot = null;
            this.halo = null;
        }
        this.voltageLevelColor = VoltageLevelColor.LowVoltage;
    }

    @Override
    public void setParent(Item item, int damage) {
        super.setParent(item, damage);
        Data.addEnergy(this.newItemStack());
    }

    public void setGhostGroup(GhostGroup ghostGroup) {
        this.blockMalusSubCount += ghostGroup.size();
        this.ghostGroup = ghostGroup;
    }

    public void draw(float alpha, boolean haloState) {
        if (this.main != null) {
            this.main.draw();
        }
        if (this.rot != null) {
            this.rot.draw(alpha, 1.0f, 0.0f, 0.0f);
        }
        if (this.halo != null && haloState) {
            UtilsClient.disableLight();
            UtilsClient.enableBlend();
            UtilsClient.disableCulling();
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
            this.halo.draw();
            UtilsClient.enableCulling();
            UtilsClient.disableBlend();
            UtilsClient.enableLight();
        }
    }

    @Override
    public Direction getFrontFromPlace(Direction side, EntityLivingBase entityLiving) {
        return Direction.XN;
    }

    @Override
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type != IItemRenderer.ItemRenderType.INVENTORY;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            super.renderItem(type, item, data);
        } else {
            this.objItemScale(this.obj);
            Direction.ZN.glRotateXnRef();
            this.draw(0.0f, false);
        }
    }

    @Override
    public void addInformation(ItemStack itemStack, EntityPlayer entityPlayer, List<String> list, boolean par4) {
        super.addInformation(itemStack, entityPlayer, list, par4);
        list.add(I18N.tr("Generates energy from wind.", new Object[0]));
        list.add(I18N.tr("Voltage: %1$V", Utils.plotValue(this.maxVoltage)));
        list.add(I18N.tr("Power: %1$W", Utils.plotValue(this.nominalPower)));
        list.add(I18N.tr("Wind area:", new Object[0]));
        list.add("  " + I18N.tr("Front: %1$", this.rayX));
        list.add("  " + I18N.tr("Up/Down: %1$", this.rayY));
        list.add("  " + I18N.tr("Left/Right: %1$", this.rayZ));
    }
}

