/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.windturbine;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mods.eln.Eln;
import mods.eln.i18n.I18N;
import mods.eln.misc.Direction;
import mods.eln.misc.LRDU;
import mods.eln.misc.Utils;
import mods.eln.node.NodePeriodicPublishProcess;
import mods.eln.node.transparent.TransparentNode;
import mods.eln.node.transparent.TransparentNodeDescriptor;
import mods.eln.node.transparent.TransparentNodeElement;
import mods.eln.shadow.org.jetbrains.annotations.NotNull;
import mods.eln.shadow.org.jetbrains.annotations.Nullable;
import mods.eln.sim.ElectricalLoad;
import mods.eln.sim.ThermalLoad;
import mods.eln.sim.mna.component.PowerSource;
import mods.eln.sim.mna.state.State;
import mods.eln.sim.nbt.NbtElectricalLoad;
import mods.eln.transparentnode.windturbine.WindTurbineDescriptor;
import mods.eln.transparentnode.windturbine.WindTurbineSlowProcess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class WindTurbineElement
extends TransparentNodeElement {
    private final NbtElectricalLoad positiveLoad = new NbtElectricalLoad("positiveLoad");
    final PowerSource powerSource = new PowerSource("powerSource", (State)this.positiveLoad);
    private final WindTurbineSlowProcess slowProcess = new WindTurbineSlowProcess("slowProcess", this);
    final WindTurbineDescriptor descriptor;
    private Direction cableFront = Direction.ZP;

    public WindTurbineElement(TransparentNode transparentNode, TransparentNodeDescriptor descriptor) {
        super(transparentNode, descriptor);
        this.descriptor = (WindTurbineDescriptor)descriptor;
        this.electricalLoadList.add(this.positiveLoad);
        this.electricalComponentList.add(this.powerSource);
        this.slowProcessList.add(new NodePeriodicPublishProcess(transparentNode, 4.0, 4.0));
        this.slowProcessList.add(this.slowProcess);
    }

    @Override
    public ElectricalLoad getElectricalLoad(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return null;
        }
        if (side == this.cableFront.left()) {
            return this.positiveLoad;
        }
        return null;
    }

    @Override
    @Nullable
    public ThermalLoad getThermalLoad(@NotNull Direction side, @NotNull LRDU lrdu) {
        return null;
    }

    @Override
    public int getConnectionMask(Direction side, LRDU lrdu) {
        if (lrdu != LRDU.Down) {
            return 0;
        }
        if (side == this.cableFront.left()) {
            return 1;
        }
        if (side == this.cableFront.right() && !this.grounded) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    public String multiMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    @NotNull
    public String thermoMeterString(@NotNull Direction side) {
        return null;
    }

    @Override
    public void initialize() {
        this.setPhysicalValue();
        this.powerSource.setMaximumCurrent(this.descriptor.nominalPower * 5.0 / this.descriptor.maxVoltage);
        this.connect();
    }

    private void setPhysicalValue() {
        this.descriptor.cable.applyTo(this.positiveLoad);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, Direction side, float vx, float vy, float vz) {
        if (Utils.isPlayerUsingWrench(player)) {
            this.cableFront = this.cableFront.right();
            this.reconnect();
        }
        return false;
    }

    @Override
    public void networkSerialize(DataOutputStream stream) {
        super.networkSerialize(stream);
        try {
            stream.writeFloat((float)this.slowProcess.getWind());
            stream.writeFloat((float)(this.powerSource.getPower() / this.descriptor.nominalPower));
            this.node.lrduCubeMask.getTranslate(Direction.YN).serialize(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.cableFront.writeToNBT(nbt, "cableFront");
        Utils.println((Object)this.cableFront);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.cableFront = Direction.readFromNBT(nbt, "cableFront");
        Utils.println((Object)this.cableFront);
    }

    @Override
    @NotNull
    public Map<String, String> getWaila() {
        HashMap<String, String> wailaList = new HashMap<String, String>();
        wailaList.put(I18N.tr("Generating", new Object[0]), this.slowProcess.getWind() > 0.0 ? I18N.tr("Yes", new Object[0]) : I18N.tr("No", new Object[0]));
        wailaList.put(I18N.tr("Produced power", new Object[0]), Utils.plotPower("", this.powerSource.getEffectivePower()));
        if (Eln.wailaEasyMode) {
            wailaList.put("Voltage", Utils.plotVolt("", this.powerSource.getVoltage()));
        }
        return wailaList;
    }
}

