/*
 * Decompiled with CFR 0.152.
 */
package mods.eln.transparentnode.windturbine;

import mods.eln.misc.Coordinate;
import mods.eln.misc.INBTTReady;
import mods.eln.misc.Utils;
import mods.eln.sim.IProcess;
import mods.eln.transparentnode.windturbine.WindTurbineDescriptor;
import mods.eln.transparentnode.windturbine.WindTurbineElement;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

class WindTurbineSlowProcess
implements IProcess,
INBTTReady {
    private static final double environmentTimeCounterReset = 10.0;
    private static final double localWindTimeCounterReset = 1.0;
    private static final double localWindMax = 3.0;
    private static final double localWinDeriveLostFactor = 0.3;
    private static final double localWinDeriveDeriveMax = 0.1;
    private final WindTurbineElement turbine;
    private final String name;
    private double environmentWindFactor = 0.0;
    private double environmentTimeCounter = 0.0;
    private double localWind = 0.0;
    private double localWindDerive = 0.0;
    private double localWindTimeCounter = 0.0;
    private int counter = 0;

    WindTurbineSlowProcess(String name, WindTurbineElement turbine) {
        this.turbine = turbine;
        this.name = name;
    }

    double getWind() {
        return Math.abs(this.localWind + Utils.getWind(this.turbine.node.coordinate.dimension, this.turbine.node.coordinate.y + this.turbine.descriptor.offY)) * this.environmentWindFactor;
    }

    void setWind(double wind) {
        this.localWind = wind;
    }

    @Override
    public void process(double time) {
        WindTurbineDescriptor d = this.turbine.descriptor;
        this.environmentTimeCounter -= time;
        if (this.environmentTimeCounter < 0.0) {
            this.environmentTimeCounter += 10.0 * (0.75 + Math.random() * 0.5);
            Coordinate coord = new Coordinate(this.turbine.node.coordinate);
            int x1 = coord.x - d.rayX;
            int x2 = coord.x + d.rayX;
            int y1 = coord.y - d.rayY + d.offY;
            int y2 = coord.y + d.rayY + d.offY;
            int z1 = coord.z - d.rayZ;
            int z2 = coord.z + d.rayZ;
            int blockBusyCount = -d.blockMalusSubCount;
            boolean notInCache = false;
            if (this.turbine.node.coordinate.getWorldExist()) {
                World world = this.turbine.node.coordinate.world();
                for (int x = x1; x <= x2; ++x) {
                    for (int y = y1; y <= y2; ++y) {
                        for (int z = z1; z <= z2; ++z) {
                            if (!world.func_72899_e(x, y, z)) {
                                notInCache = true;
                                break;
                            }
                            if (world.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                            ++blockBusyCount;
                        }
                        if (notInCache) break;
                    }
                    if (!notInCache) {
                        continue;
                    }
                    break;
                }
            } else {
                notInCache = true;
            }
            if (!notInCache) {
                this.environmentWindFactor = Math.max(0.0, Math.min(1.0, 1.0 - (double)blockBusyCount * d.blockMalus));
                Utils.println("EnvironementWindFactor : " + this.environmentWindFactor);
            }
        }
        this.localWindTimeCounter -= time;
        if (this.localWindTimeCounter < 0.0) {
            this.localWindTimeCounter += 1.0;
            this.localWindDerive *= 0.7;
            this.localWindDerive += (Math.random() * 2.0 - 1.0) * 0.1 * 1.0;
        }
        this.localWind += this.localWindDerive * time;
        if (this.localWind > 3.0) {
            this.localWind = 3.0;
            this.localWindDerive = 0.0;
        }
        if (this.localWind < -3.0) {
            this.localWind = -3.0;
            this.localWindDerive = 0.0;
        }
        this.localWind = 0.0;
        double wind = this.getWind();
        double P = d.PfW.getValue(wind);
        this.turbine.powerSource.setPower(P);
        this.turbine.powerSource.setMaximumVoltage(d.maxVoltage);
        ++this.counter;
        if (this.counter % 20 == 0) {
            Utils.println("Wind : " + this.getWind() + "  Derivate : " + this.localWindDerive + " EPmax : " + P);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String str) {
        this.localWind = nbt.func_74769_h(str + this.name + "localWind");
        this.environmentWindFactor = nbt.func_74769_h(str + this.name + "environementWindFactor");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String str) {
        nbt.func_74780_a(str + this.name + "localWind", this.localWind);
        nbt.func_74780_a(str + this.name + "environementWindFactor", this.environmentWindFactor);
    }
}

