/*
 * Decompiled with CFR 0.152.
 */
package train.client.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;
import train.common.api.DieselTrain;
import train.common.api.Locomotive;
import train.common.api.SteamTrain;

public class HUDloco
extends GuiScreen {
    private Minecraft game;
    private int windowWidth;
    private int windowHeight;

    @SubscribeEvent
    public void onGameRender(RenderGameOverlayEvent.Text event) {
        if (this.game != null && this.game.field_71439_g != null && this.game.field_71439_g.field_70154_o != null && this.game.field_71439_g.field_70154_o instanceof Locomotive && Minecraft.func_71382_s() && this.game.field_71462_r == null) {
            this.renderSkillHUD((RenderGameOverlayEvent)event, (Locomotive)this.game.field_71439_g.field_70154_o);
        } else {
            this.game = this.field_146297_k = Minecraft.func_71410_x();
            this.field_146289_q = this.game.field_71466_p;
        }
    }

    public void renderSkillHUD(RenderGameOverlayEvent event, Locomotive rcCar) {
        this.windowWidth = event.resolution.func_78326_a();
        this.windowHeight = event.resolution.func_78328_b() - 100;
        this.renderBG(rcCar);
        if (rcCar instanceof SteamTrain) {
            this.renderWaterBar(rcCar);
        }
        if (rcCar.canOverheat()) {
            this.renderOverheating(rcCar);
        }
        this.renderSpeedometer(rcCar);
        this.renderFuelBar(rcCar);
        this.renderText(rcCar);
    }

    private void renderBG(Locomotive rcCar) {
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        this.field_73735_i = -90.0f;
        if (rcCar instanceof SteamTrain) {
            this.game.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/loco_hud_steam.png"));
        } else {
            this.game.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/locohud.png"));
        }
        this.func_73729_b(10, this.windowHeight, 0, 150, 137, 90);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
    }

    private void renderText(Locomotive loco) {
        double speed = loco.getSpeed();
        int h = loco instanceof SteamTrain ? 15 : 13;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        this.field_146289_q.func_78261_a("Speed:", 106, this.windowHeight + 7 + h, 0xFFFFFF);
        this.field_146289_q.func_78261_a("  " + (int)Math.abs((float)speed), 106, this.windowHeight + 18 + h, 0xFFFFFF);
        this.field_146289_q.func_78261_a(" Km/h", 106, this.windowHeight + 29 + h, 0xFFFFFF);
        if (loco.canOverheat()) {
            this.field_146289_q.func_78261_a("State: " + loco.getState(), 50, this.windowHeight + 80, 0xFFFFFF);
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
    }

    private void renderFuelBar(Locomotive loco) {
        int l;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        if (loco instanceof DieselTrain) {
            l = ((DieselTrain)loco).getDiesel();
            l = Math.abs(l * 70 / ((DieselTrain)loco).getCartTankCapacity());
        } else {
            l = loco.getFuelDiv(70);
        }
        if (l > 70) {
            l = 70;
        }
        if (l < 0) {
            l = 0;
        }
        int t = 70 - l;
        if (loco instanceof SteamTrain) {
            this.game.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/loco_hud_steam.png"));
        } else {
            this.game.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/locohud.png"));
        }
        if (!(loco instanceof SteamTrain)) {
            this.func_73729_b(28, this.windowHeight + 11, 148, 150 + l, 7, t);
        } else {
            this.func_73729_b(34, this.windowHeight + 17, 154, 170 + l, 9, t);
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
    }

    private void renderWaterBar(Locomotive loco) {
        int l = ((SteamTrain)loco).getWater();
        int l_Scaled = Math.abs(l * 49 / ((SteamTrain)loco).getCartTankCapacity());
        if (l_Scaled > 49) {
            l_Scaled = 49;
        }
        if (l_Scaled < 0) {
            l_Scaled = 0;
        }
        int t = 49 - l_Scaled;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        this.func_73729_b(70, this.windowHeight + 17, 190, 169 + l_Scaled, 6, t);
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
        if (l <= 1 && loco.getIsFuelled()) {
            this.func_73733_a(0, 0, this.windowWidth, this.windowHeight + 100, 0x60500000, -1602211792);
        }
    }

    private void renderSpeedometer(Locomotive loco) {
        double speed = loco.getSpeed();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        if (loco instanceof SteamTrain) {
            this.game.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/loco_hud_steam.png"));
        } else {
            this.game.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/locohud.png"));
        }
        double speedScaled = Math.abs(speed * 49.0 / 280.0);
        if (speedScaled > 49.0) {
            speedScaled = 49.0;
        }
        if (!(loco instanceof SteamTrain)) {
            this.func_73729_b(75, this.windowHeight + 37 - (int)speedScaled + 20, 163, 150, 30, 5);
        } else {
            this.func_73729_b(84, this.windowHeight + 37 - (int)speedScaled + 20, 177, 149, 16, 8);
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
    }

    private void renderOverheating(Locomotive loco) {
        double overheatLevel = loco.getOverheatLevel();
        if (overheatLevel > (double)(loco.getOverheatTime() + 30)) {
            overheatLevel = loco.getOverheatTime() + 30;
        }
        GL11.glEnable((int)3042);
        GL11.glEnable((int)32826);
        if (loco instanceof SteamTrain) {
            this.game.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/loco_hud_steam.png"));
        } else {
            this.game.field_71446_o.func_110577_a(new ResourceLocation("tc", "textures/gui/locohud.png"));
        }
        double overheatScaled = Math.abs(overheatLevel * 49.0 / (double)(loco.getOverheatTime() + 30));
        if (overheatScaled > 49.0) {
            overheatScaled = 49.0;
        }
        int t = (int)(49.0 - overheatScaled);
        if (!(loco instanceof SteamTrain)) {
            this.func_73729_b(58, this.windowHeight + 37 - (int)overheatScaled + 20, 169, 158, 23, 5);
        } else {
            this.func_73729_b(56, this.windowHeight + 17, 176, (int)(169.0 + overheatScaled), 5, t);
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)3042);
    }
}

