/*
 * Decompiled with CFR 0.152.
 */
package train.client.render;

import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;
import train.client.render.CustomTexturedQuad;

public class CustomModelRenderer {
    private CustomTexturedQuad[] faces;
    private int textureOffsetX;
    private int textureOffsetY;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled = false;
    private int displayList = 0;
    public boolean mirror = false;
    private int texWidth;
    private int texHeight;

    public CustomModelRenderer(int i, int j, int w, int h) {
        this.textureOffsetX = i;
        this.textureOffsetY = j;
        this.texWidth = w;
        this.texHeight = h;
    }

    public void addBox(float f, float f1, float f2, int i, int j, int k) {
        this.addBox(f, f1, f2, i, j, k, 0.0f);
    }

    public void addBox(float f, float f1, float f2, int i, int j, int k, float f3) {
        this.faces = new CustomTexturedQuad[6];
        float f4 = f + (float)i;
        float f5 = f1 + (float)j;
        float f6 = f2 + (float)k;
        f -= f3;
        f1 -= f3;
        f2 -= f3;
        f4 += f3;
        f5 += f3;
        f6 += f3;
        if (this.mirror) {
            float f7 = f4;
            f4 = f;
            f = f7;
        }
        PositionTextureVertex positiontexturevertex = new PositionTextureVertex(f, f1, f2, 0.0f, 0.0f);
        PositionTextureVertex positiontexturevertex1 = new PositionTextureVertex(f4, f1, f2, 0.0f, 8.0f);
        PositionTextureVertex positiontexturevertex2 = new PositionTextureVertex(f4, f5, f2, 8.0f, 8.0f);
        PositionTextureVertex positiontexturevertex3 = new PositionTextureVertex(f, f5, f2, 8.0f, 0.0f);
        PositionTextureVertex positiontexturevertex4 = new PositionTextureVertex(f, f1, f6, 0.0f, 0.0f);
        PositionTextureVertex positiontexturevertex5 = new PositionTextureVertex(f4, f1, f6, 0.0f, 8.0f);
        PositionTextureVertex positiontexturevertex6 = new PositionTextureVertex(f4, f5, f6, 8.0f, 8.0f);
        PositionTextureVertex positiontexturevertex7 = new PositionTextureVertex(f, f5, f6, 8.0f, 0.0f);
        this.faces[0] = new CustomTexturedQuad(new PositionTextureVertex[]{positiontexturevertex5, positiontexturevertex1, positiontexturevertex2, positiontexturevertex6}, this.textureOffsetX + k + i, this.textureOffsetY + k, this.textureOffsetX + k + i + k, this.textureOffsetY + k + j, this.texWidth, this.texHeight);
        this.faces[1] = new CustomTexturedQuad(new PositionTextureVertex[]{positiontexturevertex, positiontexturevertex4, positiontexturevertex7, positiontexturevertex3}, this.textureOffsetX, this.textureOffsetY + k, this.textureOffsetX + k, this.textureOffsetY + k + j, this.texWidth, this.texHeight);
        this.faces[2] = new CustomTexturedQuad(new PositionTextureVertex[]{positiontexturevertex5, positiontexturevertex4, positiontexturevertex, positiontexturevertex1}, this.textureOffsetX + k, this.textureOffsetY, this.textureOffsetX + k + i, this.textureOffsetY + k, this.texWidth, this.texHeight);
        this.faces[3] = new CustomTexturedQuad(new PositionTextureVertex[]{positiontexturevertex2, positiontexturevertex3, positiontexturevertex7, positiontexturevertex6}, this.textureOffsetX + k + i, this.textureOffsetY, this.textureOffsetX + k + i + i, this.textureOffsetY + k, this.texWidth, this.texHeight);
        this.faces[4] = new CustomTexturedQuad(new PositionTextureVertex[]{positiontexturevertex1, positiontexturevertex, positiontexturevertex3, positiontexturevertex2}, this.textureOffsetX + k, this.textureOffsetY + k, this.textureOffsetX + k + i, this.textureOffsetY + k + j, this.texWidth, this.texHeight);
        this.faces[5] = new CustomTexturedQuad(new PositionTextureVertex[]{positiontexturevertex4, positiontexturevertex5, positiontexturevertex6, positiontexturevertex7}, this.textureOffsetX + k + i + k, this.textureOffsetY + k, this.textureOffsetX + k + i + k + i, this.textureOffsetY + k + j, this.texWidth, this.texHeight);
        if (this.mirror) {
            for (CustomTexturedQuad quad : this.faces) {
                quad.flipFace();
            }
        }
    }

    public void setPosition(float f, float f1, float f2) {
        this.offsetX = f;
        this.offsetY = f1;
        this.offsetZ = f2;
    }

    public void render(float f) {
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.offsetX * f), (float)(this.offsetY * f), (float)(this.offsetZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glCallList((int)this.displayList);
            GL11.glPopMatrix();
        } else if (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            GL11.glTranslatef((float)(this.offsetX * f), (float)(this.offsetY * f), (float)(this.offsetZ * f));
            GL11.glCallList((int)this.displayList);
            GL11.glTranslatef((float)(-this.offsetX * f), (float)(-this.offsetY * f), (float)(-this.offsetZ * f));
        } else {
            GL11.glCallList((int)this.displayList);
        }
    }

    public void postRender(float f) {
        if (!this.compiled) {
            this.compileDisplayList(f);
        }
        if (this.rotateAngleX != 0.0f || this.rotateAngleY != 0.0f || this.rotateAngleZ != 0.0f) {
            GL11.glTranslatef((float)(this.offsetX * f), (float)(this.offsetY * f), (float)(this.offsetZ * f));
            if (this.rotateAngleZ != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleZ * 57.29578f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.rotateAngleY != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleY * 57.29578f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.rotateAngleX != 0.0f) {
                GL11.glRotatef((float)(this.rotateAngleX * 57.29578f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        } else if (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            GL11.glTranslatef((float)(this.offsetX * f), (float)(this.offsetY * f), (float)(this.offsetZ * f));
        }
    }

    private void compileDisplayList(float f) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        for (CustomTexturedQuad quad : this.faces) {
            quad.draw(Tessellator.field_78398_a, f);
        }
        GL11.glEndList();
        this.compiled = true;
    }
}

