/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import cofh.api.energy.IEnergyContainerItem;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import train.common.api.Locomotive;

public abstract class ElectricTrain
extends Locomotive {
    private int timeSinceIgnited;
    private boolean Ignite;
    private boolean hasUranium;
    private int reduceExplosionChance;
    public int maxEnergy = 10000;
    private int redstoneEnergy = 2000;

    public ElectricTrain(World world) {
        super(world);
        this.fuelTrain = 0;
        this.numCargoSlots = 5;
        this.numCargoSlots1 = 5;
        this.numCargoSlots2 = 5;
        this.inventorySize = this.numCargoSlots + this.numCargoSlots2 + this.numCargoSlots1 + 1;
        this.locoInvent = new ItemStack[this.inventorySize];
        this.hasUranium = false;
        this.reduceExplosionChance = 1000;
        this.Ignite = false;
        this.timeSinceIgnited = 0;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.setState("hot");
        if (this.field_70146_Z.nextInt(4) == 0 && this.Ignite) {
            ++this.timeSinceIgnited;
        }
        if (!this.canCheckInvent) {
            return;
        }
        if (this.getFuel() < this.maxEnergy && this.locoInvent[0] != null) {
            Item item = this.locoInvent[0].func_77973_b();
            if (item == Items.field_151137_ax && this.getFuel() + this.redstoneEnergy <= this.maxEnergy) {
                this.fuelTrain += this.redstoneEnergy;
                this.func_70298_a(0, 1);
            } else if (item instanceof IEnergyContainerItem) {
                double RFtoRE = 10.0;
                double REtoRF = 0.1;
                int maxDraw = 200;
                int draw = MathHelper.func_76128_c((double)((double)Math.min(200, this.maxEnergy - this.getFuel()) * 0.1));
                this.fuelTrain = (int)((double)this.fuelTrain + (double)((IEnergyContainerItem)item).extractEnergy(this.locoInvent[0], draw, false) * 10.0);
            }
        }
    }

    @Override
    protected void updateFuelTrain(int amount) {
        this.reduceExplosionChance = 1000;
        if (this.fuelTrain < 0) {
            this.hasUranium = false;
            this.field_70159_w *= 0.8;
            this.field_70179_y *= 0.8;
        } else if (this.isLocoTurnedOn()) {
            this.fuelTrain -= amount;
            if (this.fuelTrain < 0) {
                this.fuelTrain = 0;
            }
        }
        if (this.hasUranium && this.field_70146_Z.nextInt(this.reduceExplosionChance) == 0 && !this.Ignite) {
            this.Ignite = true;
            this.func_70015_d(8);
            this.field_70170_p.func_72956_a((Entity)this, "random.fuse", 1.0f, 0.5f);
        }
        if (this.Ignite && this.timeSinceIgnited == 100) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 200.0f, true);
            this.Ignite = false;
            this.hasUranium = false;
            this.field_70128_L = true;
        }
    }

    @Override
    public int getFuelDiv(int i) {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) * i / this.maxEnergy;
        }
        return this.fuelTrain * i / this.maxEnergy;
    }

    @Override
    public boolean canOverheat() {
        return false;
    }
}

