/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import train.common.Traincraft;
import train.common.api.EntityRollingStock;
import train.common.api.SteamTrain;
import train.common.core.HandleMaxAttachedCarts;
import train.common.core.handlers.ConfigHandler;
import train.common.core.network.PacketSlotsFilled;
import train.common.library.EnumSounds;

public abstract class Locomotive
extends EntityRollingStock
implements IInventory {
    public int inventorySize;
    public double speedDivider = 3.6;
    protected ItemStack[] locoInvent;
    private int soundPosition = 0;
    public boolean parkingBrake = false;
    private int whistleDelay = 0;
    private int blowUpDelay = 0;
    private String lastRider = "";
    private Entity lastEntityRider;
    public int numCargoSlots;
    public int numCargoSlots1;
    public int numCargoSlots2;
    private boolean hasDrowned = false;
    protected boolean canCheckInvent = true;
    private int slotsFilled = 0;
    private int fuelUpdateTicks = 0;
    public boolean isLocoTurnedOn = false;
    private String locoState = "";
    protected boolean canBeAdjusted = false;
    public int currentNumCartsPulled = 0;
    public double currentMassPulled = 0.0;
    public double currentSpeedSlowDown = 0.0;
    public double currentAccelSlowDown = 0.0;
    public double currentBrakeSlowDown = 0.0;
    public double currentFuelConsumptionChange = 0.0;
    protected int fuelRate;
    public boolean canBePulled = false;
    public HandleMaxAttachedCarts maxAttached = new HandleMaxAttachedCarts();

    public Locomotive(World world) {
        super(world);
        this.setFuelConsumption(0);
        this.inventorySize = this.numCargoSlots + this.numCargoSlots2 + this.numCargoSlots1;
        this.field_70180_af.func_75682_a(2, (Object)0);
        this.setDefaultMass(0.0);
        this.setCustomSpeed(this.getMaxSpeed());
        this.field_70180_af.func_75682_a(3, (Object)this.destination);
        this.field_70180_af.func_75682_a(22, (Object)this.locoState);
        this.field_70180_af.func_75682_a(24, (Object)this.fuelTrain);
        this.field_70180_af.func_75682_a(25, (Object)((int)this.convertSpeed(Math.sqrt(Math.abs(this.field_70159_w * this.field_70159_w) + Math.abs(this.field_70179_y * this.field_70179_y)))));
        this.field_70180_af.func_75682_a(26, (Object)this.castToString(this.currentNumCartsPulled));
        this.field_70180_af.func_75682_a(27, (Object)this.castToString(this.currentMassPulled));
        this.field_70180_af.func_75682_a(28, (Object)this.castToString(Math.round(this.currentSpeedSlowDown)));
        this.field_70180_af.func_75682_a(29, (Object)this.castToString(this.currentAccelSlowDown));
        this.field_70180_af.func_75682_a(30, (Object)this.castToString(this.currentBrakeSlowDown));
        this.field_70180_af.func_75682_a(31, (Object)this.castToString(this.currentFuelConsumptionChange));
        this.field_70180_af.func_75682_a(15, (Object)this.castToString(Math.round(this.getCustomSpeed() * 3.6)));
        this.setAccel(0.0);
        this.setBrake(0.0);
        this.field_70144_Y = 0.99f;
        if (this instanceof SteamTrain) {
            this.isLocoTurnedOn = true;
        }
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.isLocoTurnedOn = additionalData.readBoolean();
        this.parkingBrake = additionalData.readBoolean();
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.isLocoTurnedOn);
        buffer.writeBoolean(this.parkingBrake);
    }

    private String castToString(double str) {
        return "" + str;
    }

    @Override
    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public boolean canBeRidden() {
        return true;
    }

    @Override
    public boolean isLinkable() {
        return false;
    }

    @Override
    public boolean isStorageCart() {
        return false;
    }

    protected int getCurrentMaxSpeed() {
        return this.field_70180_af.func_75679_c(2);
    }

    protected void setCurrentMaxSpeed(int maxSpeed) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(2, (Object)maxSpeed);
        }
    }

    public void setCustomSpeed(double m) {
        if (m != 0.0) {
            this.setCurrentMaxSpeed((int)m);
            return;
        }
        this.setCurrentMaxSpeed((int)this.getMaxSpeed());
    }

    public double getMaxSpeed() {
        if (this.trainSpec != null) {
            return this.trainSpec.getMaxSpeed();
        }
        return 50.0;
    }

    public double getCustomSpeed() {
        return (double)this.getCurrentMaxSpeed() / this.speedDivider;
    }

    @Override
    public boolean canOverheat() {
        return this.getOverheatTime() > 0;
    }

    @Override
    public int getOverheatTime() {
        if (this.trainSpec != null) {
            return this.trainSpec.getHeatingTime();
        }
        return 0;
    }

    public int setFuelConsumption(int c) {
        if (c != 0) {
            this.fuelRate = c;
            return this.fuelRate;
        }
        if (this.trainSpec != null) {
            this.fuelRate = this.trainSpec.getFuelConsumption();
            return this.fuelRate;
        }
        return 0;
    }

    public int getFuelConsumption() {
        return this.fuelRate;
    }

    public int getPower() {
        if (this.trainSpec != null) {
            return this.trainSpec.getMHP();
        }
        return 0;
    }

    public double setAccel(double rate) {
        if (rate != 0.0) {
            this.accelerate = rate;
            return this.accelerate;
        }
        if (this.trainSpec != null) {
            this.accelerate = this.trainSpec.getAccelerationRate();
            return this.accelerate;
        }
        return 0.45;
    }

    public double setBrake(double rate) {
        if (rate != 0.0) {
            this.brake = rate;
            return this.brake;
        }
        if (this.trainSpec != null) {
            this.brake = this.trainSpec.getBrakeRate();
            return this.brake;
        }
        return 0.98;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("canBeAdjusted", this.canBeAdjusted);
        nbttagcompound.func_74757_a("canBePulled", this.canBePulled);
        nbttagcompound.func_74768_a("overheatLevel", this.getOverheatLevel());
        nbttagcompound.func_74778_a("lastRider", this.lastRider);
        nbttagcompound.func_74778_a("destination", this.destination);
        nbttagcompound.func_74757_a("parkingBrake", this.parkingBrake);
        if (!(this instanceof SteamTrain)) {
            nbttagcompound.func_74757_a("isLocoTurnedOn", this.isLocoTurnedOn);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.canBeAdjusted = nbttagcompound.func_74767_n("canBeAdjusted");
        this.canBePulled = nbttagcompound.func_74767_n("canBePulled");
        this.setOverheatLevel(nbttagcompound.func_74762_e("overheatLevel"));
        this.lastRider = nbttagcompound.func_74779_i("lastRider");
        this.destination = nbttagcompound.func_74779_i("destination");
        this.parkingBrake = nbttagcompound.func_74767_n("parkingBrake");
        if (!(this instanceof SteamTrain)) {
            this.isLocoTurnedOn = nbttagcompound.func_74767_n("isLocoTurnedOn");
        }
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    public void setCanBeAdjusted(boolean canBeAdj) {
        this.canBeAdjusted = canBeAdj;
    }

    @Override
    public void keyHandlerFromPacket(int i) {
        if (this.getTrainLockedFromPacket() && this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && !((EntityPlayer)this.field_70153_n).getDisplayName().toLowerCase().equals(this.getTrainOwner().toLowerCase())) {
            return;
        }
        this.pressKey(i);
        if (i == 8 && ConfigHandler.SOUNDS) {
            this.soundHorn();
        }
    }

    public String getCurrentNumCartsPulled() {
        return this.field_70180_af.func_75681_e(26);
    }

    public String getCurrentMassPulled() {
        return this.field_70180_af.func_75681_e(27);
    }

    public String getCurrentSpeedSlowDown() {
        return this.field_70180_af.func_75681_e(28);
    }

    public String getCurrentAccelSlowDown() {
        return this.field_70180_af.func_75681_e(29);
    }

    public String getCurrentBrakeSlowDown() {
        return this.field_70180_af.func_75681_e(30);
    }

    public String getCurrentFuelConsumptionChange() {
        return this.field_70180_af.func_75681_e(31);
    }

    public String getCustomSpeedGUI() {
        return this.field_70180_af.func_75681_e(15);
    }

    public String getDestinationGUI() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75681_e(3);
        }
        return this.destination;
    }

    private double convertSpeed(double speed) {
        speed = ConfigHandler.REAL_TRAIN_SPEED ? (speed *= 2.0) : (speed *= 6.0);
        speed *= 10.0;
        return speed *= 3.6;
    }

    public void soundHorn() {
        for (EnumSounds sounds : EnumSounds.values()) {
            if (sounds.getEntityClass() == null || !sounds.getEntityClass().equals(this.getClass()) || this.whistleDelay != 0) continue;
            this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getHornString(), sounds.getHornVolume().floatValue(), 1.0f);
            this.whistleDelay = 65;
        }
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70153_n instanceof EntityLivingBase) {
                EntityLivingBase entity = (EntityLivingBase)this.field_70153_n;
                if (entity.field_70701_bs > 0.0f) {
                    if (this.getFuel() > 0 && this.isLocoTurnedOn() && this.field_70146_Z.nextInt(4) == 0 && !this.field_70170_p.field_72995_K) {
                        if (this.getTrainLockedFromPacket() && !((EntityPlayer)this.field_70153_n).getDisplayName().toLowerCase().equals(this.getTrainOwner().toLowerCase())) {
                            return;
                        }
                        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
                            int dir = MathHelper.func_76128_c((double)((double)(((EntityPlayer)this.field_70153_n).field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                            if (dir == 2) {
                                this.field_70179_y -= 0.01 * (double)entity.field_70701_bs * this.accelerate;
                            }
                            if (dir == 1) {
                                this.field_70159_w -= 0.01 * (double)entity.field_70701_bs * this.accelerate;
                            }
                            if (dir == 0) {
                                this.field_70179_y += 0.01 * (double)entity.field_70701_bs * this.accelerate;
                            }
                            if (dir == 3) {
                                this.field_70159_w += 0.01 * (double)entity.field_70701_bs * this.accelerate;
                            }
                        }
                    }
                } else if (entity.field_70701_bs < 0.0f) {
                    this.field_70159_w *= (double)(-entity.field_70701_bs) * this.brake;
                    this.field_70179_y *= (double)(-entity.field_70701_bs) * this.brake;
                }
            }
            if (this.updateTicks % 20 == 0) {
                this.maxAttached.PullPhysic((Entity)this);
            }
            if (this.updateTicks % 200 == 0) {
                this.slotsFilled = 0;
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    ItemStack itemstack = this.func_70301_a(i);
                    if (itemstack == null) continue;
                    ++this.slotsFilled;
                }
                Traincraft.slotschannel.sendToAllAround((IMessage)new PacketSlotsFilled(this, this.slotsFilled), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
            }
            int consumption = this.getFuelConsumption();
            if (this.fuelUpdateTicks >= 100) {
                this.fuelUpdateTicks = 0;
                this.updateFuelTrain(consumption);
            }
            ++this.fuelUpdateTicks;
            if (!this.isLocoTurnedOn()) {
                this.field_70159_w *= 0.0;
                this.field_70179_y *= 0.0;
            }
        }
        if (this.whistleDelay > 0) {
            --this.whistleDelay;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
            this.lastRider = ((EntityPlayer)this.field_70153_n).getDisplayName();
            this.lastEntityRider = this.field_70153_n;
        }
        if (!this.field_70170_p.field_72995_K && this.getParkingBrakeFromPacket() && !this.getState().equals("broken")) {
            this.field_70159_w *= 0.0;
            this.field_70179_y *= 0.0;
        }
        if (ConfigHandler.SOUNDS) {
            for (EnumSounds sounds : EnumSounds.values()) {
                if (sounds.getEntityClass() == null || !sounds.getEntityClass().equals(this.getClass())) continue;
                if (this.getFuel() <= 0 || !this.isLocoTurnedOn()) break;
                double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
                if (speed > -0.001 && speed < 0.01 && this.soundPosition == 0) {
                    this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getIdleString(), sounds.getIdleVolume().floatValue(), 0.001f);
                    this.soundPosition = sounds.getIdleSoundLenght();
                }
                if (sounds.getSoundChangeWithSpeed()) {
                    if (speed > 0.01 && speed < 0.06 && this.soundPosition == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.1f);
                        this.soundPosition = sounds.getRunSoundLenght();
                    } else if (speed > 0.06 && speed < 0.2 && this.soundPosition == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.4f);
                        this.soundPosition = sounds.getRunSoundLenght() / 2;
                    } else if (speed > 0.2 && this.soundPosition == 0) {
                        this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.5f);
                        this.soundPosition = sounds.getRunSoundLenght() / 3;
                    }
                } else if (speed > 0.01 && this.soundPosition == 0) {
                    this.field_70170_p.func_72956_a((Entity)this, "tc:" + sounds.getRunString(), sounds.getRunVolume().floatValue(), 0.4f);
                    this.soundPosition = sounds.getRunSoundLenght();
                }
                if (this.soundPosition <= 0) break;
                --this.soundPosition;
                break;
            }
        }
        if (this.getState().equals("cold")) {
            this.func_70066_B();
            if ((double)this.getCurrentMaxSpeed() >= this.getMaxSpeed() * 0.6) {
                this.field_70159_w *= 0.0;
                this.field_70179_y *= 0.0;
            }
        }
        if (this.getState().equals("warm")) {
            this.func_70066_B();
            if ((double)this.getCurrentMaxSpeed() >= this.getMaxSpeed() * 0.7) {
                this.field_70159_w *= 0.94;
                this.field_70179_y *= 0.94;
            }
        }
        if (this.getState().equals("hot")) {
            this.func_70066_B();
        }
        if (this.getState().equals("too hot")) {
            this.field_70159_w *= 0.95;
            this.field_70179_y *= 0.95;
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        if (this.getState().equals("broken")) {
            this.func_70015_d(8);
            this.setCustomSpeed(0.0);
            this.setAccel(1.0E-6);
            this.setBrake(1.0);
            this.field_70159_w *= 0.97;
            this.field_70179_y *= 0.97;
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.0, 0.0);
            this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.0, 0.0);
            ++this.blowUpDelay;
            if (this.blowUpDelay > 80) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5f, false);
                    this.func_70106_y();
                }
                if (!this.field_70170_p.field_72995_K && FMLCommonHandler.instance().getMinecraftServerInstance() != null && this.lastEntityRider != null && this.lastEntityRider instanceof EntityPlayer) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " blew " + this.getTrainOwner() + "'s locomotive"));
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " blew " + this.getTrainOwner() + "'s locomotive"));
                }
            }
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(25, (Object)((int)this.convertSpeed(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))));
            this.field_70180_af.func_75692_b(24, (Object)this.fuelTrain);
            this.field_70180_af.func_75692_b(20, (Object)this.overheatLevel);
            this.field_70180_af.func_75692_b(22, (Object)this.locoState);
            this.field_70180_af.func_75692_b(3, (Object)this.destination);
            this.field_70180_af.func_75692_b(26, (Object)this.castToString(this.currentNumCartsPulled));
            this.field_70180_af.func_75692_b(27, (Object)(this.castToString(this.currentMassPulled) + " tons"));
            this.field_70180_af.func_75692_b(28, (Object)(this.castToString((int)this.currentSpeedSlowDown) + " km/h"));
            this.field_70180_af.func_75692_b(29, (Object)this.castToString((double)Math.round(this.currentAccelSlowDown * 1000.0) / 1000.0));
            this.field_70180_af.func_75692_b(30, (Object)this.castToString((double)Math.round(this.currentBrakeSlowDown * 1000.0) / 1000.0));
            this.field_70180_af.func_75692_b(31, (Object)("1c/" + this.castToString((int)this.currentFuelConsumptionChange) + " per tick"));
            this.field_70180_af.func_75692_b(15, (Object)(this.castToString((int)(this.getCustomSpeed() * 3.6)) + " km/h"));
            if (this.field_70170_p.func_72918_a(this.field_70121_D.func_72314_b(0.0, -0.2000000059604645, 0.0).func_72331_e(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)this) && this.updateTicks % 4 == 0) {
                if (!this.hasDrowned && !this.field_70170_p.field_72995_K && FMLCommonHandler.instance().getMinecraftServerInstance() != null && this.lastEntityRider != null && this.lastEntityRider instanceof EntityPlayer) {
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " drowned " + this.getTrainOwner() + "'s locomotive"));
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(((EntityPlayer)this.lastEntityRider).getDisplayName() + " drowned " + this.getTrainOwner() + "'s locomotive"));
                }
                this.setCustomSpeed(0.0);
                this.setAccel(1.0E-6);
                this.setBrake(1.0);
                this.field_70159_w *= 0.97;
                this.field_70179_y *= 0.97;
                this.fuelTrain = 0;
                this.hasDrowned = true;
                this.canCheckInvent = false;
                ++this.blowUpDelay;
                if (this.blowUpDelay > 20) {
                    this.func_70097_a(DamageSource.field_76369_e, 100.0f);
                }
            }
        }
    }

    @Override
    protected void applyDragAndPushForces() {
        this.field_70159_w *= this.getDragAir();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDragAir();
    }

    @Override
    public double getDragAir() {
        return 1.0;
    }

    public boolean getParkingBrakeFromPacket() {
        return this.parkingBrake;
    }

    public void setParkingBrakeFromPacket(boolean set) {
        this.parkingBrake = set;
    }

    public double getSpeed() {
        return this.field_70180_af.func_75679_c(25);
    }

    @Override
    public int getOverheatLevel() {
        return this.field_70180_af.func_75679_c(20);
    }

    public String getState() {
        return this.field_70180_af.func_75681_e(22);
    }

    public void setState(String state) {
        this.locoState = state;
        this.field_70180_af.func_75692_b(22, (Object)state);
    }

    public int getFuel() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24);
        }
        return this.fuelTrain;
    }

    public boolean getIsFuelled() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) > 0;
        }
        return this.fuelTrain > 0;
    }

    public int getFuelDiv(int i) {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24) * i / 1200;
        }
        return this.fuelTrain * i / 1200;
    }

    protected void updateFuelTrain(int consumption) {
        if (this.fuelTrain < 0) {
            this.field_70159_w *= 0.8;
            this.field_70179_y *= 0.8;
        } else if (this.isLocoTurnedOn()) {
            this.fuelTrain -= consumption;
            if (this.fuelTrain < 0) {
                this.fuelTrain = 0;
            }
        }
    }

    public void setLocoTurnedOnFromPacket(boolean set) {
        this.isLocoTurnedOn = set;
    }

    public boolean isLocoTurnedOn() {
        return this.isLocoTurnedOn;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                this.dropCartAsItem(((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d);
            } else {
                this.dropCartAsItem(false);
            }
        }
        return true;
    }

    @Override
    public void dropCartAsItem(boolean isCreative) {
        super.dropCartAsItem(isCreative);
        for (ItemStack stack : this.locoInvent) {
            if (stack == null) continue;
            this.func_70099_a(stack, 0.0f);
        }
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        if (ticket != null) {
            this.destination = Locomotive.getTicketDestination(ticket);
            return true;
        }
        return false;
    }

    public ItemStack func_70301_a(int i) {
        return this.locoInvent[i];
    }

    public ItemStack func_70304_b(int par1) {
        if (this.locoInvent[par1] != null) {
            ItemStack var2 = this.locoInvent[par1];
            this.locoInvent[par1] = null;
            return var2;
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.locoInvent[i] != null) {
            if (this.locoInvent[i].field_77994_a <= j) {
                ItemStack itemstack = this.locoInvent[i];
                this.locoInvent[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.locoInvent[i].func_77979_a(j);
            if (this.locoInvent[i].field_77994_a == 0) {
                this.locoInvent[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.locoInvent[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.slotsFilled = 0;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack itemstack = this.func_70301_a(i);
                if (itemstack == null) continue;
                ++this.slotsFilled;
            }
            Traincraft.slotschannel.sendToAllAround((IMessage)new PacketSlotsFilled(this, this.slotsFilled), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0));
        }
    }

    public int getAmmountOfCargo() {
        return this.slotsFilled;
    }

    public void recieveSlotsFilled(int amount) {
        this.slotsFilled = amount;
    }

    public int func_70297_j_() {
        return 64;
    }
}

