/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import train.common.api.Locomotive;
import train.common.core.handlers.ConfigHandler;

public class SpeedHandler {
    public double handleSpeed(double railMaxSpeed, float maxSpeed, Entity entity) {
        if (railMaxSpeed >= 0.4 && railMaxSpeed <= 0.45 && entity instanceof Locomotive) {
            return this.convertSpeed(entity);
        }
        if (railMaxSpeed < 0.4 && entity instanceof Locomotive) {
            if (this.convertSpeed(entity) < railMaxSpeed) {
                return this.convertSpeed(entity);
            }
            return railMaxSpeed;
        }
        if (railMaxSpeed > 0.45 && railMaxSpeed < 1.1 && entity instanceof Locomotive) {
            return this.convertSpeed(entity) + 0.2;
        }
        if (entity instanceof Locomotive) {
            return this.convertSpeed(entity);
        }
        return 3.0;
    }

    public static boolean isSpeedRailAt(World world, int i, int j, int k) {
        Block block = world.func_147439_a(i, j, k);
        if (block != null && block.getClass().getName().equals("IRailSpeed")) {
            return true;
        }
        TileEntity tile = world.func_147438_o(i, j, k);
        return tile != null && tile.getClass().getName().equals("IRailSpeed");
    }

    public double speedXFromPitch(EntityPlayer player, double var3) {
        return (double)(-MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI))) * var3 * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * var3;
    }

    public double speedZFromPitch(EntityPlayer player, double var3) {
        return (double)MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * var3 * (double)MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * var3;
    }

    private double convertSpeed(Entity entity) {
        double speed = ((Locomotive)entity).getCustomSpeed();
        speed = ConfigHandler.REAL_TRAIN_SPEED ? (speed /= 2.0) : (speed /= 6.0);
        speed /= 10.0;
        if (speed > 0.695 && ((Locomotive)entity).isAttached) {
            return 0.912;
        }
        return speed;
    }
}

