/*
 * Decompiled with CFR 0.152.
 */
package train.common.api;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import train.common.api.Freight;
import train.common.api.LiquidManager;

public abstract class Tender
extends Freight
implements IFluidHandler {
    public ItemStack[] tenderItems;
    private int maxTank;
    private int update = 8;
    private LiquidManager.StandardTank theTank;
    private IFluidTank[] tankArray = new IFluidTank[1];

    public Tender(World world, Fluid fluid, int quantity, int capacity) {
        this(new FluidStack(fluid, quantity), capacity, world, null);
    }

    public Tender(World world, Fluid fluid, int quantity, int capacity, FluidStack filter) {
        this(new FluidStack(fluid, quantity), capacity, world, filter);
    }

    private Tender(FluidStack fluid, int capacity, World world, FluidStack filter) {
        super(world);
        this.maxTank = capacity;
        if (filter == null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.StandardTank(capacity);
        }
        if (filter != null) {
            LiquidManager liquidManager = LiquidManager.getInstance();
            liquidManager.getClass();
            this.theTank = liquidManager.new LiquidManager.FilteredTank(capacity, filter);
        }
        this.tankArray[0] = this.theTank;
        this.field_70180_af.func_75682_a(4, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    @Override
    public abstract int func_70302_i_();

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        this.theTank.writeToNBT(nbttagcompound);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.theTank != null && this.theTank.getFluid() != null) {
            this.field_70180_af.func_75692_b(23, (Object)this.theTank.getFluid().amount);
            this.field_70180_af.func_75692_b(4, (Object)this.theTank.getFluid().getFluidID());
        } else if (this.theTank != null && this.theTank.getFluid() == null) {
            this.field_70180_af.func_75692_b(23, (Object)0);
            this.field_70180_af.func_75692_b(4, (Object)0);
        }
    }

    @Override
    protected void handleMass() {
        if (this.updateTicks % 10 != 0) {
            return;
        }
        double preciseAmount = 0.0;
        this.mass = this.getDefaultMass();
        if (this.theTank != null && this.theTank.getFluid() != null && this.theTank.getFluid().amount > 0) {
            preciseAmount = this.theTank.getFluid().amount;
        }
        this.itemInsideCount = 0.0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == null || itemstack.field_77994_a <= 0) continue;
            this.itemInsideCount += (double)itemstack.field_77994_a;
        }
        this.mass += this.itemInsideCount * 1.0E-4;
        this.mass += preciseAmount / 10000.0;
    }

    public int getWater() {
        return this.field_70180_af.func_75679_c(23);
    }

    public int getLiquidItemID() {
        return this.field_70180_af.func_75679_c(4);
    }

    public int getCartTankCapacity() {
        return this.maxTank;
    }

    public LiquidManager.StandardTank getTank() {
        return this.theTank;
    }

    private void placeInInvent(ItemStack itemstack1, Tender tender) {
        for (int i = 1; i < tender.tenderItems.length; ++i) {
            if (tender.tenderItems[i] == null) {
                tender.tenderItems[i] = itemstack1;
                return;
            }
            if (tender.tenderItems[i] != null && tender.tenderItems[i].func_77973_b() == itemstack1.func_77973_b() && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || tender.tenderItems[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)tender.tenderItems[i], (ItemStack)itemstack1)) {
                int var9 = tender.tenderItems[i].field_77994_a + itemstack1.field_77994_a;
                if (var9 <= tender.tenderItems[i].func_77976_d()) {
                    tender.tenderItems[i].field_77994_a = var9;
                    return;
                }
                if (tender.tenderItems[i].field_77994_a >= tender.tenderItems[i].func_77976_d()) continue;
                ++tender.tenderItems[i].field_77994_a;
                return;
            }
            if (i != tender.tenderItems.length - 1) continue;
            this.func_145779_a(itemstack1.func_77973_b(), 1);
            return;
        }
    }

    public void liquidInSlot(ItemStack itemstack, Tender tender) {
        ItemStack result;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.update;
        if (this.update % 8 == 0 && itemstack != null && (result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this.theTank, itemstack)) != null) {
            this.placeInInvent(result, tender);
        }
    }

    protected void checkInvent(ItemStack tenderInvent, Tender loco) {
        if (tenderInvent != null) {
            this.liquidInSlot(tenderInvent, loco);
        }
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return this.tenderItems[i];
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (this.tenderItems[par1] != null) {
            ItemStack var2 = this.tenderItems[par1];
            this.tenderItems[par1] = null;
            return var2;
        }
        return null;
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        if (this.tenderItems[i] != null) {
            if (this.tenderItems[i].field_77994_a <= j) {
                ItemStack itemstack = this.tenderItems[i];
                this.tenderItems[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.tenderItems[i].func_77979_a(j);
            if (this.tenderItems[i].field_77994_a == 0) {
                this.tenderItems[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        this.tenderItems[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public void setLiquid(FluidStack liquid) {
    }

    public void setCapacity(int capacity) {
        this.maxTank = capacity;
    }

    public int getCapacity() {
        return this.maxTank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }

    public FluidStack getFluid() {
        return this.theTank.getFluid();
    }

    public int getFluidAmount() {
        return this.theTank.getFluidAmount();
    }

    @Override
    public void dropCartAsItem(boolean isCreative) {
        super.dropCartAsItem(isCreative);
        for (ItemStack stack : this.tenderItems) {
            if (stack == null) continue;
            this.func_70099_a(stack, 0.0f);
        }
    }
}

