/*
 * Decompiled with CFR 0.152.
 */
package train.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import train.common.Traincraft;
import train.common.library.BlockIDs;
import train.common.tile.TileEntityOpenHearthFurnace;
import train.common.tile.TileHelper;

public class BlockOpenHearthFurnace
extends BlockContainer {
    private final boolean isActive;
    private static boolean keepFurnaceInventory = false;
    private Random furnaceRand = new Random();
    private IIcon textureTop_off;
    private IIcon textureTop_on;
    private IIcon textureBottom;
    private IIcon textureFront_off;
    private IIcon textureFront_on;
    private IIcon textureSide;

    protected BlockOpenHearthFurnace(boolean active) {
        super(Material.field_151576_e);
        this.isActive = active;
        if (this.isActive) {
            this.func_149715_a(0.8f);
        } else {
            this.func_149647_a(Traincraft.tcTab);
        }
    }

    public Item func_149650_a(int i, Random random, int j) {
        return Item.func_150898_a((Block)BlockIDs.openFurnaceIdle.block);
    }

    public IIcon func_149691_a(int i, int j) {
        if (!this.isActive) {
            if (i == 1) {
                return this.textureTop_off;
            }
            if (i == 0) {
                return this.textureBottom;
            }
            if (i == 3) {
                return this.textureFront_off;
            }
            return this.textureSide;
        }
        if (i == 1) {
            return this.textureTop_on;
        }
        if (i == 0) {
            return this.textureBottom;
        }
        if (i == 3) {
            return this.textureFront_on;
        }
        return this.textureSide;
    }

    public IIcon func_149673_e(IBlockAccess worldAccess, int i, int j, int k, int side) {
        if (((TileEntityOpenHearthFurnace)worldAccess.func_147438_o(i, j, k)).getFacing() != null) {
            side = TileHelper.getOrientationFromSide(((TileEntityOpenHearthFurnace)worldAccess.func_147438_o(i, j, k)).getFacing(), ForgeDirection.getOrientation((int)side)).ordinal();
        }
        if (!this.isActive) {
            return side == 1 ? this.textureTop_off : (side == 0 ? this.textureBottom : (side == 3 ? this.textureFront_off : this.textureSide));
        }
        return side == 1 ? this.textureTop_on : (side == 0 ? this.textureBottom : (side == 3 ? this.textureFront_on : this.textureSide));
    }

    public static void updateHearthFurnaceBlockState(boolean flag, World world, int i, int j, int k, Random random) {
        int l = world.func_72805_g(i, j, k);
        TileEntity tileentity = world.func_147438_o(i, j, k);
        keepFurnaceInventory = true;
        if (flag) {
            world.func_147449_b(i, j, k, BlockIDs.openFurnaceActive.block);
        } else {
            world.func_147449_b(i, j, k, BlockIDs.openFurnaceIdle.block);
        }
        keepFurnaceInventory = false;
        world.func_72921_c(i, j, k, l, 0);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_147455_a(i, j, k, tileentity);
        }
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity te = world.func_147438_o(i, j, k);
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K && te != null && te instanceof TileEntityOpenHearthFurnace) {
            player.openGui((Object)Traincraft.instance, 97, world, i, j, k);
        }
        return true;
    }

    public void func_149726_b(World world, int i, int j, int k) {
        super.func_149726_b(world, i, j, k);
        world.func_147471_g(i, j, k);
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        TileEntityOpenHearthFurnace tileentityfurnace;
        if (!keepFurnaceInventory && (tileentityfurnace = (TileEntityOpenHearthFurnace)world.func_147438_o(i, j, k)) != null) {
            for (int l = 0; l < tileentityfurnace.func_70302_i_(); ++l) {
                ItemStack itemstack = tileentityfurnace.func_70301_a(l);
                if (itemstack == null) continue;
                float f = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int i1 = this.furnaceRand.nextInt(21) + 10;
                    if (i1 > itemstack.field_77994_a) {
                        i1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= i1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)i + f), (double)((float)j + f1), (double)((float)k + f2), itemstack.func_77979_a(i1));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.furnaceRand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.furnaceRand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.furnaceRand.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntityOpenHearthFurnace te = (TileEntityOpenHearthFurnace)world.func_147438_o(i, j, k);
        if (te != null) {
            int dir = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            te.setFacing(ForgeDirection.getOrientation((int)(dir == 0 ? 2 : (dir == 1 ? 5 : (dir == 2 ? 3 : 4)))));
            world.func_147471_g(i, j, k);
        }
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityOpenHearthFurnace();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textureTop_off = iconRegister.func_94245_a("tc".toLowerCase() + ":furnace_off_top");
        this.textureTop_on = iconRegister.func_94245_a("tc".toLowerCase() + ":furnace_on_top");
        this.textureBottom = iconRegister.func_94245_a("tc".toLowerCase() + ":furnace_bottom");
        this.textureFront_off = iconRegister.func_94245_a("tc".toLowerCase() + ":furnace_off_front");
        this.textureFront_on = iconRegister.func_94245_a("tc".toLowerCase() + ":furnace_on_front");
        this.textureSide = iconRegister.func_94245_a("tc".toLowerCase() + ":furnace_side");
    }
}

