/*
 * Decompiled with CFR 0.152.
 */
package train.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.api.tracks.ITrackPowered;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import train.common.api.AbstractTrains;
import train.common.blocks.tracks.TrackBaseTraincraft;
import train.common.core.handlers.LinkHandler;
import train.common.library.Tracks;

public class BlockCouplerTrack
extends TrackBaseTraincraft
implements ITrackPowered {
    private EntityMinecart taggedCart;
    private boolean powered = false;

    @Override
    public Tracks getTrackType() {
        return Tracks.COUPLER_TRACK;
    }

    @Override
    public IIcon getIcon() {
        if (this.isPowered()) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        ILinkageManager lm;
        if (this.isPowered() && !(cart instanceof AbstractTrains)) {
            lm = CartTools.getLinkageManager(cart.field_70170_p);
            if (this.taggedCart != null) {
                lm.createLink(this.taggedCart, cart);
            }
            this.taggedCart = cart;
        }
        if (this.isPowered() && cart instanceof AbstractTrains) {
            ((AbstractTrains)cart).isAttaching = true;
            if (this.taggedCart != null) {
                ((AbstractTrains)this.taggedCart).isAttaching = true;
                LinkHandler lh = new LinkHandler(cart.field_70170_p);
                lh.addStake((Entity)this.taggedCart, (Entity)cart, false);
            }
            this.taggedCart = cart;
        }
        if (!this.isPowered() && !(cart instanceof AbstractTrains)) {
            lm = CartTools.getLinkageManager(cart.field_70170_p);
            if (this.taggedCart != null) {
                lm.breakLink(this.taggedCart, cart);
            }
            this.taggedCart = cart;
        }
        if (!this.isPowered() && cart instanceof AbstractTrains) {
            ((AbstractTrains)cart).isAttached = false;
            if (this.taggedCart != null) {
                ((AbstractTrains)this.taggedCart).isAttaching = false;
            }
            this.taggedCart = cart;
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public int getPowerPropagation() {
        return 8;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        if (p != this.powered) {
            this.powered = p;
            this.markBlockNeedsUpdate();
        }
    }
}

