/*
 * Decompiled with CFR 0.152.
 */
package train.common.core;

import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import train.common.api.EntityRollingStock;
import train.common.api.Locomotive;
import train.common.api.SteamTrain;

public class HandleOverheating {
    private int breakDelay = 0;

    public HandleOverheating(EntityRollingStock entity) {
    }

    public void HandleHeatLevel(EntityRollingStock entity) {
        entity.overheatLevel = entity.getOverheatLevel();
        if (entity instanceof Locomotive && entity.canOverheat()) {
            double locoMaxSpeed = entity.convertSpeed((Entity)entity);
            double locoActualSpeed = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
            if (locoActualSpeed <= 0.05 && !entity.isBraking && entity.overheatLevel > entity.getAverageOverheat() && entity.field_70170_p.field_73012_v.nextInt(10) == 0 && !((Locomotive)entity).getState().equals("broken")) {
                --entity.overheatLevel;
            }
            if (locoActualSpeed <= 0.1 && !entity.isBraking && entity.overheatLevel > entity.getAverageOverheat() && entity.field_70170_p.field_73012_v.nextInt(10) == 0 && !((Locomotive)entity).getState().equals("broken")) {
                --entity.overheatLevel;
            }
            if (entity.fuelTrain < 1 && entity.overheatLevel > 0 && entity.field_70170_p.field_73012_v.nextInt(10) == 0 && !((Locomotive)entity).getState().equals("broken")) {
                --entity.overheatLevel;
            }
            if (entity.overheatLevel > (entity.getOverheatTime() + 30) / 2 && entity.field_70170_p.field_73012_v.nextInt(30) == 0 && !((Locomotive)entity).getState().equals("broken")) {
                --entity.overheatLevel;
            }
            if (((Locomotive)entity).isLocoTurnedOn() && entity.fuelTrain > 1 && entity.overheatLevel < (entity.getOverheatTime() + 30) / 2 && entity.field_70170_p.field_73012_v.nextInt(7) == 0) {
                ++entity.overheatLevel;
            }
            if (entity.isBraking) {
                ++this.breakDelay;
            }
            if (entity.isBraking && this.breakDelay > 40 && Math.abs(entity.field_70159_w) + Math.abs(entity.field_70179_y) > 0.05 && entity.field_70170_p.field_73012_v.nextInt(10) == 0) {
                entity.overheatLevel += 2;
            }
            if (!entity.isBraking) {
                this.breakDelay = 0;
            }
            if (!entity.isClimbing || !(locoActualSpeed >= locoMaxSpeed - 0.05) || entity.field_70170_p.field_73012_v.nextInt(10) == 0) {
                // empty if block
            }
            if (entity instanceof SteamTrain) {
                int maxWaterLevel;
                int waterLevel = ((SteamTrain)entity).getWater();
                if (waterLevel < 1 && entity.fuelTrain > 10 && entity.field_70170_p.field_73012_v.nextInt(10) == 0) {
                    entity.overheatLevel += 3;
                }
                if (waterLevel > (maxWaterLevel = ((SteamTrain)entity).getCartTankCapacity()) - maxWaterLevel / 2 && entity.overheatLevel > entity.getAverageOverheat() && !((Locomotive)entity).getState().equals("broken")) {
                    --entity.overheatLevel;
                }
            }
            if ((double)entity.overheatLevel < (double)entity.getAverageOverheat() - this.overheatRatio(17.0, entity)) {
                ((Locomotive)entity).setState("cold");
            }
            if ((double)entity.overheatLevel < (double)entity.getAverageOverheat() - this.overheatRatio(4.0, entity) && (double)entity.overheatLevel > (double)entity.getAverageOverheat() - this.overheatRatio(17.0, entity)) {
                ((Locomotive)entity).setState("warm");
            }
            if ((double)entity.overheatLevel > (double)entity.getAverageOverheat() - this.overheatRatio(4.0, entity) && (double)entity.overheatLevel < (double)entity.getAverageOverheat() + this.overheatRatio(12.0, entity)) {
                ((Locomotive)entity).setState("hot");
            }
            if ((double)entity.overheatLevel > (double)entity.getAverageOverheat() + this.overheatRatio(12.0, entity)) {
                ((Locomotive)entity).setState("very hot");
            }
            if ((double)entity.overheatLevel > (double)entity.getAverageOverheat() + this.overheatRatio(17.0, entity)) {
                ((Locomotive)entity).setState("too hot");
            }
            if ((double)entity.overheatLevel > (double)entity.getAverageOverheat() + this.overheatRatio(24.0, entity)) {
                ((Locomotive)entity).setState("broken");
            }
            entity.setOverheatLevel(entity.overheatLevel);
        }
    }

    private double overheatRatio(double pixels, EntityRollingStock entity) {
        double barSize = 50.0;
        return (double)entity.getOverheatTime() * (pixels / barSize);
    }
}

