/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.handlers;

import com.google.common.collect.ListMultimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.EntityEvent;
import train.common.api.AbstractTrains;
import train.common.api.EntityBogie;
import train.common.api.EntityRollingStock;

public class ChunkEvents
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    @SubscribeEvent
    public void entityEnteredChunk(EntityEvent.EnteringChunk event) {
        if (event.entity instanceof AbstractTrains && !event.entity.field_70170_p.field_72995_K) {
            ChunkEvents.forceChunkLoading((AbstractTrains)event.entity, event.newChunkX, event.newChunkZ);
        } else if (event.entity instanceof EntityBogie && !event.entity.field_70170_p.field_72995_K) {
            ChunkEvents.forceChunkLoading(((EntityBogie)event.entity).entityMainTrain, event.newChunkX, event.newChunkZ);
        }
    }

    private static void forceChunkLoading(AbstractTrains transport, int newChunkX, int newChunkZ) {
        if (transport != null && transport.getTicket() != null) {
            ArrayList<ChunkCoordIntPair> newChunks = new ArrayList<ChunkCoordIntPair>();
            for (int x = newChunkX - 1; x <= newChunkX + 1; ++x) {
                for (int z = newChunkZ - 1; z <= newChunkZ + 1; ++z) {
                    newChunks.add(new ChunkCoordIntPair(x, z));
                }
            }
            ChunkCoordIntPair pair = null;
            if (transport instanceof EntityRollingStock && ((EntityRollingStock)transport).bogieLoco != null) {
                EntityBogie bogie = ((EntityRollingStock)transport).bogieLoco;
                for (int x = bogie.field_70176_ah - 1; x <= bogie.field_70176_ah + 1; ++x) {
                    for (int z = bogie.field_70164_aj - 1; z <= bogie.field_70164_aj + 1; ++z) {
                        pair = new ChunkCoordIntPair(x, z);
                        if (newChunks.contains(pair) || newChunks.size() >= transport.getTicket().getMaxChunkListDepth()) continue;
                        newChunks.add(pair);
                    }
                }
            }
            for (ChunkCoordIntPair chunk : newChunks) {
                if (transport.loadedChunks.contains(chunk)) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)transport.getTicket(), (ChunkCoordIntPair)chunk);
                ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)transport.getTicket(), (ChunkCoordIntPair)chunk);
            }
            for (ChunkCoordIntPair oldChunk : transport.loadedChunks) {
                if (newChunks.contains(oldChunk)) continue;
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)transport.getTicket(), (ChunkCoordIntPair)oldChunk);
            }
            transport.loadedChunks = newChunks;
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (ticket.isPlayerTicket() || !(ticket.getEntity() instanceof AbstractTrains)) continue;
            AbstractTrains train = (AbstractTrains)ticket.getEntity();
            train.setTicket(ticket);
            ChunkEvents.forceChunkLoading(train, train.field_70176_ah, train.field_70164_aj);
        }
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        ArrayList<ForgeChunkManager.Ticket> ticketList = new ArrayList<ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            if (!(ticket.getEntity() instanceof AbstractTrains)) continue;
            ticketList.add(ticket);
        }
        return ticketList;
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return tickets;
    }
}

