/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.handlers;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import train.common.api.AbstractTrains;
import train.common.api.EntityRollingStock;
import train.common.api.Locomotive;
import train.common.core.handlers.TrainsDamageSource;
import train.common.entity.EntityLasersLines;
import train.common.entity.rollingStock.EntityStockCar;

public class CollisionHandler {
    private World worldObj;
    private Random rand;

    public CollisionHandler(World world) {
        this.worldObj = world;
        this.rand = new Random();
    }

    public void handleCollisions(Entity entityOne, AxisAlignedBB boundingBox) {
        List list;
        List listLiving;
        AxisAlignedBB box = null;
        List listRide = this.worldObj.func_72839_b(entityOne, boundingBox.func_72314_b(-0.5, -0.5, -0.5));
        if (listRide != null && listRide.size() > 0) {
            for (int j1 = 0; j1 < listRide.size(); ++j1) {
                Entity entity = (Entity)listRide.get(j1);
                if (entity instanceof EntityLasersLines || entity.field_70145_X || entity == entity.field_70153_n || this.unAutorizedMob(entity, entityOne) || !(entity instanceof EntityLiving)) continue;
                this.applyRideEntity(entity, entityOne);
            }
        }
        if ((listLiving = this.worldObj.func_72839_b(entityOne, box = Math.round(entityOne.field_70177_z) == -90 || Math.round(entityOne.field_70177_z) == 90 ? boundingBox.func_72314_b(0.0, 0.0, 2.0) : (Math.round(entityOne.field_70177_z) == 180 || Math.round(entityOne.field_70177_z) == 0 ? boundingBox.func_72314_b(2.0, 0.0, 0.0) : boundingBox.func_72314_b(2.0, 0.0, 2.0)))) != null && listLiving.size() > 0) {
            for (int j1 = 0; j1 < listLiving.size(); ++j1) {
                Entity entity = (Entity)listLiving.get(j1);
                if (entity instanceof EntityLasersLines || entity.field_70145_X) continue;
                if (entity != entity.field_70153_n && entity instanceof EntityLiving && !entity.getClass().getName().equals("EntityLittleMaid") && this.unAutorizedMob(entity, entityOne)) {
                    this.applyCollisionLiving(entity, entityOne);
                    return;
                }
                if (entity == entity.field_70153_n || !(entity instanceof EntityPlayer) || !(entityOne instanceof AbstractTrains)) continue;
                this.applyEntityCollision(entity, entityOne);
                return;
            }
        }
        if ((list = this.worldObj.func_72839_b(entityOne, box)) != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                Entity entity = (Entity)list.get(j1);
                if (entity instanceof EntityLasersLines || entity.field_70145_X || entity instanceof EntityLiving || entityOne instanceof EntityLiving) continue;
                if (entity != entity.field_70153_n && entity.func_70104_M() && entityOne instanceof AbstractTrains && entity instanceof AbstractTrains && !((AbstractTrains)entityOne).isAttached) {
                    this.applyEntityCollisionVanilla(entity, (EntityMinecart)entityOne);
                    return;
                }
                if (entity != entity.field_70153_n && entity.func_70104_M() && entity instanceof EntityMinecart && !(entity instanceof AbstractTrains) && entityOne instanceof AbstractTrains && !((AbstractTrains)entityOne).isAttached) {
                    this.applyEntityCollisionVanilla(entity, (EntityMinecart)entityOne);
                    return;
                }
                if (entity == entity.field_70153_n || !entity.func_70104_M() || !(entity instanceof AbstractTrains) || !(entityOne instanceof AbstractTrains) || entity == ((EntityRollingStock)entityOne).cartLinked1 || entity == ((EntityRollingStock)entityOne).cartLinked2) continue;
                this.applyEntityCollisionVanilla(entity, (EntityMinecart)entityOne);
                return;
            }
        }
    }

    public void applyEntityCollisionVanilla(Entity par1Entity, EntityMinecart entityOne) {
        MinecraftForge.EVENT_BUS.post((Event)new MinecartCollisionEvent(entityOne, par1Entity));
        if (entityOne.getCollisionHandler() != null) {
            entityOne.getCollisionHandler().onEntityCollision(entityOne, par1Entity);
            return;
        }
        if (!this.worldObj.field_72995_K && par1Entity != entityOne.field_70153_n) {
            double d0 = par1Entity.field_70165_t - entityOne.field_70165_t;
            double d1 = par1Entity.field_70161_v - entityOne.field_70161_v;
            double d2 = d0 * d0 + d1 * d1;
            if ((d2 = (double)MathHelper.func_76133_a((double)d2)) <= (double)((AbstractTrains)entityOne).getLinkageDistance(entityOne) && d2 >= (double)1.0E-4f) {
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.1f;
                d1 *= (double)0.1f;
                d0 *= 0.4;
                d1 *= 0.4;
                d0 *= 0.5;
                d1 *= 0.5;
                if (par1Entity instanceof EntityMinecart) {
                    double d7 = par1Entity.field_70159_w + entityOne.field_70159_w;
                    double d8 = par1Entity.field_70179_y + entityOne.field_70179_y;
                    if (((EntityMinecart)par1Entity).isPoweredCart() && !entityOne.isPoweredCart()) {
                        entityOne.field_70159_w *= (double)0.2f;
                        entityOne.field_70179_y *= (double)0.2f;
                        entityOne.func_70024_g(par1Entity.field_70159_w - d0, 0.0, par1Entity.field_70179_y - d1);
                        par1Entity.field_70159_w *= (double)0.95f;
                        par1Entity.field_70179_y *= (double)0.95f;
                    } else if (!((EntityMinecart)par1Entity).isPoweredCart() && entityOne.isPoweredCart()) {
                        par1Entity.field_70159_w *= (double)0.2f;
                        par1Entity.field_70179_y *= (double)0.2f;
                        par1Entity.func_70024_g(entityOne.field_70159_w + d0, 0.0, entityOne.field_70179_y + d1);
                        entityOne.field_70159_w *= (double)0.95f;
                        entityOne.field_70179_y *= (double)0.95f;
                    } else {
                        entityOne.field_70159_w *= 0.02000000298023224;
                        entityOne.field_70179_y *= 0.02000000298023224;
                        entityOne.func_70024_g((d7 /= 2.0) - d0 / 2.0, 0.0, (d8 /= 2.0) - d1 / 2.0);
                        par1Entity.field_70159_w *= 0.02000000298023224;
                        par1Entity.field_70179_y *= 0.02000000298023224;
                        par1Entity.func_70024_g(d7 + d0 / 2.0, 0.0, d8 + d1 / 2.0);
                    }
                }
            }
        }
    }

    public void applyEntityCollision(Entity entity, Entity entityOne) {
        if (entityOne instanceof Locomotive && entity instanceof EntityPlayer) {
            this.applyCollisionLiving(entity, entityOne);
            return;
        }
        if (entity instanceof Locomotive && entityOne instanceof EntityPlayer) {
            this.applyCollisionLiving(entityOne, entity);
            return;
        }
        if (!this.worldObj.field_72995_K && entity != entityOne.field_70153_n) {
            double var2 = entity.field_70165_t - entityOne.field_70165_t;
            double var4 = entity.field_70161_v - entityOne.field_70161_v;
            double var6 = var2 * var2 + var4 * var4;
            if ((var6 = (double)MathHelper.func_76133_a((double)var6)) <= (double)((AbstractTrains)entityOne).getLinkageDistance((EntityMinecart)entityOne) * 0.8 && var6 >= (double)1.0E-4f) {
                var2 /= var6;
                var4 /= var6;
                double var8 = 1.0 / var6;
                if (var8 > 1.0) {
                    var8 = 1.0;
                }
                var2 *= var8;
                var4 *= var8;
                var2 *= (double)0.1f;
                var4 *= (double)0.1f;
                var2 *= 0.4;
                var4 *= 0.4;
                var2 *= 0.5;
                var4 *= 0.5;
                if (entity instanceof EntityMinecart) {
                    Vec3 var15;
                    double var10 = entity.field_70165_t - entityOne.field_70165_t;
                    double var12 = entity.field_70161_v - entityOne.field_70161_v;
                    Vec3 var14 = Vec3.func_72443_a((double)var10, (double)0.0, (double)var12).func_72432_b();
                    double var16 = Math.abs(var14.func_72430_b(var15 = Vec3.func_72443_a((double)MathHelper.func_76134_b((float)(entityOne.field_70177_z * (float)Math.PI / 180.0f)), (double)0.0, (double)MathHelper.func_76126_a((float)(entityOne.field_70177_z * (float)Math.PI / 180.0f))).func_72432_b()));
                    if (var16 < (double)0.8f) {
                        return;
                    }
                    double var18 = entity.field_70159_w + entityOne.field_70159_w;
                    double var20 = entity.field_70179_y + entityOne.field_70179_y;
                    if (((EntityMinecart)entity).isPoweredCart() && !((EntityMinecart)entityOne).isPoweredCart()) {
                        entityOne.field_70159_w *= (double)0.2f;
                        entityOne.field_70179_y *= (double)0.2f;
                        entityOne.func_70024_g(entity.field_70159_w - var2, 0.0, entity.field_70179_y - var4);
                        entity.field_70159_w *= (double)0.95f;
                        entity.field_70179_y *= (double)0.95f;
                    } else if (!((EntityMinecart)entity).isPoweredCart() && ((EntityMinecart)entityOne).isPoweredCart()) {
                        entity.field_70159_w *= (double)0.2f;
                        entity.field_70179_y *= (double)0.2f;
                        entity.func_70024_g(entityOne.field_70159_w + var2, 0.0, entityOne.field_70179_y + var4);
                        entityOne.field_70159_w *= (double)0.95f;
                        entityOne.field_70179_y *= (double)0.95f;
                    } else {
                        entityOne.field_70159_w *= (double)0.2f;
                        entityOne.field_70179_y *= (double)0.2f;
                        entityOne.func_70024_g((var18 /= 2.0) - var2, 0.0, (var20 /= 2.0) - var4);
                        entity.field_70159_w *= (double)0.2f;
                        entity.field_70179_y *= (double)0.2f;
                        entity.func_70024_g(var18 + var2, 0.0, var20 + var4);
                    }
                } else {
                    if (entityOne instanceof EntityMinecart) {
                        entityOne.func_70024_g(-var2, 0.0, -var4);
                    }
                    if (entity instanceof EntityPlayer) {
                        MovingObjectPosition movingobjectposition = this.worldObj.func_72901_a(Vec3.func_72443_a((double)entityOne.field_70165_t, (double)entityOne.field_70163_u, (double)entityOne.field_70161_v), Vec3.func_72443_a((double)(entityOne.field_70165_t + entityOne.field_70159_w), (double)(entityOne.field_70163_u + entityOne.field_70181_x), (double)(entityOne.field_70161_v + entityOne.field_70179_y)), false);
                        if (entity != null && entity instanceof EntityPlayer) {
                            movingobjectposition = new MovingObjectPosition(entity);
                        }
                        if (movingobjectposition != null && movingobjectposition.field_72308_g != null) {
                            float f7 = MathHelper.func_76133_a((double)(entityOne.field_70159_w * entityOne.field_70159_w + entityOne.field_70179_y * entityOne.field_70179_y));
                            movingobjectposition.field_72308_g.func_70024_g(-(entityOne.field_70159_w * 1.0 * 0.006000000238418579) / (double)f7, 1.0E-17, -(entityOne.field_70179_y * 1.0 * 0.006000000238418579 / (double)f7));
                            entity.field_70133_I = true;
                        }
                    }
                }
            }
        }
    }

    public boolean unAutorizedMob(Entity entity, Entity entityOne) {
        return !(entityOne instanceof EntityStockCar) && (entity instanceof EntitySlime || entity instanceof EntityCreeper || entity instanceof EntityEnderman || entity instanceof EntityIronGolem || entity instanceof EntityGiantZombie || entity instanceof EntitySkeleton || entity instanceof EntitySpider || entity instanceof EntityZombie || entity instanceof EntityCow || entity instanceof EntityMooshroom || entity instanceof EntityPig || entity instanceof EntityPigZombie || entity instanceof EntitySheep || entity instanceof EntityChicken);
    }

    public void applyRideEntity(Entity entity, Entity entityOne) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        if (entity == entityOne.field_70153_n) {
            return;
        }
        if (!((AbstractTrains)entityOne).canBeRidden()) {
            return;
        }
        if (!(entityOne instanceof EntityStockCar)) {
            return;
        }
        if (entity instanceof EntityLiving && ((AbstractTrains)entityOne).canBeRidden() && entityOne.field_70153_n == null && entity.field_70154_o == null) {
            entity.func_70078_a(entityOne);
        }
    }

    public void applyCollisionLiving(Entity entity, Entity entityOne) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        double d = entity.field_70165_t - entityOne.field_70165_t;
        double d1 = entity.field_70161_v - entityOne.field_70161_v;
        double d2 = MathHelper.func_76132_a((double)d, (double)d1);
        if (d2 <= 0.7) {
            d2 = MathHelper.func_76133_a((double)d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= (double)0.1f;
            d1 *= (double)0.1f;
            d *= (double)(1.0f - entity.field_70144_Y);
            d1 *= (double)(1.0f - entity.field_70144_Y);
            d *= 0.5;
            d1 *= 0.5;
            if (entity.field_70154_o == null) {
                Vec3 vec3d4 = Vec3.func_72443_a((double)entityOne.field_70165_t, (double)entityOne.field_70163_u, (double)entityOne.field_70161_v);
                Vec3 vec3d5 = Vec3.func_72443_a((double)(entityOne.field_70165_t + entityOne.field_70159_w), (double)(entityOne.field_70163_u + entityOne.field_70181_x), (double)(entityOne.field_70161_v + entityOne.field_70179_y));
                MovingObjectPosition movingobjectposition = this.worldObj.func_72901_a(vec3d4, vec3d5, false);
                if (entity != null) {
                    movingobjectposition = new MovingObjectPosition(entity);
                }
                if (movingobjectposition != null && movingobjectposition.field_72308_g != null) {
                    float f1 = MathHelper.func_76133_a((double)(entityOne.field_70159_w * entityOne.field_70159_w + entityOne.field_70181_x * entityOne.field_70181_x + entityOne.field_70179_y * entityOne.field_70179_y));
                    float f7 = MathHelper.func_76133_a((double)(entityOne.field_70159_w * entityOne.field_70159_w + entityOne.field_70179_y * entityOne.field_70179_y));
                    double damage = 1.0;
                    f1 *= 6.0f;
                    if ((double)(f1 *= 10.0f) * 3.6 < 35.0) {
                        if (f7 == 0.0f) {
                            movingobjectposition.field_72308_g.func_70024_g(d / 1.5, 0.0, d1 / 1.5);
                            entity.field_70133_I = true;
                            return;
                        }
                        movingobjectposition.field_72308_g.func_70024_g(entityOne.field_70159_w * 1.0 * 0.06000000238418579 / (double)f7, 1.0E-17, entityOne.field_70179_y * 1.0 * 0.06000000238418579 / (double)f7);
                        entity.field_70133_I = true;
                        return;
                    }
                    if (entity instanceof EntityCreeper) {
                        damage = 100.0;
                    }
                    int j1 = (int)Math.ceil((double)f1 * damage);
                    if (this.unAutorizedMob(movingobjectposition.field_72308_g, entityOne) || (entity instanceof EntityPlayer || entityOne instanceof EntityPlayer) && (double)f1 * 3.6 > 60.0) {
                        entity.func_70097_a((DamageSource)TrainsDamageSource.ranOver, (float)j1);
                        if (f7 > 0.0f) {
                            movingobjectposition.field_72308_g.func_70024_g(entityOne.field_70159_w * 2.0 * (double)0.6f / (double)f7, 0.1, entityOne.field_70179_y * 2.0 * (double)0.6f / (double)f7);
                            entity.field_70133_I = true;
                        }
                        entityOne.func_85030_a("damage.fallsmall", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                        for (int var9 = 0; var9 < 4; ++var9) {
                            entity.field_70170_p.func_72869_a("crit", entity.field_70165_t + entity.field_70159_w * (double)var9 / 4.0, entity.field_70163_u + entity.field_70181_x * (double)var9 / 4.0, entity.field_70161_v + entity.field_70179_y * (double)var9 / 4.0, -entity.field_70159_w, -entity.field_70181_x + 0.2, -entity.field_70179_y);
                        }
                    }
                }
            }
        }
    }

    public void applyCollision3(Entity entity, Entity entityOne) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        double d = entity.field_70165_t - entityOne.field_70165_t;
        double d1 = entity.field_70161_v - entityOne.field_70161_v;
        double d2 = MathHelper.func_76132_a((double)d, (double)d1);
        if (d2 >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= (double)0.1f;
            d1 *= (double)0.1f;
            d *= (double)(1.0f - entityOne.field_70144_Y);
            d1 *= (double)(1.0f - entityOne.field_70144_Y);
            d *= 0.5;
            d1 *= 0.5;
            if (entity instanceof AbstractTrains) {
                if (((AbstractTrains)entity).isLocomotive() && !((AbstractTrains)entityOne).isLocomotive()) {
                    entityOne.field_70159_w = 0.0;
                    entityOne.field_70179_y = 0.0;
                    if (!((AbstractTrains)entity).isBuilder() && !((AbstractTrains)entityOne).isBuilder()) {
                        entityOne.func_70024_g(entity.field_70159_w - d, 0.0, entity.field_70179_y - d1);
                    } else {
                        entity.field_70159_w = 0.0;
                        entity.field_70179_y = 0.0;
                    }
                } else if (!((AbstractTrains)entity).isLocomotive() && ((AbstractTrains)entityOne).isLocomotive() && !((AbstractTrains)entity).isBuilder() && !((AbstractTrains)entityOne).isBuilder()) {
                    entity.field_70159_w = 0.0;
                    entity.field_70179_y = 0.0;
                    entity.func_70024_g(entityOne.field_70159_w + d, 0.0, entityOne.field_70179_y + d1);
                } else if (((AbstractTrains)entity).isFreightOrPassenger() && ((AbstractTrains)entityOne).isFreightOrPassenger()) {
                    entity.field_70159_w = 0.0;
                    entity.field_70179_y = 0.0;
                    entity.func_70024_g(entityOne.field_70159_w + d, 0.0, entityOne.field_70179_y + d1);
                    entityOne.field_70159_w *= 0.9899999880790711;
                    entityOne.field_70179_y *= 0.9899999880790711;
                }
            }
        }
    }

    public void applyCollision2(Entity entity, Entity entityOne) {
        if (this.worldObj.field_72995_K) {
            return;
        }
        double d = entity.field_70165_t - entityOne.field_70165_t;
        double d1 = entity.field_70161_v - entityOne.field_70161_v;
        double d2 = MathHelper.func_76132_a((double)d, (double)d1);
        if (d2 >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= (double)0.1f;
            d1 *= (double)0.1f;
            d *= (double)(1.0f - entityOne.field_70144_Y);
            d1 *= (double)(1.0f - entityOne.field_70144_Y);
            d *= 0.5;
            d1 *= 0.5;
            if (entity instanceof EntityMinecart) {
                Vec3 vec3d1;
                double d4 = entity.field_70165_t - entityOne.field_70165_t;
                double d5 = entity.field_70161_v - entityOne.field_70161_v;
                Vec3 vec3d = Vec3.func_72443_a((double)d4, (double)0.0, (double)d5).func_72432_b();
                double d6 = Math.abs(vec3d.func_72430_b(vec3d1 = Vec3.func_72443_a((double)MathHelper.func_76134_b((float)(entityOne.field_70177_z * 3.141593f / 180.0f)), (double)0.0, (double)MathHelper.func_76126_a((float)(entityOne.field_70177_z * 3.141593f / 180.0f))).func_72432_b()));
                if (d6 < (double)0.8f) {
                    return;
                }
                if (!((AbstractTrains)entityOne).isLocomotive()) {
                    entityOne.field_70159_w = 0.0;
                    entityOne.field_70179_y = 0.0;
                    entityOne.func_70024_g(entity.field_70159_w - d, 0.0, entity.field_70179_y - d1);
                } else if (((AbstractTrains)entityOne).isLocomotive()) {
                    entity.field_70159_w = 0.0;
                    entity.field_70179_y = 0.0;
                    entity.func_70024_g(entityOne.field_70159_w + d, 0.0, entityOne.field_70179_y + d1);
                } else if (((AbstractTrains)entityOne).isFreightOrPassenger()) {
                    entity.field_70159_w = 0.0;
                    entity.field_70179_y = 0.0;
                    entity.func_70024_g(entityOne.field_70159_w + d, 0.0, entityOne.field_70179_y + d1);
                    entity.field_70159_w *= 0.9899999880790711;
                    entity.field_70179_y *= 0.9899999880790711;
                } else {
                    entityOne.func_70024_g(entityOne.field_70159_w + d * 5.0, 0.0, entityOne.field_70179_y + d * 5.0);
                }
            }
        }
    }
}

