/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.plugins;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import train.common.core.util.TraincraftUtil;
import train.common.library.ItemIDs;
import train.common.library.Tracks;

public class PluginRailcraft {
    public static void init() {
        PluginRailcraft.registerRecipes();
    }

    private static void registerRecipes() {
        ArrayList steel;
        for (Tracks track : Tracks.values()) {
            if (track.crafting == null) continue;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(track.getOutput(), track.crafting));
        }
        GameRegistry.addShapelessRecipe((ItemStack)Tracks.SNOWY_STEEL_TRACK.getOutput(), (Object[])new Object[]{Tracks.STEEL_TRACK.getTrackSpec().getItem(1), Items.field_151126_ay});
        GameRegistry.addShapelessRecipe((ItemStack)Tracks.SNOWY_COPPER_TRACK.getOutput(), (Object[])new Object[]{Tracks.COPPER_TRACK.getTrackSpec().getItem(1), Items.field_151126_ay});
        GameRegistry.addShapelessRecipe((ItemStack)Tracks.VANILLA_SNOWY_TRACK.getOutput(), (Object[])new Object[]{Blocks.field_150448_aq, Items.field_151126_ay});
        ArrayList copper = OreDictionary.getOres((String)"ingotCopper");
        if (copper != null && copper.size() >= 0) {
            for (ItemStack aCopper : copper) {
                RailcraftCraftingManager.rollingMachine.addRecipe(new ItemStack(ItemIDs.copperRail.item, 8), "X X", "X X", "X X", Character.valueOf('X'), aCopper);
            }
        }
        if ((steel = OreDictionary.getOres((String)"ingotSteel")) != null && steel.size() >= 0) {
            for (ItemStack aSteel : steel) {
                RailcraftCraftingManager.rollingMachine.addRecipe(new ItemStack(ItemIDs.steelRail.item, 16), "X X", "I I", "X X", Character.valueOf('X'), aSteel, Character.valueOf('I'), Items.field_151042_j);
            }
        }
    }

    public static enum RailcraftParts {
        COKE("fuel.coke", 0),
        INGOT_STEEL("ingot", 0),
        RAIL_STANDARD("part.rail", 0),
        RAIL_ADVANCED("part.rail", 1),
        RAIL_WOOD("part.rail", 2),
        RAIL_SPEED("part.rail", 3),
        RAIL_REINFORCED("part.rail", 4),
        RAILBED_WOOD("part.railbed", 0),
        RAILBED_STONE("part.railbed", 1);

        public ItemStack stack;

        private RailcraftParts(String itemName, int meta) {
            this.stack = TraincraftUtil.getItemFromUnlocalizedName("Railcraft:" + itemName, meta);
        }
    }
}

