/*
 * Decompiled with CFR 0.152.
 */
package train.common.core.util;

import java.net.URL;
import javazoom.jl.player.advanced.AdvancedPlayer;
import javazoom.jl.player.advanced.PlaybackEvent;
import javazoom.jl.player.advanced.PlaybackListener;
import net.minecraft.world.World;
import train.common.Traincraft;

public class MP3Player
extends PlaybackListener
implements Runnable {
    private String streamURL;
    private AdvancedPlayer player;
    private Thread pThread;
    private int id;
    private World world;

    public MP3Player(String mp3url, World w, int id) {
        try {
            this.world = w;
            this.id = id;
            this.streamURL = mp3url;
            this.pThread = new Thread(this);
            this.pThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            this.player = new AdvancedPlayer(new URL(this.streamURL).openStream());
            this.player.setPlayBackListener(this);
            this.player.play();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.player != null && this.isPlaying()) {
            this.player.stop();
        }
    }

    @Override
    public void playbackStarted(PlaybackEvent evt) {
    }

    @Override
    public void playbackFinished(PlaybackEvent evt) {
    }

    public boolean isPlaying() {
        return this.pThread.isAlive();
    }

    public void setVolume(float f) {
        if (this.player != null) {
            this.player.setVolume(f * Traincraft.proxy.getJukeboxVolume());
        }
    }

    public float getVolume() {
        if (this.player != null) {
            return this.player.getVolume();
        }
        return 0.0f;
    }
}

