/*
 * Decompiled with CFR 0.152.
 */
package train.common.entity.rollingStock;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.tracks.RailTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import train.common.Traincraft;
import train.common.api.EntityRollingStock;
import train.common.api.Freight;
import train.common.core.TrainModBlockUtil;
import train.common.core.handlers.BuilderOreHandler;
import train.common.core.handlers.FuelHandler;
import train.common.core.plugins.PluginRailcraft;
import train.common.library.BlockIDs;
import train.common.library.ItemIDs;

public class EntityTracksBuilder
extends EntityRollingStock
implements IInventory {
    public ItemStack item;
    private ItemStack[] BuilderInvent;
    public int numBuilderSlots;
    public int numBuilderSlots1;
    public int numBuilderSlots2;
    public int numBuilderSlots3;
    public int inventoryBuilderSize;
    public double pushX;
    public double pushZ;
    public int MoreBuilderInvent;
    public int trackfuel;
    private ItemStack underBlockStack;
    private ItemStack underBlock2Stack;
    private ItemStack upperBlockStack;
    private ItemStack upperBlock1Stack;
    private ItemStack upperCenterBlockStack;
    private ItemStack tunnelBlockStack;
    public boolean tunnelActive;
    public double currentHeight;
    public int plannedHeight;
    EntityPlayer playerEntity;
    public boolean followTracks;
    private ItemStack tracksStack;
    private int maxFuel = 5000;
    private int miningTickCounter = 0;

    public EntityTracksBuilder(World world) {
        super(world);
        this.initBuilder();
    }

    public void initBuilder() {
        this.numBuilderSlots = 8;
        this.numBuilderSlots1 = 8;
        this.numBuilderSlots2 = 8;
        this.numBuilderSlots3 = 8;
        this.MoreBuilderInvent = 20;
        this.inventoryBuilderSize = this.numBuilderSlots + this.numBuilderSlots2 + this.numBuilderSlots1 + this.numBuilderSlots3 + this.MoreBuilderInvent;
        this.BuilderInvent = new ItemStack[this.inventoryBuilderSize];
        this.trackfuel = 0;
        this.tunnelActive = false;
        this.followTracks = true;
        this.tracksStack = null;
        this.field_70180_af.func_75682_a(24, (Object)this.fuelTrain);
        this.field_70180_af.func_75682_a(26, (Object)this.plannedHeight);
        this.field_70180_af.func_75682_a(27, (Object)1);
        this.field_70180_af.func_75682_a(28, (Object)0);
    }

    public EntityTracksBuilder(World world, double d, double d1, double d2) {
        this(world);
        this.func_70107_b(d, d1 + (double)this.field_70129_M, d2);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d1;
        this.field_70166_s = d2;
        this.currentHeight = this.field_70163_u;
        this.plannedHeight = (int)this.currentHeight - 1;
        this.setPlannedHeight(this.plannedHeight);
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        this.field_70128_L = true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.Smoke();
        }
        this.currentHeight = this.field_70163_u;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.tunnelBlockStack = new ItemStack(Block.func_149684_b((String)"glass"), 1);
        if (this.getFuel() < this.maxFuel && this.BuilderInvent[0] != null) {
            if (FuelHandler.steamFuelLast(this.BuilderInvent[0]) > 0 && this.getFuel() + 300 < this.maxFuel) {
                this.fuelTrain += 300;
                this.func_70298_a(0, 1);
            }
            if (this.BuilderInvent[0] != null && PluginRailcraft.RailcraftParts.INGOT_STEEL.stack != null && this.BuilderInvent[0].func_77969_a(PluginRailcraft.RailcraftParts.INGOT_STEEL.stack) && this.getFuel() + 800 < this.maxFuel) {
                this.fuelTrain += 800;
                this.func_70298_a(0, 1);
            }
            this.field_70180_af.func_75692_b(24, (Object)this.fuelTrain);
        }
        this.moveStacks();
        this.updatePushForces();
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.canDigg()) {
            this.updateState(true);
            this.digBuilder(i, j, k);
        } else {
            this.updateState(false);
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
    }

    private boolean canDigg() {
        return this.checkForBallast() && this.checkForTracks() && this.getFuel() > 0;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("plannedHeight", this.plannedHeight);
        nbttagcompound.func_74757_a("followTracks", this.followTracks);
        nbttagcompound.func_74780_a("PushX", this.pushX);
        nbttagcompound.func_74780_a("PushZ", this.pushZ);
        nbttagcompound.func_74777_a("Trackfuel", (short)this.trackfuel);
        nbttagcompound.func_74777_a("fuel", (short)this.getFuel());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.BuilderInvent.length; ++i) {
            if (this.BuilderInvent[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.BuilderInvent[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.pushX = nbttagcompound.func_74769_h("PushX");
        this.pushZ = nbttagcompound.func_74769_h("PushZ");
        if (nbttagcompound.func_74762_e("plannedHeight") < 4) {
            this.plannedHeight = (int)this.currentHeight;
            this.setPlannedHeight(this.plannedHeight);
        } else {
            this.setPlannedHeight(nbttagcompound.func_74762_e("plannedHeight"));
        }
        this.followTracks = nbttagcompound.func_74767_n("followTracks");
        this.trackfuel = nbttagcompound.func_74765_d("Trackfuel");
        this.fuelTrain = nbttagcompound.func_74765_d("fuel");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.BuilderInvent = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.BuilderInvent.length) continue;
            this.BuilderInvent[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public int func_70302_i_() {
        return this.inventoryBuilderSize;
    }

    public ItemStack func_70301_a(int i) {
        return this.BuilderInvent[i];
    }

    public ItemStack func_70304_b(int par1) {
        if (this.BuilderInvent[par1] != null) {
            ItemStack var2 = this.BuilderInvent[par1];
            this.BuilderInvent[par1] = null;
            return var2;
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.BuilderInvent[i] != null) {
            if (this.BuilderInvent[i].field_77994_a <= j) {
                ItemStack itemstack = this.BuilderInvent[i];
                this.BuilderInvent[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.BuilderInvent[i].func_77979_a(j);
            if (this.BuilderInvent[i].field_77994_a == 0) {
                this.BuilderInvent[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.BuilderInvent[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Tracks Builder";
    }

    @Override
    public boolean func_130002_c(EntityPlayer entityplayer) {
        this.playerEntity = entityplayer;
        if (super.func_130002_c(entityplayer)) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        entityplayer.openGui((Object)Traincraft.instance, 82, this.field_70170_p, this.func_145782_y(), -1, (int)this.field_70161_v);
        this.pushZ = this.field_70161_v - entityplayer.field_70161_v;
        this.pushX = this.field_70165_t - entityplayer.field_70165_t;
        this.applyDragAndPushForces();
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int scaleMaxFuel(int i) {
        return this.getFuel() * i / this.maxFuel;
    }

    @Override
    protected void applyDragAndPushForces() {
        double d26 = MathHelper.func_76133_a((double)(this.pushX * this.pushX + this.pushZ * this.pushZ));
        if (d26 > 0.01) {
            this.pushX /= d26;
            this.pushZ /= d26;
            double d28 = 0.029;
            this.field_70159_w *= 0.2;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= 0.2;
            if (this.getFuel() > 0) {
                this.field_70159_w += this.pushX * d28;
                this.field_70179_y += this.pushZ * d28;
            }
        } else {
            this.field_70159_w *= 0.49999997615814207;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= 0.49999997615814207;
        }
        this.field_70159_w *= this.getDragAir();
        this.field_70181_x *= 0.0;
        this.field_70179_y *= this.getDragAir();
    }

    @Override
    protected void adjustSlopeVelocities(int metadata) {
        if (metadata == 2 || metadata == 3 || metadata == 4 || metadata == 5) {
            this.field_70159_w *= 0.5;
            this.field_70179_y *= 0.5;
        }
    }

    protected void updatePushForces() {
        double push = MathHelper.func_76133_a((double)(this.pushX * this.pushX + this.pushZ * this.pushZ));
        if (push > 0.01 && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.001) {
            this.pushX /= push;
            this.pushZ /= push;
            if (this.pushX * this.field_70159_w + this.pushZ * this.field_70179_y < 0.0) {
                this.pushX = 0.0;
                this.pushZ = 0.0;
            } else {
                this.pushX = this.field_70159_w;
                this.pushZ = this.field_70179_y;
            }
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return !this.field_70128_L && entityplayer.func_70068_e((Entity)this) <= 64.0;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return !this.field_70128_L && entityplayer.func_70068_e((Entity)this) <= 64.0;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        float dist = 1.6f;
        return dist + 0.5f;
    }

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return false;
    }

    public void Smoke() {
        if (this.getFuel() > 0) {
            --this.fuelTrain;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(24, (Object)this.fuelTrain);
            }
        }
    }

    public int getFuel() {
        if (this.field_70170_p.field_72995_K) {
            return this.field_70180_af.func_75679_c(24);
        }
        return this.fuelTrain;
    }

    private void updateState(boolean state) {
        if (state) {
            this.field_70180_af.func_75692_b(28, (Object)1);
        }
        if (!state) {
            this.field_70180_af.func_75692_b(28, (Object)0);
        }
    }

    public boolean getState() {
        return this.field_70180_af.func_75679_c(28) == 1;
    }

    public void setPlannedHeightFromPacket(int packet) {
        int currentPlanned = this.getPlannedHeight();
        int request = packet + currentPlanned;
        if (request > 256) {
            request = 256;
        }
        if (request < 4) {
            request = 4;
        }
        this.setPlannedHeight(request);
    }

    public void setPlannedHeight(int plannedHeight) {
        this.field_70180_af.func_75692_b(26, (Object)plannedHeight);
        this.plannedHeight = plannedHeight;
    }

    public int getPlannedHeight() {
        return this.field_70180_af.func_75679_c(26);
    }

    public void setFollowTracksFromPacket(int packet) {
        this.setFollowTracks(packet);
    }

    public void setFollowTracks(int follow) {
        this.field_70180_af.func_75692_b(27, (Object)follow);
        if (follow == 1) {
            this.followTracks = true;
        }
        if (follow == 0) {
            this.followTracks = false;
        }
    }

    public int getFollowTracks() {
        return this.field_70180_af.func_75679_c(27);
    }

    public boolean isBlockInteresting(ItemStack i) {
        Item blockNow = i.func_77973_b();
        boolean is = false;
        is = blockNow == Item.field_150901_e.func_82594_a("diamond") ? true : (blockNow == Item.field_150901_e.func_82594_a("ingotGold") ? true : (blockNow == Item.field_150901_e.func_82594_a("ingotIron") ? true : (blockNow == Item.field_150901_e.func_82594_a("dyePowder") ? true : (blockNow == Item.field_150901_e.func_82594_a("coal") ? true : (blockNow == Item.field_150901_e.func_82594_a("redstone") ? true : BuilderOreHandler.isOre(Item.func_150891_b((Item)blockNow)))))));
        return is;
    }

    public void putInInvent(ItemStack itemdug) {
        boolean hasBeenPlaced = false;
        boolean noFreight = true;
        List lis = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(4.600000002980233, 4.600000002980233, 4.600000002980233));
        if (lis != null && lis.size() > 0) {
            for (int j1 = 0; j1 < lis.size(); ++j1) {
                Entity entity = (Entity)lis.get(j1);
                if (entity instanceof Freight && (this.isAttached || this.isLinked()) && ((Freight)entity).cargoItems != null && ((Freight)entity).cargoItems.length > 0) {
                    noFreight = false;
                    for (int u = 0; u < ((Freight)entity).cargoItems.length; ++u) {
                        ItemStack itemInside = ((IInventory)entity).func_70301_a(u);
                        if (itemInside != null && ((Freight)entity).cargoItems[u].field_77994_a != 0 && ((Freight)entity).cargoItems[u].func_77973_b() == itemdug.func_77973_b() && ((Freight)entity).cargoItems[u].func_77960_j() == itemdug.func_77960_j() && ((Freight)entity).cargoItems[u].field_77994_a != this.func_70297_j_()) {
                            ++((Freight)entity).cargoItems[u].field_77994_a;
                            hasBeenPlaced = true;
                            u = ((Freight)entity).cargoItems.length;
                            j1 = lis.size();
                            continue;
                        }
                        if (itemInside == null) {
                            if (((Freight)entity).cargoItems[u] != null) continue;
                            ((Freight)entity).cargoItems[u] = itemdug;
                            hasBeenPlaced = true;
                            u = ((Freight)entity).cargoItems.length;
                            j1 = lis.size();
                            continue;
                        }
                        if (hasBeenPlaced || u != ((Freight)entity).cargoItems.length) continue;
                        noFreight = true;
                    }
                    continue;
                }
                noFreight = true;
            }
        } else {
            noFreight = true;
        }
        if (noFreight) {
            for (int u = this.MoreBuilderInvent; u < this.BuilderInvent.length; ++u) {
                ItemStack itemInside = this.func_70301_a(u);
                if (itemInside != null && this.BuilderInvent[u].field_77994_a != 0 && this.BuilderInvent[u].func_77973_b() == itemdug.func_77973_b() && this.BuilderInvent[u].func_77960_j() == itemdug.func_77960_j() && this.BuilderInvent[u].field_77994_a != this.func_70297_j_()) {
                    ++this.BuilderInvent[u].field_77994_a;
                    hasBeenPlaced = true;
                    u = this.BuilderInvent.length;
                    continue;
                }
                if (itemInside == null) {
                    if (this.BuilderInvent[u] != null) continue;
                    this.BuilderInvent[u] = itemdug;
                    hasBeenPlaced = true;
                    u = this.BuilderInvent.length;
                    continue;
                }
                if (hasBeenPlaced || u != this.BuilderInvent.length - 1) continue;
                this.func_70099_a(itemdug, 1.0f);
                u = this.BuilderInvent.length;
            }
        }
    }

    private boolean canBeBallast(ItemStack stack) {
        return this.canBeTunnel(stack);
    }

    private boolean canBeTunnel(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        if (stack.func_77973_b() != null) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block.hasTileEntity(stack.func_77973_b().func_77647_b(stack.func_77960_j()))) {
                return false;
            }
            return block.func_149645_b() == 0;
        }
        return false;
    }

    private void checkBlock() {
        this.underBlock2Stack = null;
        this.underBlockStack = null;
        this.upperBlockStack = null;
        this.upperCenterBlockStack = null;
        this.upperBlock1Stack = null;
        for (int i = 1; i < 7; ++i) {
            if (this.BuilderInvent[i] == null) continue;
            if (this.canBeBallast(this.BuilderInvent[i])) {
                if (i == 2) {
                    this.underBlock2Stack = this.BuilderInvent[2].func_77946_l();
                }
            } else if (!this.canBeBallast(this.BuilderInvent[2])) {
                this.underBlock2Stack = null;
            }
            if (this.canBeTunnel(this.BuilderInvent[i])) {
                if (i == 4) {
                    this.upperBlockStack = this.BuilderInvent[4].func_77946_l();
                }
                if (i == 5) {
                    this.upperCenterBlockStack = this.BuilderInvent[5].func_77946_l();
                }
                if (i != 6) continue;
                this.upperBlock1Stack = this.BuilderInvent[6].func_77946_l();
                continue;
            }
            if (this.canBeTunnel(this.BuilderInvent[i])) continue;
            if (i == 4) {
                this.upperBlockStack = new ItemStack(Block.func_149684_b((String)"stone"));
            }
            if (i == 5) {
                this.upperCenterBlockStack = new ItemStack(Block.func_149684_b((String)"stone"));
            }
            if (i != 6) continue;
            this.upperBlock1Stack = new ItemStack(Block.func_149684_b((String)"stone"));
        }
        if (this.BuilderInvent[7] != null && this.canBeTunnel(this.BuilderInvent[7])) {
            this.tunnelBlockStack = this.BuilderInvent[7].func_77946_l();
            this.tunnelActive = true;
        } else {
            this.tunnelActive = false;
        }
    }

    private void moveStacks() {
        int i;
        if (this.BuilderInvent[1] == null) {
            for (i = 8; i <= 10; ++i) {
                if (this.BuilderInvent[i] == null || !RailTools.isTrackItem(this.BuilderInvent[i]) && Item.func_150891_b((Item)this.BuilderInvent[i].func_77973_b()) != Block.func_149682_b((Block)Blocks.field_150448_aq) && Item.func_150891_b((Item)this.BuilderInvent[i].func_77973_b()) != Block.func_149682_b((Block)Block.func_149684_b((String)"railPowered")) && Item.func_150891_b((Item)this.BuilderInvent[i].func_77973_b()) != Block.func_149682_b((Block)Block.func_149684_b((String)"railDetector.blockID"))) continue;
                this.BuilderInvent[1] = this.BuilderInvent[i].func_77946_l();
                this.func_70298_a(i, 64);
                break;
            }
        }
        if (this.BuilderInvent[3] == null) {
            for (i = 11; i <= 13; ++i) {
                if (!this.canBeBallast(this.BuilderInvent[i])) continue;
                this.BuilderInvent[3] = this.BuilderInvent[i].func_77946_l();
                this.func_70298_a(i, 64);
                break;
            }
        }
        if (this.BuilderInvent[2] == null) {
            for (i = 14; i <= 16; ++i) {
                if (!this.canBeBallast(this.BuilderInvent[i])) continue;
                this.BuilderInvent[2] = this.BuilderInvent[i].func_77946_l();
                this.func_70298_a(i, 64);
                break;
            }
        }
        if (this.BuilderInvent[7] == null) {
            for (i = 17; i <= 19; ++i) {
                if (!this.canBeTunnel(this.BuilderInvent[i])) continue;
                this.BuilderInvent[7] = this.BuilderInvent[i].func_77946_l();
                this.func_70298_a(i, 64);
                break;
            }
        }
    }

    public void getBlockList(World worldObj, int i, int j, int k) {
        if (Block.func_149682_b((Block)worldObj.func_147439_a(i, j, k)) != 0) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(TrainModBlockUtil.getItemStackFromBlock(worldObj, i, j, k));
            for (ItemStack s : stacks) {
                if (BlockRailBase.func_150051_a((Block)Block.func_149634_a((Item)s.func_77973_b()))) {
                    return;
                }
                if (Item.func_150891_b((Item)s.func_77973_b()) == 0 || s.func_77973_b() == Item.func_150898_a((Block)Block.func_149684_b((String)"glass")) || Item.func_150891_b((Item)s.func_77973_b()) == Item.func_150891_b((Item)this.tunnelBlockStack.func_77973_b()) || Block.func_149682_b((Block)worldObj.func_147439_a(i, j, k)) == Item.func_150891_b((Item)this.tunnelBlockStack.func_77973_b())) continue;
                this.putInInvent(s);
            }
        }
    }

    private void harvestBlock_do(Vec3 pos) {
        if (pos == null) {
            return;
        }
        int id = Block.func_149682_b((Block)this.field_70170_p.func_147439_a((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c));
        int meta = this.field_70170_p.func_72805_g((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
        if (Block.func_149729_e((int)id) != null && id != 0 && !this.field_70170_p.field_72995_K) {
            this.playMiningEffect(pos, id);
        }
        if (!this.shouldIgnoreBlockForHarvesting(pos, id) && Block.func_149729_e((int)id) != null) {
            this.field_70170_p.func_147468_f((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
            this.field_70170_p.func_72926_e(2001, (int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c, id + (meta << 12));
            if (!this.field_70170_p.field_72995_K) {
                this.playMiningEffect(pos, id);
            }
        }
    }

    private boolean shouldIgnoreBlockForHarvesting(Vec3 pos, int id) {
        return id == 0 || Block.func_149729_e((int)id) == null || id == Block.func_149682_b((Block)Blocks.field_150357_h) || id == Block.func_149682_b((Block)Blocks.field_150480_ab) || id == Block.func_149682_b((Block)Blocks.field_150427_aO) || id == Block.func_149682_b((Block)Blocks.field_150384_bq) || Block.func_149729_e((int)id) instanceof BlockLiquid || id == 55 || id == 70 || id == 72;
    }

    private void playMiningEffect(Vec3 pos, int block_index) {
        ++this.miningTickCounter;
        int id = Block.func_149682_b((Block)this.field_70170_p.func_147439_a((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c));
        Block block = Block.func_149729_e((int)id);
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S()) {
            if (this.miningTickCounter % 8 == 0 && block != null && !this.field_70170_p.field_72995_K && Minecraft.func_71410_x() != null) {
                this.field_70170_p.func_72980_b((double)((float)((int)pos.field_72450_a) + 0.5f), (double)((float)((int)pos.field_72448_b) + 0.5f), (double)((float)((int)pos.field_72449_c) + 0.5f), block.field_149762_H.func_150495_a(), 1.0f, block.field_149762_H.func_150494_d() * 0.5f, true);
            }
            if (this.miningTickCounter % 8 == 0 && block_index != 0 && block != null && pos != null && FMLClientHandler.instance().getClient() != null) {
                FMLClientHandler.instance().getClient().field_71452_i.func_78867_a((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c, block_index < 4 ? this.getSideFromYaw() : (block_index < 6 ? 1 : 0));
            }
        }
    }

    private int getSideFromYaw() {
        if (this.field_70177_z == 0.0f) {
            return 5;
        }
        if (this.field_70177_z == 90.0f) {
            return 3;
        }
        if (this.field_70177_z == 180.0f) {
            return 4;
        }
        if (this.field_70177_z == 270.0f) {
            return 2;
        }
        return 1;
    }

    public boolean noRoof(int i) {
        return i == 0 || i == 6 || i == 18 || i == 23 || i == 25 || i == 26 || i == 27 || i == 28 || i == 29 || i == 35 || i == 41 || i == 46 || i == 52 || i == 54 || i == 55 || i == 53 || i == 61 || i == 62 || i == 58 || i == 64 || i == 65 || i == 66 || i == 75 || i == 76 || i == 78 || i == 81 || i == 83 || i == 84 || i == 85 || i == 93 || i == 94 || i == 95 || i == 96 || i == 101 || i == 106 || i == 107 || i == 111 || i == 115 || i == 116 || i == 117 || i == 118 || i == 122 || i == Block.func_149682_b((Block)Block.func_149684_b((String)"wood")) || BuilderOreHandler.isOre(i);
    }

    public void putRoof(int i, int j, int k, int inv, World worldObj, ItemStack block) {
        if (!this.tunnelActive && block != null && Block.func_149682_b((Block)worldObj.func_147439_a(i, j, k)) != Item.func_150891_b((Item)block.func_77973_b())) {
            this.getBlockList(worldObj, i, j, k);
            worldObj.func_147465_d(i, j, k, Block.func_149634_a((Item)block.func_77973_b()), block.func_77973_b().func_77647_b(block.func_77960_j()), 3);
            this.func_70298_a(inv, 1);
        }
    }

    private boolean checkForBallast() {
        if (this.BuilderInvent[3] != null && this.canBeBallast(this.BuilderInvent[3])) {
            this.underBlockStack = this.BuilderInvent[3].func_77946_l();
            return true;
        }
        return false;
    }

    private boolean checkForTracks() {
        if (this.BuilderInvent[1] != null) {
            if (RailTools.isTrackItem(this.BuilderInvent[1]) && this.getFuel() > 0) {
                this.trackfuel = 1;
                this.tracksStack = this.BuilderInvent[1].func_77946_l();
                return true;
            }
            if (Item.func_150891_b((Item)this.BuilderInvent[1].func_77973_b()) == Item.func_150891_b((Item)Items.field_151042_j) && this.getFuel() > 0) {
                this.trackfuel = 1;
                this.tracksStack = new ItemStack(Blocks.field_150448_aq);
                return true;
            }
            if (Item.func_150891_b((Item)this.BuilderInvent[1].func_77973_b()) == Item.func_150891_b((Item)ItemIDs.steel.item) && this.getFuel() > 0) {
                this.trackfuel = 1;
                this.tracksStack = new ItemStack(Blocks.field_150448_aq);
                return true;
            }
            if ((Item.func_150891_b((Item)this.BuilderInvent[1].func_77973_b()) == Block.func_149682_b((Block)Blocks.field_150448_aq) || Item.func_150891_b((Item)this.BuilderInvent[1].func_77973_b()) == Block.func_149682_b((Block)Blocks.field_150318_D) || Item.func_150891_b((Item)this.BuilderInvent[1].func_77973_b()) == Block.func_149682_b((Block)Blocks.field_150319_E)) && this.getFuel() > 0) {
                this.tracksStack = this.BuilderInvent[1].func_77946_l();
                this.trackfuel = 1;
                return true;
            }
        } else {
            this.trackfuel = 0;
            return false;
        }
        return false;
    }

    private int getFacing() {
        this.rotation = !this.field_70170_p.field_72995_K ? (float)(Math.atan2(this.d7, this.d6) * 180.0 / Math.PI) : (float)(Math.atan2(0.0 - this.field_70159_w, 0.0 - this.field_70179_y) * 180.0 / Math.PI);
        return MathHelper.func_76128_c((double)((double)(this.rotation * 4.0f / 360.0f) + 0.5)) & 3;
    }

    private int checkForHeight() {
        if ((int)this.currentHeight < this.getPlannedHeight()) {
            return 1;
        }
        if ((int)this.currentHeight > this.getPlannedHeight()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (this.canBeDestroyedByPlayer(damagesource)) {
            return true;
        }
        super.func_70097_a(damagesource, i);
        this.func_70494_i(-this.func_70493_k());
        this.func_70497_h(10);
        this.func_70018_K();
        this.func_70492_c(this.func_70491_i() + i * 10.0f);
        if (this.func_70491_i() > 40.0f) {
            if (this.field_70153_n != null) {
                this.field_70153_n.func_70078_a((Entity)this);
            }
            this.func_70106_y();
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                this.dropCartAsItem(((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d);
                for (ItemStack stack : this.BuilderInvent) {
                    if (stack == null) continue;
                    this.func_70099_a(stack, 0.0f);
                }
            }
        }
        return true;
    }

    private void digBuilder(int i, int j, int k) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int iX = 0;
        int kZ = 0;
        this.checkBlock();
        this.checkForTracks();
        this.checkForBallast();
        int hY = this.checkForHeight();
        if (this.trackfuel >= 1) {
            if (this.getFacing() == 1) {
                iX = 0;
                kZ = -1;
            } else if (this.getFacing() == 2) {
                iX = 1;
                kZ = 0;
            } else if (this.getFacing() == 3) {
                iX = 0;
                kZ = 1;
            } else if (this.getFacing() == 0) {
                iX = -1;
                kZ = 0;
            } else {
                return;
            }
            int roofYOffset = 0;
            if (hY != 0) {
                roofYOffset = 1;
            }
            if (iX != 0) {
                this.putRoof(i + iX, j + 4 + roofYOffset + hY, k, 5, this.field_70170_p, this.upperCenterBlockStack);
                this.putRoof(i + iX, j + 4 + roofYOffset + hY, k - 1, 4, this.field_70170_p, this.upperBlockStack);
                this.putRoof(i + iX, j + 4 + roofYOffset + hY, k + 1, 6, this.field_70170_p, this.upperBlock1Stack);
            } else if (kZ != 0) {
                this.putRoof(i, j + 4 + roofYOffset + hY, k + kZ, 5, this.field_70170_p, this.upperCenterBlockStack);
                this.putRoof(i - 1, j + 4 + roofYOffset + hY, k + kZ, 4, this.field_70170_p, this.upperBlockStack);
                this.putRoof(i + 1, j + 4 + roofYOffset + hY, k + kZ, 6, this.field_70170_p, this.upperBlock1Stack);
            }
            if (iX != 0) {
                this.digAwayXAxis(i, j, k, iX, hY);
            } else if (kZ != 0) {
                this.digAwayZAxis(i, j, k, kZ, hY);
            }
            if (hY == 0 && this.underBlockStack != null && this.field_70170_p.func_147439_a(i, j - 1 + hY, k) != Block.func_149634_a((Item)this.underBlockStack.func_77973_b()) && this.field_70170_p.func_147439_a(i, j - 1 + hY, k) != Block.func_149634_a((Item)this.tracksStack.func_77973_b())) {
                this.getBlockList(this.field_70170_p, i, j - 1, k);
                this.field_70170_p.func_147465_d(i, j - 1 + hY, k, Block.func_149634_a((Item)this.underBlockStack.func_77973_b()), this.underBlockStack.func_77973_b().func_77647_b(this.underBlockStack.func_77960_j()), 3);
                this.func_70298_a(3, 1);
            }
            if (hY > 0 && this.underBlockStack != null && this.field_70170_p.func_147439_a(i + iX, j - 1 + hY, k + kZ) != Block.func_149634_a((Item)this.underBlockStack.func_77973_b()) && this.field_70170_p.func_147439_a(i + iX, j - 1 + hY, k + kZ) != Block.func_149634_a((Item)this.tracksStack.func_77973_b())) {
                this.getBlockList(this.field_70170_p, i + iX, j - 1, k + kZ);
                this.field_70170_p.func_147465_d(i + iX, j - 1 + hY, k + kZ, Block.func_149634_a((Item)this.underBlockStack.func_77973_b()), this.underBlockStack.func_77973_b().func_77647_b(this.underBlockStack.func_77960_j()), 3);
                this.func_70298_a(3, 1);
            } else if (hY < 0 && this.underBlockStack != null && this.field_70170_p.func_147439_a(i, j - 1 + hY, k) != Block.func_149634_a((Item)this.underBlockStack.func_77973_b()) && this.field_70170_p.func_147439_a(i, j - 1 + hY, k) != Block.func_149634_a((Item)this.tracksStack.func_77973_b())) {
                this.getBlockList(this.field_70170_p, i, j - 1 + hY, k);
                this.field_70170_p.func_147465_d(i, j - 2, k, Block.func_149634_a((Item)this.underBlockStack.func_77973_b()), this.underBlockStack.func_77973_b().func_77647_b(this.underBlockStack.func_77960_j()), 3);
                this.func_70298_a(3, 1);
                this.getBlockList(this.field_70170_p, i, j + hY, k);
                this.getBlockList(this.field_70170_p, i + 1, j + hY, k);
                this.getBlockList(this.field_70170_p, i - 1, j + hY, k);
                this.harvestBlock_do(Vec3.func_72443_a((double)i, (double)(j + hY), (double)k));
                this.harvestBlock_do(Vec3.func_72443_a((double)(i + 1), (double)(j + hY), (double)k));
                this.harvestBlock_do(Vec3.func_72443_a((double)(i - 1), (double)(j + hY), (double)k));
            }
            if (this.underBlock2Stack != null && this.field_70170_p.func_147439_a(i + iX, j - 2 + hY, k + kZ) != Block.func_149634_a((Item)this.underBlock2Stack.func_77973_b())) {
                this.getBlockList(this.field_70170_p, i + iX, j - 2 + hY, k + kZ);
                this.field_70170_p.func_147465_d(i + iX, j - 2 + hY, k + kZ, Block.func_149634_a((Item)this.underBlock2Stack.func_77973_b()), this.underBlock2Stack.func_77973_b().func_77647_b(this.underBlock2Stack.func_77960_j()), 3);
                this.func_70298_a(2, 1);
            }
            if (hY == 0 && !BlockRailBase.func_150051_a((Block)this.field_70170_p.func_147439_a(i, j + hY, k)) && !BlockRailBase.func_150051_a((Block)this.field_70170_p.func_147439_a(i, j, k)) && Blocks.field_150448_aq.func_149742_c(this.field_70170_p, i, j + hY, k)) {
                this.checkForTracks();
                --this.trackfuel;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70298_a(1, 1);
                }
                RailTools.placeRailAt(this.tracksStack.func_77946_l(), this.field_70170_p, i, j + hY, k);
            } else if (hY < 0 && Block.func_149682_b((Block)this.field_70170_p.func_147439_a(i, j + hY, k)) == 0 && Block.func_149682_b((Block)this.field_70170_p.func_147439_a(i, j + hY - 1, k)) != 0 && Blocks.field_150448_aq.func_149742_c(this.field_70170_p, i, j + hY, k)) {
                this.checkForTracks();
                --this.trackfuel;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70298_a(1, 1);
                }
                RailTools.placeRailAt(this.tracksStack.func_77946_l(), this.field_70170_p, i, j + hY, k);
            } else if (hY > 0 && Blocks.field_150448_aq != this.field_70170_p.func_147439_a(i + iX, j + hY, k + kZ) && Blocks.field_150448_aq != this.field_70170_p.func_147439_a(i + iX, j + hY + 1, k + kZ) && Blocks.field_150448_aq != this.field_70170_p.func_147439_a(i + iX, j, k + kZ) && Blocks.field_150448_aq != this.field_70170_p.func_147439_a(i, j + hY, k) && Blocks.field_150448_aq != this.field_70170_p.func_147439_a(i, j - hY, k) && Blocks.field_150448_aq.func_149742_c(this.field_70170_p, i + iX, j + hY, k + kZ)) {
                this.checkForTracks();
                --this.trackfuel;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70298_a(1, 1);
                }
                RailTools.placeRailAt(this.tracksStack.func_77946_l(), this.field_70170_p, i + iX, j + hY, k + kZ);
            }
        }
    }

    private void digAwayXAxis(int i, int j, int k, int iX, int hY) {
        for (int a = 0; a <= 3; ++a) {
            this.getBlockList(this.field_70170_p, i + iX, j + hY + a, k);
            this.getBlockList(this.field_70170_p, i + iX, j + hY + a, k + 1);
            this.getBlockList(this.field_70170_p, i + iX, j + hY + a, k - 1);
        }
        if (this.field_70170_p.func_147439_a(i + iX, j + hY, k - 1) != Blocks.field_150448_aq && this.field_70170_p.func_147439_a(i + iX, j + hY, k - 1) != BlockIDs.tcRail.block && this.field_70170_p.func_147439_a(i + iX, j + hY, k - 1) != BlockIDs.tcRailGag.block && this.followTracks) {
            this.field_70170_p.func_147449_b(i + iX, j + hY, k - 1, Blocks.field_150350_a);
            this.harvestBlock_do(Vec3.func_72443_a((double)(i - 1), (double)(j + hY), (double)(k - 1)));
        }
        if (this.field_70170_p.func_147439_a(i + iX, j + hY, k + 1) != Blocks.field_150448_aq && this.field_70170_p.func_147439_a(i + iX, j + hY, k + 1) != BlockIDs.tcRail.block && this.field_70170_p.func_147439_a(i + iX, j + hY, k + 1) != BlockIDs.tcRailGag.block && this.followTracks) {
            this.field_70170_p.func_147449_b(i + iX, j + hY, k + 1, Blocks.field_150350_a);
            this.harvestBlock_do(Vec3.func_72443_a((double)(i + 1), (double)(j + hY), (double)(k + 1)));
        }
        if (this.field_70170_p.func_147439_a(i + iX, j + hY, k) != Blocks.field_150448_aq && this.field_70170_p.func_147439_a(i + iX, j + hY, k) != BlockIDs.tcRail.block && this.field_70170_p.func_147439_a(i + iX, j + hY, k) != BlockIDs.tcRailGag.block && this.followTracks) {
            this.field_70170_p.func_147449_b(i + iX, j + hY, k, Blocks.field_150350_a);
            this.harvestBlock_do(Vec3.func_72443_a((double)(i + iX), (double)(j + hY), (double)k));
        }
        for (int b = 1; b <= 3; ++b) {
            this.harvestBlock_do(Vec3.func_72443_a((double)(i + iX), (double)(j + hY + b), (double)k));
            this.harvestBlock_do(Vec3.func_72443_a((double)(i + iX), (double)(j + hY + b), (double)(k + 1)));
            this.harvestBlock_do(Vec3.func_72443_a((double)(i + iX), (double)(j + hY + b), (double)(k - 1)));
        }
        if (this.tunnelActive) {
            for (int c = 0; c <= 3; ++c) {
                this.getBlockList(this.field_70170_p, i + iX, j + hY + c, k - 2);
                this.getBlockList(this.field_70170_p, i + iX, j + hY + c, k + 2);
                if (this.field_70170_p.func_147439_a(i + iX, j + hY + c, k - 2) == Block.func_149634_a((Item)this.tunnelBlockStack.func_77973_b()) && this.field_70170_p.func_72805_g(i + iX, j + hY + c, k - 2) == this.tunnelBlockStack.func_77973_b().func_77647_b(this.tunnelBlockStack.func_77960_j())) {
                    return;
                }
                this.harvestBlock_do(Vec3.func_72443_a((double)(i + iX), (double)(j + hY + c), (double)(k - 2)));
                this.field_70170_p.func_147465_d(i + iX, j + hY + c, k - 2, Block.func_149634_a((Item)this.tunnelBlockStack.func_77973_b()), this.tunnelBlockStack.func_77973_b().func_77647_b(this.tunnelBlockStack.func_77960_j()), 3);
                this.func_70298_a(7, 1);
                if (this.field_70170_p.func_147439_a(i + iX, j + hY + c, k + 2) == Block.func_149634_a((Item)this.tunnelBlockStack.func_77973_b()) && this.field_70170_p.func_72805_g(i + iX, j + hY + c, k + 2) == this.tunnelBlockStack.func_77973_b().func_77647_b(this.tunnelBlockStack.func_77960_j())) {
                    return;
                }
                this.harvestBlock_do(Vec3.func_72443_a((double)(i + iX), (double)(j + hY + c), (double)(k + 2)));
                this.field_70170_p.func_147465_d(i + iX, j + hY + c, k + 2, Block.func_149634_a((Item)this.tunnelBlockStack.func_77973_b()), this.tunnelBlockStack.func_77973_b().func_77647_b(this.tunnelBlockStack.func_77960_j()), 3);
                this.func_70298_a(7, 1);
            }
            if (this.upperCenterBlockStack != null) {
                if (this.field_70170_p.func_147439_a(i + iX, j + hY + 4, k) == Block.func_149634_a((Item)this.upperCenterBlockStack.func_77973_b()) && this.field_70170_p.func_72805_g(i + iX, j + hY + 4, k) == this.upperCenterBlockStack.func_77973_b().func_77647_b(this.upperCenterBlockStack.func_77960_j())) {
                    return;
                }
                this.getBlockList(this.field_70170_p, i + iX, j + hY + 4, k);
                this.harvestBlock_do(Vec3.func_72443_a((double)(i + iX), (double)(j + hY + 4), (double)k));
                this.field_70170_p.func_147465_d(i + iX, j + hY + 4, k, Block.func_149634_a((Item)this.upperCenterBlockStack.func_77973_b()), this.upperCenterBlockStack.func_77973_b().func_77647_b(this.upperCenterBlockStack.func_77960_j()), 3);
                this.func_70298_a(5, 1);
            }
            if (this.upperBlockStack != null) {
                if (this.field_70170_p.func_147439_a(i + iX, j + hY + 4, k - 1) == Block.func_149634_a((Item)this.upperBlockStack.func_77973_b()) && this.field_70170_p.func_72805_g(i + iX, j + hY + 4, k - 1) == this.upperBlockStack.func_77973_b().func_77647_b(this.upperBlockStack.func_77960_j())) {
                    return;
                }
                this.getBlockList(this.field_70170_p, i + iX, j + hY + 4, k - 1);
                this.harvestBlock_do(Vec3.func_72443_a((double)(i + iX), (double)(j + hY + 4), (double)(k - 1)));
                this.field_70170_p.func_147465_d(i + iX, j + hY + 4, k - 1, Block.func_149634_a((Item)this.upperBlockStack.func_77973_b()), this.upperBlockStack.func_77973_b().func_77647_b(this.upperBlockStack.func_77960_j()), 3);
                this.func_70298_a(4, 1);
            }
            if (this.upperBlock1Stack != null) {
                if (this.field_70170_p.func_147439_a(i + iX, j + hY + 4, k + 1) == Block.func_149634_a((Item)this.upperBlock1Stack.func_77973_b()) && this.field_70170_p.func_72805_g(i + iX, j + hY + 4, k + 1) == this.upperBlock1Stack.func_77973_b().func_77647_b(this.upperBlock1Stack.func_77960_j())) {
                    return;
                }
                this.getBlockList(this.field_70170_p, i + iX, j + hY + 4, k + 1);
                this.harvestBlock_do(Vec3.func_72443_a((double)(i + iX), (double)(j + hY + 4), (double)(k + k + 1)));
                this.field_70170_p.func_147465_d(i + iX, j + hY + 4, k + 1, Block.func_149634_a((Item)this.upperBlock1Stack.func_77973_b()), this.upperBlock1Stack.func_77973_b().func_77647_b(this.upperBlock1Stack.func_77960_j()), 3);
                this.func_70298_a(6, 1);
            }
        }
    }

    private void digAwayZAxis(int i, int j, int k, int kZ, int hY) {
        for (int a = 0; a <= 3; ++a) {
            this.getBlockList(this.field_70170_p, i, j + hY + a, k + kZ);
            this.getBlockList(this.field_70170_p, i - 1, j + hY + a, k + kZ);
            this.getBlockList(this.field_70170_p, i + 1, j + hY + a, k + kZ);
        }
        if (this.field_70170_p.func_147439_a(i - 1, j + hY, k + kZ) != Blocks.field_150448_aq && this.field_70170_p.func_147439_a(i - 1, j + hY, k + kZ) != BlockIDs.tcRail.block && this.field_70170_p.func_147439_a(i - 1, j + hY, k + kZ) != BlockIDs.tcRailGag.block && this.followTracks) {
            this.field_70170_p.func_147449_b(i - 1, j + hY, k + kZ, Blocks.field_150350_a);
            this.harvestBlock_do(Vec3.func_72443_a((double)(i - 1), (double)(j + hY), (double)(k + kZ)));
        }
        if (this.field_70170_p.func_147439_a(i + 1, j + hY, k + kZ) != Blocks.field_150448_aq && this.field_70170_p.func_147439_a(i + 1, j + hY, k + kZ) != BlockIDs.tcRail.block && this.field_70170_p.func_147439_a(i + 1, j + hY, k + kZ) != BlockIDs.tcRailGag.block && this.followTracks) {
            this.field_70170_p.func_147449_b(i + 1, j + hY, k + kZ, Blocks.field_150350_a);
            this.harvestBlock_do(Vec3.func_72443_a((double)(i + 1), (double)(j + hY), (double)(k + kZ)));
        }
        if (this.field_70170_p.func_147439_a(i, j + hY, k + kZ) != Blocks.field_150448_aq && this.field_70170_p.func_147439_a(i, j + hY, k + kZ) != BlockIDs.tcRail.block && this.field_70170_p.func_147439_a(i, j + hY, k + kZ) != BlockIDs.tcRailGag.block && this.followTracks) {
            this.field_70170_p.func_147449_b(i, j + hY, k + kZ, Blocks.field_150350_a);
            this.harvestBlock_do(Vec3.func_72443_a((double)i, (double)(j + hY), (double)(k + kZ)));
        }
        for (int b = 1; b <= 3; ++b) {
            this.harvestBlock_do(Vec3.func_72443_a((double)i, (double)(j + hY + b), (double)(k + kZ)));
            this.harvestBlock_do(Vec3.func_72443_a((double)(i + 1), (double)(j + hY + b), (double)(k + kZ)));
            this.harvestBlock_do(Vec3.func_72443_a((double)(i - 1), (double)(j + hY + b), (double)(k + kZ)));
        }
        if (this.tunnelActive) {
            for (int c = 0; c <= 3; ++c) {
                this.getBlockList(this.field_70170_p, i - 2, j + hY + c, k + kZ);
                this.getBlockList(this.field_70170_p, i + 2, j + hY + c, k + kZ);
                if (this.field_70170_p.func_147439_a(i - 2, j + hY + c, k + kZ) == Block.func_149634_a((Item)this.tunnelBlockStack.func_77973_b()) && this.field_70170_p.func_72805_g(i - 2, j + hY + c, k + kZ) == this.tunnelBlockStack.func_77973_b().func_77647_b(this.tunnelBlockStack.func_77960_j())) {
                    return;
                }
                this.harvestBlock_do(Vec3.func_72443_a((double)(i - 2), (double)(j + hY + c), (double)(k + kZ)));
                this.field_70170_p.func_147465_d(i - 2, j + hY + c, k + kZ, Block.func_149634_a((Item)this.tunnelBlockStack.func_77973_b()), this.tunnelBlockStack.func_77973_b().func_77647_b(this.tunnelBlockStack.func_77960_j()), 3);
                this.func_70298_a(7, 1);
                if (this.field_70170_p.func_147439_a(i + 2, j + hY + c, k + kZ) == Block.func_149634_a((Item)this.tunnelBlockStack.func_77973_b()) && this.field_70170_p.func_72805_g(i + 2, j + hY + c, k + kZ) == this.tunnelBlockStack.func_77973_b().func_77647_b(this.tunnelBlockStack.func_77960_j())) {
                    return;
                }
                this.harvestBlock_do(Vec3.func_72443_a((double)(i + 2), (double)(j + hY + c), (double)(k + kZ)));
                this.field_70170_p.func_147465_d(i + 2, j + hY + c, k + kZ, Block.func_149634_a((Item)this.tunnelBlockStack.func_77973_b()), this.tunnelBlockStack.func_77973_b().func_77647_b(this.tunnelBlockStack.func_77960_j()), 3);
                this.func_70298_a(7, 1);
            }
            if (this.upperCenterBlockStack != null) {
                if (this.field_70170_p.func_147439_a(i, j + hY + 4, k + kZ) == Block.func_149634_a((Item)this.upperCenterBlockStack.func_77973_b()) && this.field_70170_p.func_72805_g(i, j + hY + 4, k + kZ) == this.upperCenterBlockStack.func_77973_b().func_77647_b(this.upperCenterBlockStack.func_77960_j())) {
                    return;
                }
                this.getBlockList(this.field_70170_p, i, j + hY + 4, k + kZ);
                this.harvestBlock_do(Vec3.func_72443_a((double)i, (double)(j + hY + 4), (double)(k + kZ)));
                this.field_70170_p.func_147465_d(i, j + hY + 4, k + kZ, Block.func_149634_a((Item)this.upperCenterBlockStack.func_77973_b()), this.upperCenterBlockStack.func_77973_b().func_77647_b(this.upperCenterBlockStack.func_77960_j()), 3);
                this.func_70298_a(5, 1);
            }
            if (this.upperBlockStack != null) {
                if (this.field_70170_p.func_147439_a(i - 1, j + hY + 4, k + kZ) == Block.func_149634_a((Item)this.upperBlockStack.func_77973_b()) && this.field_70170_p.func_72805_g(i - 1, j + hY + 4, k + kZ) == this.upperBlockStack.func_77973_b().func_77647_b(this.upperBlockStack.func_77960_j())) {
                    return;
                }
                this.getBlockList(this.field_70170_p, i - 1, j + hY + 4, k + kZ);
                this.harvestBlock_do(Vec3.func_72443_a((double)(i - 1), (double)(j + hY + 4), (double)(k + kZ)));
                this.field_70170_p.func_147465_d(i - 1, j + hY + 4, k + kZ, Block.func_149634_a((Item)this.upperBlockStack.func_77973_b()), this.upperBlockStack.func_77973_b().func_77647_b(this.upperBlockStack.func_77960_j()), 3);
                this.func_70298_a(4, 1);
            }
            if (this.upperBlock1Stack != null) {
                if (this.field_70170_p.func_147439_a(i + 1, j + hY + 4, k + kZ) == Block.func_149634_a((Item)this.upperBlock1Stack.func_77973_b()) && this.field_70170_p.func_72805_g(i + 1, j + hY + 4, k + kZ) == this.upperBlock1Stack.func_77973_b().func_77647_b(this.upperBlock1Stack.func_77960_j())) {
                    return;
                }
                this.getBlockList(this.field_70170_p, i + 1, j + hY + 4, k + kZ);
                this.harvestBlock_do(Vec3.func_72443_a((double)(i + 1), (double)(j + hY + 4), (double)(k + kZ)));
                this.field_70170_p.func_147465_d(i + 1, j + hY + 4, k + kZ, Block.func_149634_a((Item)this.upperBlock1Stack.func_77973_b()), this.upperBlock1Stack.func_77973_b().func_77647_b(this.upperBlock1Stack.func_77960_j()), 3);
                this.func_70298_a(6, 1);
            }
        }
    }

    public void func_70296_d() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public GameProfile getOwner() {
        return null;
    }
}

