/*
 * Decompiled with CFR 0.152.
 */
package train.common.generation;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import train.common.core.handlers.ConfigHandler;
import train.common.core.handlers.RetrogenHandler;
import train.common.library.BlockIDs;

public class WorldGenWorld
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        RetrogenHandler.gennedChunks.add(new RetrogenHandler.ChunkData(chunkX, chunkZ, world.field_73011_w.field_76574_g));
        if (world.field_73011_w.field_76577_b != WorldType.field_77138_c) {
            if (ConfigHandler.ORE_GEN) {
                this.addOreSpawn(BlockIDs.oreTC.block, 1, (Block)Blocks.field_150354_m, world, random, chunkX * 16, chunkZ * 16, 10, 2, 25, 75);
                this.addOreSpawn(BlockIDs.oreTC.block, 2, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, 14, 3, 10, 50);
            }
            if (ConfigHandler.COPPER_ORE_GEN) {
                this.addOreSpawn(BlockIDs.oreTC.block, 0, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, 6, 4, 5, 50);
            }
        }
    }

    private void addOreSpawn(Block block, int meta, Block blockIn, World world, Random random, int blockXPos, int blockZPos, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        if (maxY > minY) {
            int yDiff = maxY - minY;
            for (int i = 0; i < chancesToSpawn; ++i) {
                int posX = blockXPos + random.nextInt(16);
                int posY = minY + random.nextInt(yDiff);
                int posZ = blockZPos + random.nextInt(16);
                new WorldGenMinable(block, meta, maxVeinSize, blockIn).func_76484_a(world, random, posX, posY, posZ);
            }
        }
    }
}

