/*
 * Decompiled with CFR 0.152.
 */
package train.common.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import train.common.core.interfaces.ITCRecipe;
import train.common.recipes.OpenHearthFurnaceRecipe;
import train.common.recipes.ShapedTrainRecipes;
import train.common.recipes.ShapelessTrainRecipe;

public class TrainCraftingManager {
    public static final TrainCraftingManager instance = new TrainCraftingManager();
    private List recipes = new ArrayList();
    private final ArrayList<ShapedTrainRecipes> shapedRecipes = new ArrayList();
    private final HashMap<Integer, ArrayList<Integer>> hearthFurnaceMap = new HashMap();
    private final ArrayList<OpenHearthFurnaceRecipe> hearthFurnaceRecipes = new ArrayList();
    private final HashMap<Integer, Float> hearthFurnaceXpMap = new HashMap();

    public static final TrainCraftingManager getInstance() {
        return instance;
    }

    private TrainCraftingManager() {
    }

    public void addRecipe(ItemStack par1ItemStack, Object ... obj) {
        String var3 = "";
        int var4 = 0;
        int var5 = 0;
        int var6 = 0;
        if (obj[var4] instanceof String[]) {
            String[] var7 = (String[])obj[var4++];
            for (int var8 = 0; var8 < var7.length; ++var8) {
                String var9 = var7[var8];
                ++var6;
                var5 = var9.length();
                var3 = var3 + var9;
            }
        } else {
            while (obj[var4] instanceof String) {
                String var11 = (String)obj[var4++];
                ++var6;
                var5 = var11.length();
                var3 = var3 + var11;
            }
        }
        HashMap<Character, ItemStack> var12 = new HashMap<Character, ItemStack>();
        while (var4 < obj.length) {
            Character var13 = (Character)obj[var4];
            ItemStack var14 = null;
            if (obj[var4 + 1] instanceof Item) {
                var14 = new ItemStack((Item)obj[var4 + 1]);
            } else if (obj[var4 + 1] instanceof Block) {
                var14 = new ItemStack((Block)obj[var4 + 1], 1, -1);
            } else if (obj[var4 + 1] instanceof ItemStack) {
                var14 = (ItemStack)obj[var4 + 1];
            }
            var12.put(var13, var14);
            var4 += 2;
        }
        ItemStack[] var15 = new ItemStack[9];
        for (int var16 = 0; var16 < var5 * var6; ++var16) {
            char var10 = var3.charAt(var16);
            var15[var16] = var12.containsKey(Character.valueOf(var10)) ? ((ItemStack)var12.get(Character.valueOf(var10))).func_77946_l() : null;
        }
        this.recipes.add(new ShapedTrainRecipes(var5, var6, var15, par1ItemStack));
        this.shapedRecipes.add(new ShapedTrainRecipes(var5, var6, var15, par1ItemStack));
    }

    public void addShapelessRecipe(ItemStack par1ItemStack, Object ... obj) {
        ArrayList<ItemStack> var3 = new ArrayList<ItemStack>();
        for (Object tempobj : obj) {
            if (tempobj instanceof ItemStack) {
                var3.add(((ItemStack)tempobj).func_77946_l());
                continue;
            }
            if (tempobj instanceof Item) {
                var3.add(new ItemStack((Item)tempobj));
                continue;
            }
            if (!(tempobj instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipy!");
            }
            var3.add(new ItemStack((Block)tempobj));
        }
        this.recipes.add(new ShapelessTrainRecipe(par1ItemStack, var3));
    }

    public ItemStack func_82787_a(IInventory inv, World world) {
        int var5;
        int occupedSlot = 0;
        ItemStack var3 = null;
        ItemStack var4 = null;
        for (var5 = 0; var5 < inv.func_70302_i_(); ++var5) {
            ItemStack var6 = inv.func_70301_a(var5);
            if (var6 == null) continue;
            if (occupedSlot == 0) {
                var3 = var6;
            }
            if (occupedSlot == 1) {
                var4 = var6;
            }
            ++occupedSlot;
        }
        if (occupedSlot == 2 && var3.func_77973_b() == var4.func_77973_b() && var3.field_77994_a == 1 && var4.field_77994_a == 1 && var3.func_77973_b().isRepairable()) {
            Item var11 = var3.func_77973_b();
            int var10 = var11.func_77612_l() - var3.func_77952_i();
            int var7 = var11.func_77612_l() - var4.func_77952_i();
            int var8 = var10 + var7 + var11.func_77612_l() * 10 / 100;
            int var9 = var11.func_77612_l() - var8;
            if (var9 < 0) {
                var9 = 0;
            }
            return new ItemStack(var3.func_77973_b(), 1, var9);
        }
        for (var5 = 0; var5 < this.recipes.size(); ++var5) {
            ITCRecipe recipe = (ITCRecipe)this.recipes.get(var5);
            if (!recipe.matches(inv, world)) continue;
            return recipe.getCraftingResult(inv);
        }
        return null;
    }

    public List getRecipeList() {
        return this.recipes;
    }

    public List<ShapedTrainRecipes> getShapedRecipes() {
        return Collections.unmodifiableList(this.shapedRecipes);
    }

    public void addHearthFurnaceRecipe(ItemStack item1, ItemStack item2, ItemStack output, float xp, int cooktime) {
        if (this.getHearthFurnaceRecipe(item1, item2, true) != null) {
            return;
        }
        int id1 = Item.func_150891_b((Item)item1.func_77973_b());
        int id2 = Item.func_150891_b((Item)item2.func_77973_b());
        this.hearthFurnaceRecipes.add(new OpenHearthFurnaceRecipe(item1, item2, output, cooktime));
        int recipeID = this.hearthFurnaceRecipes.size() - 1;
        this.addIDtoHearthFurnaceMap(id1, recipeID);
        this.addIDtoHearthFurnaceMap(id2, recipeID);
        this.hearthFurnaceXpMap.put(Item.func_150891_b((Item)output.func_77973_b()), Float.valueOf(xp));
    }

    public void addIDtoHearthFurnaceMap(int itemID, int recipeID) {
        ArrayList<Integer> list = this.hearthFurnaceMap.remove(itemID);
        if (list == null) {
            list = new ArrayList();
        }
        list.add(recipeID);
        this.hearthFurnaceMap.put(itemID, list);
    }

    public OpenHearthFurnaceRecipe getHearthFurnaceRecipe(ItemStack item1, ItemStack item2, boolean onAdd) {
        if (item1 == null || item2 == null) {
            return null;
        }
        int id1 = Item.func_150891_b((Item)item1.func_77973_b());
        int id2 = Item.func_150891_b((Item)item2.func_77973_b());
        ArrayList<Integer> recipes = this.hearthFurnaceMap.get(id1);
        if (recipes == null) {
            return null;
        }
        for (int recipeID : recipes) {
            if (!this.hearthFurnaceRecipes.get(recipeID).matches(new ItemStack[]{item1, item2})) continue;
            return this.hearthFurnaceRecipes.get(recipeID);
        }
        if (!onAdd) {
            return null;
        }
        recipes = this.hearthFurnaceMap.get(id2);
        for (int recipeID : recipes) {
            if (!this.hearthFurnaceRecipes.get(recipeID).matches(new ItemStack[]{item1, item2})) continue;
            return this.hearthFurnaceRecipes.get(recipeID);
        }
        return null;
    }

    public int getHearthFurnaceRecipeDuration(ItemStack item1, ItemStack item2) {
        OpenHearthFurnaceRecipe recipe = this.getHearthFurnaceRecipe(item1, item2, false);
        if (recipe != null) {
            return recipe.getCooktime();
        }
        return 600;
    }

    public ItemStack getHearthFurnaceRecipeResult(ItemStack item1, ItemStack item2) {
        OpenHearthFurnaceRecipe recipe = this.getHearthFurnaceRecipe(item1, item2, false);
        if (recipe != null) {
            return recipe.getCraftingResult();
        }
        return null;
    }

    public float getHearthFurnaceRecipeExperience(ItemStack output) {
        Float out = this.hearthFurnaceXpMap.get(Item.func_150891_b((Item)output.func_77973_b()));
        if (out != null) {
            return out.floatValue();
        }
        return 0.0f;
    }

    public ArrayList<OpenHearthFurnaceRecipe> getHearthFurnaceRecipeList() {
        return this.hearthFurnaceRecipes;
    }
}

