/*
 * Decompiled with CFR 0.152.
 */
package train.common.recipes;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import train.common.core.handlers.ConfigHandler;
import train.common.library.BlockIDs;
import train.common.library.ItemIDs;

public class DistilRecipes {
    private static final DistilRecipes smeltingBase = new DistilRecipes();
    private Map<Item, ItemStack> smeltingList;
    private Map<Integer, Float> experienceList = new HashMap<Integer, Float>();
    private Map<Item, Float> plasticChanceList = new HashMap<Item, Float>();
    private Map<Item, ItemStack> plasticList = new HashMap<Item, ItemStack>();

    public static final DistilRecipes smelting() {
        return smeltingBase;
    }

    private DistilRecipes() {
        this.smeltingList = new HashMap<Item, ItemStack>();
        if (ConfigHandler.ORE_GEN) {
            this.addSmelting(Item.func_150898_a((Block)BlockIDs.oreTC.block), new ItemStack(ItemIDs.diesel.item, 2), 0.5f, 1.0f, new ItemStack(ItemIDs.rawPlastic.item, 1));
        }
        this.addSmelting(Items.field_151120_aE, new ItemStack(ItemIDs.diesel.item), 0.2f, 4.0f, new ItemStack(ItemIDs.rawPlastic.item, 1));
        this.addSmelting(Item.func_150898_a((Block)Blocks.field_150362_t), new ItemStack(ItemIDs.diesel.item), 0.2f, 6.0f, new ItemStack(ItemIDs.rawPlastic.item, 2));
        this.addSmelting(ItemIDs.diesel.item, new ItemStack(ItemIDs.refinedFuel.item), 1.0f, 2.0f, new ItemStack(ItemIDs.rawPlastic.item, 1));
        this.addSmelting(Items.field_151015_O, new ItemStack(ItemIDs.diesel.item), 0.2f, 4.0f, new ItemStack(ItemIDs.rawPlastic.item, 1));
    }

    public void addSmelting(Item itemID, ItemStack itemstack, float exp, float plasticChance, ItemStack plasticStack) {
        this.smeltingList.put(itemID, itemstack);
        this.plasticList.put(itemID, plasticStack);
        this.experienceList.put(Item.func_150891_b((Item)plasticStack.func_77973_b()), Float.valueOf(exp));
        this.plasticChanceList.put(itemID, Float.valueOf(plasticChance));
    }

    public float getExperience(int i) {
        return this.experienceList.containsKey(i) ? this.experienceList.get(i).floatValue() : 0.0f;
    }

    public int getPlasticChance(Item item) {
        if (this.plasticChanceList.containsKey(item)) {
            return (int)this.plasticChanceList.get(item).floatValue();
        }
        return 0;
    }

    public ItemStack getSmeltingResult(Item item) {
        return this.smeltingList.get(item);
    }

    public ItemStack getPlasticResult(Item item) {
        return this.plasticList.get(item);
    }

    public Map<Item, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }
}

