/*
 * Decompiled with CFR 0.152.
 */
package train.common.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import train.common.core.interfaces.ITier;
import train.common.core.managers.TierRecipe;
import train.common.core.managers.TierRecipeManager;

public class TileCrafterTierII
extends TileEntity
implements IInventory,
ITier {
    private Random rand;
    private ItemStack[] crafterInventory = new ItemStack[26];
    private ForgeDirection facing;
    private final int Tier = 2;
    private List<ItemStack> resultList;
    private static List<ItemStack> knownRecipes = new ArrayList<ItemStack>();
    private static int[] slotSelected;

    public TileCrafterTierII() {
        this.rand = new Random();
        this.resultList = new ArrayList<ItemStack>();
        slotSelected = new int[8];
    }

    public int func_70302_i_() {
        return this.crafterInventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.crafterInventory[i];
    }

    @Override
    public List<ItemStack> getResultList() {
        return this.resultList;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.crafterInventory[i] != null) {
            if (this.crafterInventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.crafterInventory[i];
                this.crafterInventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.crafterInventory[i].func_77979_a(j);
            if (this.crafterInventory[i].field_77994_a == 0) {
                this.crafterInventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.crafterInventory[par1] != null) {
            ItemStack var2 = this.crafterInventory[par1];
            this.crafterInventory[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.crafterInventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "TierII";
    }

    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.facing = ForgeDirection.getOrientation((int)nbtTag.func_74771_c("Orientation"));
        slotSelected = nbtTag.func_74759_k("Selected");
        NBTTagList nbttaglist = nbtTag.func_150295_c("Items", 10);
        this.crafterInventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.crafterInventory.length) continue;
            this.crafterInventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        NBTTagList nbttaglist2 = nbtTag.func_150295_c("Known", 10);
        for (int i = 0; i < nbttaglist2.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound2 = nbttaglist2.func_150305_b(i);
            byte byte1 = nbttagcompound2.func_74771_c("Recipe");
            if (byte1 < 0 || this.listContains(knownRecipes, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2))) continue;
            knownRecipes.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound2));
        }
    }

    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        if (this.facing != null) {
            nbtTag.func_74774_a("Orientation", (byte)this.facing.ordinal());
        } else {
            nbtTag.func_74774_a("Orientation", (byte)ForgeDirection.NORTH.ordinal());
        }
        nbtTag.func_74783_a("Selected", slotSelected);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.crafterInventory.length; ++i) {
            if (this.crafterInventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.crafterInventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbtTag.func_74782_a("Items", (NBTBase)nbttaglist);
        NBTTagList nbttaglist2 = new NBTTagList();
        if (knownRecipes != null) {
            for (int i = 0; i < knownRecipes.size(); ++i) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.func_74774_a("Recipe", (byte)i);
                knownRecipes.get(i).func_77955_b(nbttagcompound2);
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbtTag.func_74782_a("Known", (NBTBase)nbttaglist2);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.resultList.clear();
        for (int i = 10; i < this.crafterInventory.length - 8; ++i) {
            this.crafterInventory[i] = null;
        }
        List recipes = TierRecipeManager.getInstance().getTierRecipeList(2);
        int count = 0;
        for (int j = 0; j < recipes.size(); ++j) {
            ItemStack stack = ((TierRecipe)recipes.get(j)).hasComponents(this.crafterInventory);
            if (stack == null) continue;
            if (count + 10 < this.crafterInventory.length) {
                this.resultList.add(stack);
                this.crafterInventory[count + 10] = new ItemStack(stack.func_77973_b(), 1, 0);
            }
            ++count;
        }
        for (int i = 0; i < this.resultList.size(); ++i) {
            if (this.listContains(knownRecipes, this.resultList.get(i))) continue;
            knownRecipes.add(this.resultList.get(i));
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public ForgeDirection getFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        return ForgeDirection.NORTH;
    }

    public void setFacing(ForgeDirection face) {
        this.facing = face;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    private boolean listContains(List<ItemStack> list, ItemStack stack) {
        for (int i = 0; i < list.size(); ++i) {
            if (Item.func_150891_b((Item)list.get(i).func_77973_b()) != Item.func_150891_b((Item)stack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int Tier() {
        return 2;
    }

    @Override
    public List<ItemStack> knownRecipes() {
        return knownRecipes;
    }

    @Override
    public int[] getSlotSelected() {
        return slotSelected;
    }

    @Override
    public void setSlotSelected(int[] selected) {
        slotSelected = selected;
    }

    @Override
    public String getGUIName() {
        return "Steel age";
    }

    @Override
    public String getGUITexture() {
        return "textures/gui/gui_tierII_steelAge.png";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i > 17) {
            return true;
        }
        if (i > 9) {
            return false;
        }
        List recipeList = TierRecipeManager.getInstance().getTierRecipeList(this.Tier);
        for (TierRecipe recipe : recipeList) {
            ItemStack stack2 = recipe.getInput().get(i);
            if (stack2 == null || !TierRecipe.areItemsIdentical(stack, stack2)) continue;
            return true;
        }
        return false;
    }

    public void func_145845_h() {
    }
}

