/*
 * Decompiled with CFR 0.152.
 */
package train.common.tile;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import train.common.api.LiquidManager;
import train.common.core.util.Energy;

public class TileGeneratorDiesel
extends Energy
implements IFluidHandler {
    public boolean powered;
    private ForgeDirection direction;
    public FluidTank theTank;
    public int currentBurnTime;
    private int lastTankAmount;
    private int lastBurnTime;

    public TileGeneratorDiesel() {
        super(2, "Diesel Generator", 320, 80);
        super.setSides(new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.UP, ForgeDirection.DOWN});
        this.direction = ForgeDirection.getOrientation((int)this.field_145847_g);
        LiquidManager liquidManager = LiquidManager.getInstance();
        liquidManager.getClass();
        this.theTank = liquidManager.new LiquidManager.FilteredTank(30000, LiquidManager.dieselFilter(), 1);
    }

    public int getFacing() {
        return this.direction.ordinal();
    }

    public void setFacing(int facing) {
        this.direction = ForgeDirection.getOrientation((int)facing);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack result;
            if (this.slots[0] != null && (result = LiquidManager.getInstance().processContainer((IInventory)this, 0, this.theTank, this.slots[0])) != null && this.placeInInvent(result, 1, false)) {
                this.placeInInvent(result, 1, true);
                this.func_70296_d();
            }
            int energyProduced = 70;
            if (this.currentBurnTime > 0) {
                --this.currentBurnTime;
                this.energy.receiveEnergy(energyProduced, false);
            }
            if (this.powered && energyProduced <= this.energy.getMaxEnergyStored() - this.energy.getEnergyStored()) {
                int fuelUsed = 50;
                if (this.currentBurnTime <= 0 && this.theTank.getFluidAmount() >= fuelUsed) {
                    this.currentBurnTime = 8;
                    this.theTank.drain(fuelUsed, true);
                    this.func_70296_d();
                }
            }
            if (this.energy.getEnergyStored() > 0) {
                this.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.energy);
            }
        }
        if (this.theTank.getFluidAmount() != this.lastTankAmount || this.currentBurnTime != this.lastBurnTime) {
            this.lastTankAmount = this.theTank.getFluidAmount();
            this.lastBurnTime = this.currentBurnTime;
            this.syncTileEntity();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTag, boolean forSyncing) {
        super.readFromNBT(nbtTag, forSyncing);
        if (!forSyncing) {
            this.powered = nbtTag.func_74767_n("Powered");
        }
        this.direction = ForgeDirection.values()[nbtTag.func_74762_e("direction")];
        this.currentBurnTime = nbtTag.func_74762_e("BurnTime");
        this.theTank.readFromNBT(nbtTag);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag, boolean forSyncing) {
        super.writeToNBT(nbtTag, forSyncing);
        if (!forSyncing) {
            nbtTag.func_74757_a("Powered", this.powered);
        }
        nbtTag.func_74768_a("direction", this.direction.ordinal());
        nbtTag.func_74768_a("BurnTime", this.currentBurnTime);
        this.theTank.writeToNBT(nbtTag);
        return nbtTag;
    }

    public int getTankCapacity() {
        return this.theTank.getCapacity();
    }

    private boolean placeInInvent(ItemStack itemstack1, int i, boolean doAdd) {
        if (this.slots[i] == null) {
            if (doAdd) {
                this.slots[i] = itemstack1;
            }
            return true;
        }
        if (this.slots[i] != null && this.slots[i].func_77973_b() == itemstack1.func_77973_b() && itemstack1.func_77985_e() && (!itemstack1.func_77981_g() || this.slots[i].func_77960_j() == itemstack1.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.slots[i], (ItemStack)itemstack1)) {
            int var9 = this.slots[i].field_77994_a + itemstack1.field_77994_a;
            if (doAdd) {
                if (var9 <= itemstack1.func_77976_d()) {
                    this.slots[i].field_77994_a = var9;
                } else if (this.slots[i].field_77994_a < itemstack1.func_77976_d()) {
                    ++this.slots[i].field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.theTank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.theTank.getFluid())) {
            return null;
        }
        return this.theTank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.theTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.theTank.getInfo()};
    }
}

