/*
 * Decompiled with CFR 0.152.
 */
package train.common.tile;

import cofh.api.energy.IEnergyProvider;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import train.common.core.TrainModBlockUtil;
import train.common.core.handlers.WorldEvents;
import train.common.core.util.Energy;

public class TileWindMill
extends Energy
implements IEnergyProvider {
    private int facingMeta;
    private int updateTicks = 0;
    private static Random rand = new Random();
    public int windClient = 0;

    public TileWindMill() {
        super(0, "Wind Mill", 240, 80);
        super.setSides(new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.DOWN});
        this.facingMeta = this.field_145847_g;
    }

    public int getFacing() {
        return this.facingMeta;
    }

    public void setFacing(int facing) {
        this.facingMeta = facing;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, boolean synced) {
        super.readFromNBT(nbt, synced);
        this.facingMeta = nbt.func_74771_c("Orientation");
        this.windClient = nbt.func_74762_e("Wind");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt, boolean synced) {
        super.writeToNBT(nbt, synced);
        nbt.func_74774_a("Orientation", (byte)this.facingMeta);
        nbt.func_74768_a("Wind", this.windClient);
        return nbt;
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void func_145845_h() {
        super.func_145845_h();
        ++this.updateTicks;
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateTicks % 20 == 0 && !this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                if (block != null) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(TrainModBlockUtil.getItemStackFromBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e));
                    for (ItemStack s : stacks) {
                        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, s);
                        float f3 = 0.05f;
                        entityitem.field_70159_w = (float)rand.nextGaussian() * f3;
                        entityitem.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
                        entityitem.field_70179_y = (float)rand.nextGaussian() * f3;
                        this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                }
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            }
            if (this.updateTicks % 4 == 0) {
                this.energy.receiveEnergy(WorldEvents.windStrength + Math.round((float)this.field_145848_d * 0.25f) * 10, false);
                if (this.field_145850_b.func_72911_I()) {
                    this.energy.receiveEnergy(Math.round((float)this.energy.getEnergyStored() * 3.5f), false);
                } else if (this.field_145850_b.func_72896_J()) {
                    this.energy.receiveEnergy(Math.round((float)this.energy.getEnergyStored() * 2.2f), false);
                }
            }
            if (this.energy.getEnergyStored() > 0) {
                this.pushEnergy(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.energy);
            }
            this.func_70296_d();
            this.syncTileEntity();
        }
    }
}

