/*
 * Decompiled with CFR 0.152.
 */
package net.row.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.row.RoW;
import net.row.block.BlockGag;
import net.row.block.BlockTrackNormal;
import net.row.helpers.RotationHelper;
import net.row.registry.RoWBlocks;
import net.row.registry.RoWItems;
import net.row.tileentity.TileEntityTrackNormal;

public class BlockSwitchMotor
extends Block {
    public static int renderType;
    private IIcon renderIcon;

    public BlockSwitchMotor() {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149752_b(3.0f);
        this.func_149663_c("row.blockSwitchMotor");
        this.field_149768_d = "row:pointer_red";
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        float yaw = player.field_70177_z % 360.0f + (player.field_70177_z % 360.0f < 0.0f ? 360.0f : 0.0f);
        int direction = Math.round(yaw / 360.0f * 4.0f) & 3;
        int[] pos = RotationHelper.rotateXZByDir(-1, 0, direction);
        if (world.func_147439_a(x + pos[0], y, z + pos[1]).isReplaceable((IBlockAccess)world, x + pos[0], y, z + pos[1])) {
            world.func_72921_c(x, y, z, direction, 3);
            world.func_147465_d(x + pos[0], y, z + pos[1], RoWBlocks.gag, direction, 3);
        } else {
            world.func_147468_f(x, y, z);
        }
        int[] s = RotationHelper.rotateXZByDir(1, 2, direction);
        world.func_147464_a(x + s[0], y, z + s[1], (Block)this, 1);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K || !player.field_71075_bZ.field_75098_d) {
            // empty if block
        }
        return world.func_147468_f(x, y, z);
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        int[] pos = RotationHelper.rotateXZByDir(-1, 0, meta);
        world.func_147468_f(x, y, z);
        if (!world.field_72995_K) {
            this.func_149642_a(world, x, y, z, new ItemStack(RoWItems.itemSwitchmotor, 1, 0));
        }
        if (world.func_147439_a(x + pos[0], y, z + pos[1]) instanceof BlockGag) {
            world.func_147468_f(x + pos[0], y, z + pos[1]);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbour) {
        world.func_147464_a(x, y, z, (Block)this, 4);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        int[] pos = RotationHelper.rotateXZByDir(-1, 0, world.func_72805_g(x, y, z));
        if (!(world.func_147439_a(x + pos[0], y, z + pos[1]) instanceof BlockGag)) {
            world.func_147468_f(x, y, z);
        }
        if (world.field_72995_K || RoW.getTrackManager(world) == null) {
            return;
        }
        boolean power = world.func_72864_z(x, y, z) || world.func_94577_B(x, y, z) > 0;
        this.forceMotor(world, x, y, z, power ? 1 : 0);
    }

    public void forceMotor(World world, int x, int y, int z, int power) {
        int direction = world.func_72805_g(x, y, z);
        int[] s2r = RotationHelper.rotateXZByDir(-2, 2, direction);
        int[] s2l = RotationHelper.rotateXZByDir(2, 2, direction);
        int[] s1r = RotationHelper.rotateXZByDir(-1, 2, direction);
        int[] s1l = RotationHelper.rotateXZByDir(1, 2, direction);
        boolean active = power > 0;
        TileEntityTrackNormal track = null;
        if (world.func_147439_a(x + s1r[0], y, z + s1r[1]) instanceof BlockTrackNormal) {
            track = (TileEntityTrackNormal)world.func_147438_o(x + s1r[0], y, z + s1r[1]);
            if (track != null && track.isSwitchBySize() && track.isSwitch1()) {
                if (power > -1) {
                    track.activated = active;
                } else if (power == -1) {
                    track.activated = !track.activated;
                }
                world.func_147471_g(x + s1r[0], y, z + s1r[1]);
                world.func_147464_a(x + s1r[0], y, z + s1r[1], (Block)this, 1);
            }
        } else if (world.func_147439_a(x + s1l[0], y, z + s1l[1]) instanceof BlockTrackNormal) {
            track = (TileEntityTrackNormal)world.func_147438_o(x + s1l[0], y, z + s1l[1]);
            if (track != null && track.isSwitchBySize() && track.isSwitch1()) {
                if (power > -1) {
                    track.activated = active;
                } else if (power == -1) {
                    track.activated = !track.activated;
                }
                world.func_147471_g(x + s1l[0], y, z + s1l[1]);
                world.func_147464_a(x + s1l[0], y, z + s1l[1], (Block)this, 1);
            }
        } else if (world.func_147439_a(x + s2r[0], y, z + s2r[1]) instanceof BlockTrackNormal) {
            track = (TileEntityTrackNormal)world.func_147438_o(x + s2r[0], y, z + s2r[1]);
            if (track != null && track.isSwitchBySize() && track.isSwitch2()) {
                if (power > -1) {
                    track.activated = active;
                } else if (power == -1) {
                    track.activated = !track.activated;
                }
                world.func_147471_g(x + s2r[0], y, z + s2r[1]);
                world.func_147464_a(x + s2r[0], y, z + s2r[1], (Block)this, 1);
            }
        } else if (world.func_147439_a(x + s2l[0], y, z + s2l[1]) instanceof BlockTrackNormal && (track = (TileEntityTrackNormal)world.func_147438_o(x + s2l[0], y, z + s2l[1])) != null && track.isSwitchBySize() && track.isSwitch2()) {
            if (power > -1) {
                track.activated = active;
            } else if (power == -1) {
                track.activated = !track.activated;
            }
            world.func_147471_g(x + s2l[0], y, z + s2l[1]);
            world.func_147464_a(x + s2l[0], y, z + s2l[1], (Block)this, 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a(this.func_149641_N());
        this.renderIcon = register.func_94245_a("row:tracks_map");
    }

    public IIcon getRenderIcon() {
        return this.renderIcon;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return renderType;
    }
}

