/*
 * Decompiled with CFR 0.152.
 */
package net.row.helpers;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.Vertex;
import net.minecraftforge.client.model.obj.WavefrontObject;

public class RenderHelperRoW {
    private static float radius = 0.0f;
    private static float azimuth = 0.0f;
    private static float centre_u = 0.0f;
    private static float centre_v = 0.0f;
    private static final float mapping_factor = 0.98f;

    public static void renderRT(WavefrontObject model, float angle, float x, float y, float z, IIcon icon, Tessellator tessellator) {
        for (GroupObject group : model.groupObjects) {
            for (Face face : group.faces) {
                Vertex normal = face.faceNormal;
                tessellator.func_78375_b(normal.x, normal.y, normal.z);
                centre_v = 0.0f;
                centre_u = 0.0f;
                for (TextureCoordinate coordinate : face.textureCoordinates) {
                    centre_u += coordinate.u;
                    centre_v += coordinate.v;
                }
                centre_u /= (float)face.textureCoordinates.length;
                centre_v /= (float)face.textureCoordinates.length;
                for (int i = 0; i < face.vertices.length; ++i) {
                    Vertex vertex = face.vertices[i];
                    float xx = x + vertex.x;
                    float yy = y + vertex.y;
                    float zz = z + vertex.z;
                    radius = (float)Math.sqrt(xx * xx + zz * zz);
                    azimuth = (float)Math.atan2(zz, xx);
                    TextureCoordinate coordinate = face.textureCoordinates[i];
                    tessellator.func_78374_a((double)radius * Math.cos((double)azimuth + Math.toRadians(angle)), (double)yy, (double)radius * Math.sin((double)azimuth + Math.toRadians(angle)), (double)(icon == null ? 0.0f : icon.func_94214_a((double)((centre_u + (coordinate.u - centre_u) * 0.98f) * 16.0f))), (double)(icon == null ? 0.0f : icon.func_94207_b((double)((centre_v + (coordinate.v - centre_v) * 0.98f) * 16.0f))));
                }
            }
        }
    }
}

