/*
 * Decompiled with CFR 0.152.
 */
package net.row.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.row.RoW;
import net.row.entity.EntityTrackPreview;
import net.row.helpers.RotationHelper;
import net.row.helpers.UtilSync;
import net.row.registry.RoWBlocks;
import net.row.registry.RoWConfig;
import net.row.tileentity.TileEntityTrackNormal;

public class ItemTrack
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] ico;
    public static final byte[] arranger = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 13, 15, 17, 19, 27, 29, 31, 21, 23, 25, 33};
    public static final String[] names = new String[]{"s1", "s16", "c", "de", "d1", "d16", "g12", "g25", "g50", "r30r", "r30l", "r60r", "r60l", "r90r", "r90l", "rsw30r", "rsw30l", "rsw60r", "rsw60l", "rsw90r", "rsw90l", "p1r", "p1l", "p2r", "p2l", "p3r", "p3l", "psw1r", "psw1l", "psw2r", "psw2l", "psw3r", "psw3l", "gc"};
    public static final byte[][] shifts = new byte[][]{{1, 0}, {1, 0}, {1, -1}, {1, 0}, {1, -1}, {1, -1}, {1, 0}, {1, 0}, {1, 0}, {1, 0}, {9, 0}, {1, 0}, {18, 0}, {1, 0}, {26, 0}, {1, 0}, {9, 0}, {1, 0}, {18, 0}, {1, 0}, {26, 0}, {1, 0}, {2, 0}, {1, 0}, {3, 0}, {1, 0}, {4, 0}, {1, 0}, {3, 0}, {1, 0}, {3, 0}, {1, 0}, {4, 0}, {1, 0}};

    public ItemTrack() {
        this.func_77627_a(true);
        this.func_77655_b("row.rails");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        int j = MathHelper.func_76125_a((int)par1, (int)0, (int)(names.length - 1));
        return this.ico[j];
    }

    public String func_77667_c(ItemStack stack) {
        int i = stack.func_77960_j();
        if (i >= 9 && i <= 32) {
            return "item.row.rails." + names[i].substring(0, names[i].length() - 1);
        }
        return "item.row.rails." + (i < names.length ? names[i] : names[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < arranger.length; ++j) {
            par3List.add(new ItemStack(par1, 1, (int)arranger[j]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.ico = new IIcon[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.ico[i] = i >= 9 && i <= 32 ? par1IconRegister.func_94245_a("row:rails/r_" + names[i].substring(0, names[i].length() - 1)) : par1IconRegister.func_94245_a("row:rails/r_" + names[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"row.tooltip.track.1"));
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"row.tooltip.track.2"));
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"row.tooltip.track.3"));
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffSet) {
        int dir;
        float angle;
        Block b0;
        int mId;
        if (!world.field_72995_K && (!player.func_70093_af() && RoWConfig.invertTrackOrder || player.func_70093_af() && !RoWConfig.invertTrackOrder)) {
            mId = item.func_77960_j();
            if (mId < 0 || mId > names.length - 1) {
                return false;
            }
            b0 = world.func_147439_a(x, y, z);
            if (!ItemTrack.canReplaceBlock(b0, false)) {
                if (side == 1) {
                    ++y;
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("row.msg.track.no_place", new Object[0]));
                    return false;
                }
            }
            angle = MathHelper.func_76142_g((float)(player.field_70177_z - (mId == 4 || mId == 5 ? 45.0f : 0.0f)));
            dir = MathHelper.func_76128_c((double)((double)(angle * 4.0f / 360.0f) + 0.5)) & 3;
            if (mId >= 9 && mId <= 32 && (mId & 1) == 1 && MathHelper.func_76142_g((float)(angle - (float)(dir * 90))) < 0.0f) {
                ++mId;
            }
            boolean canPlace = true;
            try {
                if (RoW.class.getResourceAsStream("/assets/row/textures/gag_maps_new/r_" + names[mId] + ".png") == null) {
                    return false;
                }
                BufferedImage img = ImageIO.read(RoW.class.getResourceAsStream("/assets/row/textures/gag_maps_new/r_" + names[mId] + ".png"));
                if (img != null) {
                    int[] shift;
                    int h2;
                    for (int w = 0; w > -img.getWidth(); --w) {
                        for (int h = 0; h < img.getHeight(); ++h) {
                            h2 = img.getHeight() - h - 1;
                            if (img.getRGB(-w, h2) != -16777216 || ((b0 = world.func_147439_a(x + (shift = RotationHelper.rotateXZByDir(w + shifts[mId][0], h + shifts[mId][1], dir))[0], y, z + shift[1])) == Blocks.field_150395_bd || b0 == Blocks.field_150329_H || b0 == Blocks.field_150330_I || b0 == Blocks.field_150434_aF || b0 == Blocks.field_150327_N || b0 == Blocks.field_150328_O || b0 == Blocks.field_150345_g || b0 == Blocks.field_150338_P || b0 == Blocks.field_150337_Q || b0 == Blocks.field_150398_cm || world.func_147437_c(x + shift[0], y, z + shift[1]) || b0.isReplaceable((IBlockAccess)world, x + shift[0], y, z + shift[1])) && world.isSideSolid(x + shift[0], y - 1, z + shift[1], ForgeDirection.UP)) continue;
                            canPlace = false;
                        }
                    }
                    if (canPlace) {
                        world.func_147465_d(x, y, z, RoWBlocks.trackNormal, dir, 3);
                        TileEntityTrackNormal tileEntity = (TileEntityTrackNormal)world.func_147438_o(x, y, z);
                        tileEntity.type = mId;
                        for (int w = 0; w > -img.getWidth(); --w) {
                            for (int h = 0; h < img.getHeight(); ++h) {
                                h2 = img.getHeight() - h - 1;
                                if (-w == shifts[mId][0] && -h == shifts[mId][1] || img.getRGB(-w, h2) != -16777216) continue;
                                shift = RotationHelper.rotateXZByDir(w + shifts[mId][0], h + shifts[mId][1], dir);
                                world.func_147465_d(x + shift[0], y, z + shift[1], RoWBlocks.trackGag, 0, 3);
                                RoW.getTrackManager(world).addTrack(world, new int[]{x, y, z}, new int[]{x + shift[0], y, z + shift[1]});
                            }
                        }
                        RoW.getTrackManager(world).func_76185_a();
                        world.func_72956_a((Entity)player, "random.anvil_land", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                        if (!player.field_71075_bZ.field_75098_d && canPlace) {
                            --item.field_77994_a;
                        }
                        return true;
                    }
                    if (!RoWConfig.disableTrackError) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("row.msg.track.no_place", new Object[0]));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!world.field_72995_K && (!player.func_70093_af() && !RoWConfig.invertTrackOrder || player.func_70093_af() && RoWConfig.invertTrackOrder)) {
            mId = item.func_77960_j();
            if (mId < 0 || mId > names.length - 1) {
                return false;
            }
            b0 = world.func_147439_a(x, y, z);
            if (!ItemTrack.canReplaceBlock(b0, true)) {
                if (side == 1) {
                    ++y;
                } else {
                    return false;
                }
            }
            angle = MathHelper.func_76142_g((float)(player.field_70177_z - (mId == 4 || mId == 5 ? 45.0f : 0.0f)));
            dir = MathHelper.func_76128_c((double)((double)(angle * 4.0f / 360.0f) + 0.5)) & 3;
            if (mId >= 9 && mId <= 32 && (mId & 1) == 1 && MathHelper.func_76142_g((float)(angle - (float)(dir * 90))) < 0.0f) {
                ++mId;
            }
            EntityTrackPreview preview = new EntityTrackPreview(world);
            preview.func_70012_b((double)x + 0.5, y, (double)z + 0.5, player.field_70177_z, 0.0f);
            world.func_72838_d((Entity)preview);
            preview.trackId = mId;
            UtilSync.sync(preview);
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            return true;
        }
        return false;
    }

    public static boolean canReplaceBlock(Block b, boolean flag) {
        return b == Blocks.field_150395_bd || b == Blocks.field_150329_H || b == Blocks.field_150330_I || b == Blocks.field_150434_aF || b == Blocks.field_150327_N || b == Blocks.field_150328_O || b == Blocks.field_150345_g || b == Blocks.field_150338_P || b == Blocks.field_150337_Q || b == Blocks.field_150398_cm || flag && (b == RoWBlocks.trackGag || b == RoWBlocks.trackNormal);
    }
}

