/*
 * Decompiled with CFR 0.152.
 */
package net.row.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.row.RoW;
import net.row.stock.core.RoWLocomotive;
import net.row.stock.core.plugin.IRSRegulatorA;
import net.row.stock.core.plugin.IRSRegulatorD5;
import net.row.stock.core.plugin.IRSReverseD3;

public class PacketRegulator
implements IMessage {
    private int id;
    private byte regulatorCode;

    public PacketRegulator() {
    }

    public PacketRegulator(int id, byte regulatorCode) {
        this.id = id;
        this.regulatorCode = regulatorCode;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeByte((int)this.regulatorCode);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.regulatorCode = buf.readByte();
    }

    public static class Handler
    implements IMessageHandler<PacketRegulator, IMessage> {
        public IMessage onMessage(PacketRegulator message, MessageContext ctx) {
            Entity entity = ctx.side.isServer() ? ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.id) : Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
            if (entity != null) {
                RoWLocomotive loco = (RoWLocomotive)entity;
                if (loco instanceof IRSRegulatorD5) {
                    IRSRegulatorD5 lcrP5 = (IRSRegulatorD5)((Object)loco);
                    if (!(loco instanceof IRSReverseD3) || ((IRSReverseD3)((Object)loco)).getReverse() != IRSReverseD3.EnumReserveP3.NEUTRAL) {
                        if (message.regulatorCode == 1) {
                            if (lcrP5.getRegulator().canGoUp()) {
                                entity.field_70170_p.func_72956_a(entity, "row:regulator_positional_click", 1.0f, 1.0f);
                            }
                            lcrP5.setRegulator(lcrP5.getRegulator().goUp());
                        } else if (message.regulatorCode == -1) {
                            if (lcrP5.getRegulator().canGoDown()) {
                                entity.field_70170_p.func_72956_a(entity, "row:regulator_positional_click", 1.0f, 1.0f);
                            }
                            lcrP5.setRegulator(lcrP5.getRegulator().goDown());
                        } else if (message.regulatorCode == 0) {
                            // empty if block
                        }
                    } else {
                        entity.field_70170_p.func_72956_a(entity, "row:locked_control", 1.0f, 1.0f);
                    }
                }
                if (loco instanceof IRSRegulatorA) {
                    IRSRegulatorA lcrA = (IRSRegulatorA)((Object)loco);
                    if (message.regulatorCode == 1) {
                        lcrA.regulatorGoUp(1);
                    } else if (message.regulatorCode == -1) {
                        lcrA.regulatorGoDown(1);
                    } else if (message.regulatorCode == 0) {
                        lcrA.setIsRegulatorZeroed(true);
                    }
                }
            }
            if (ctx.side.isServer()) {
                RoW.network.sendToAll((IMessage)message);
            }
            return null;
        }
    }
}

