/*
 * Decompiled with CFR 0.152.
 */
package net.row.renderer.stock;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.row.models.carts.russian.ntv.NTVBeds;
import net.row.models.carts.russian.ntv.NTVBody;
import net.row.models.carts.russian.ntv.NTVDoor;
import net.row.models.carts.russian.ntv.NTVDoorLock;
import net.row.models.carts.russian.ntv.NTVFrame;
import net.row.models.carts.russian.ntv.NTVSuspension;
import net.row.models.carts.russian.ntv.NTVWheelset;
import net.row.models.coupler.PrimaryCoupler;
import net.row.registry.RoWConfig;
import net.row.renderer.stock.RoWRenderRollingStock;
import net.row.renderer.tileentity.RendererCrate;
import net.row.renderer.util.RenderUtils;
import net.row.stock.cart.CartNTV;
import net.row.stock.core.RoWRollingStock;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderCartNTV
extends RoWRenderRollingStock {
    private static final RendererCrate crateRender = new RendererCrate();
    protected final ModelBase box = new NTVBody();
    protected final ModelBase beds = new NTVBeds();
    protected final ModelBase door = new NTVDoor();
    protected final ModelBase lock = new NTVDoorLock();
    protected final ModelBase frame = new NTVFrame();
    protected final ModelBase coupler = new PrimaryCoupler();
    protected final ModelBase wheelset = new NTVWheelset();
    protected final ModelBase suspension = new NTVSuspension();
    protected final ResourceLocation frameTexture = new ResourceLocation("row:textures/stock/cart/ntv/ntv_frame.png");
    protected final ResourceLocation bodyTexture = new ResourceLocation("row:textures/stock/cart/ntv/ntv_body.png");
    protected final ResourceLocation suspensionTexture = new ResourceLocation("row:textures/stock/cart/ntv/ntv_suspension.png");
    protected final ResourceLocation wheelTexture = new ResourceLocation("row:textures/stock/cart/ntv/ntv_wheelset.png");
    protected final RenderBlocks renderBlocks;
    protected CartNTV cart;
    private float stage;
    private float lockS;
    private float doorS;
    private float lockDiv = 0.3f;
    private float doorDiv = 0.2f;

    public RenderCartNTV() {
        this.field_76989_e = 1.5f;
        this.renderBlocks = new RenderBlocks();
    }

    @Override
    public void render(RoWRollingStock stock, float dx, float dy, float dz, float yaw, float pitch, float partialTick) {
        this.cart = (CartNTV)stock;
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        GL11.glTranslatef((float)0.0f, (float)0.0625f, (float)0.0f);
        GL11.glRotatef((float)(-yaw + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_110776_a(this.frameTexture);
        this.frame.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        this.func_110776_a(this.bodyTexture);
        this.box.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if ((this.cart.modified & 1) == 1) {
            this.beds.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        this.stage = this.cart.RSDoor.getStageRelative(partialTick);
        this.lockS = this.stage > this.lockDiv ? 1.0f : this.stage / this.lockDiv;
        this.doorS = this.stage < this.doorDiv ? 0.0f : (this.stage - this.doorDiv) / (1.0f - this.doorDiv);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(1.875f * this.doorS), (float)0.0f, (float)0.0f);
        this.door.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.75f, (float)2.0625f, (float)1.625f);
        GL11.glRotatef((float)(this.lockS * -267.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.lock.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(1.875f * this.cart.RSDoor.getStageRelative(partialTick)), (float)0.0f, (float)0.0f);
        this.door.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.75f, (float)2.0625f, (float)1.625f);
        GL11.glRotatef((float)(this.lockS * -267.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.lock.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.875f, (float)0.0f, (float)0.0f);
        this.func_110776_a(this.suspensionTexture);
        this.suspension.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glTranslatef((float)3.75f, (float)0.0f, (float)0.0f);
        this.suspension.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)1.875f, (float)0.375f, (float)0.0f);
        GL11.glRotatef((float)(-this.cart.wheelAngle[0]), (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_110776_a(this.wheelTexture);
        this.wheelset.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.875f, (float)0.375f, (float)0.0f);
        GL11.glRotatef((float)(-this.cart.wheelAngle[0]), (float)0.0f, (float)0.0f, (float)1.0f);
        this.wheelset.func_78088_a((Entity)stock, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.375f, (float)0.0f);
        RenderUtils.renderCouplings(this, this.cart);
        GL11.glPopMatrix();
        if (!this.cart.RSDoor.isFullyClosed() || !RoWConfig.hideFreight) {
            this.renderLoad();
        }
        GL11.glPopMatrix();
    }

    void renderLoad() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)1.125f, (float)0.0f);
        float scale = 0.66f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        for (int m = 0; m < 2; m = (int)((byte)(m + 1))) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-3.843475f, (float)0.5f, (float)1.5f);
            for (int z = 0; z < 4; z = (int)((byte)(z + 1))) {
                GL11.glPushMatrix();
                for (int y = 0; y < 3; y = (int)((byte)(y + 1))) {
                    GL11.glPushMatrix();
                    for (int x = 0; x < 4; x = (int)((byte)(x + 1))) {
                        byte slotId = (byte)(m * 48 + z * 12 + y * 4 + x);
                        if (this.cart.func_70301_a(slotId) != null) {
                            Block block;
                            boolean drawCrate = true;
                            if (this.cart.func_70301_a(slotId).func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)this.cart.func_70301_a((int)slotId).func_77973_b()).field_150939_a).func_149645_b() == 0 && block.func_149701_w() == 0) {
                                GL11.glPushMatrix();
                                this.func_110776_a(TextureMap.field_110575_b);
                                this.renderBlocks.func_147800_a(block, this.cart.func_70301_a(slotId).func_77960_j(), this.cart.func_70013_c(0.0f));
                                GL11.glPopMatrix();
                                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                drawCrate = false;
                            }
                            if (drawCrate) {
                                this.func_110776_a(crateRender.getTexture());
                                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                                crateRender.renderBlock(1);
                            }
                        }
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    GL11.glPopMatrix();
                    GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                }
                GL11.glPopMatrix();
                GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glPopMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }
}

