/*
 * Decompiled with CFR 0.152.
 */
package net.row.renderer.stock;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.row.helpers.LabelHelper;
import net.row.renderer.stock.RoWRenderRollingStock;
import net.row.renderer.util.RenderUtils;
import net.row.stock.UtilStock;
import net.row.stock.core.RoWRollingStock;
import net.row.stock.loco.LocoSSW;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderLocoSSW
extends RoWRenderRollingStock {
    private final WavefrontObject body = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_body.obj"));
    private final WavefrontObject door_left = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_door_left.obj"));
    private final WavefrontObject door_right = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_door_right.obj"));
    private final WavefrontObject wheelset = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_wheelset.obj"));
    private final WavefrontObject reverser = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_reverser.obj"));
    private final WavefrontObject regulator = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_regulator.obj"));
    private final WavefrontObject brake_loco = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_brake_loco.obj"));
    private final WavefrontObject brake_train = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_brake_train.obj"));
    private final WavefrontObject button_horn = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_button_horn.obj"));
    private final WavefrontObject indicator = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_indicator.obj"));
    private final WavefrontObject gauge = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_gauge.obj"));
    private final WavefrontObject arrow_red = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_arrow_red.obj"));
    private final WavefrontObject arrow_black = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/loco/ssw/ssw_arrow_black.obj"));
    private final WavefrontObject lightBufferGlow = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/spares/LightBufferGlow.obj"));
    private final WavefrontObject lightHeadGlow = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/spares/LightHeadGlow.obj"));
    private final ResourceLocation frameTexture = new ResourceLocation("row:textures/stock/loco/ssw/ssw_frame.png");
    private final ResourceLocation wheelTexture = new ResourceLocation("row:textures/stock/loco/ssw/ssw_wheelset.png");
    private final ResourceLocation lightTexture = new ResourceLocation("row:textures/stock/spares/lights.png");
    private LocoSSW locoSSW;

    public RenderLocoSSW() {
        this.field_76989_e = 1.5f;
    }

    @Override
    public void render(RoWRollingStock stock, float dx, float dy, float dz, float yaw, float pitch, float tick) {
        this.locoSSW = (LocoSSW)stock;
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        GL11.glTranslatef((float)0.0f, (float)1.125f, (float)0.0f);
        GL11.glRotatef((float)(-yaw - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)1.5f, (float)0.0f, (float)0.0f);
        LabelHelper.drawStockLabel(this.locoSSW.label, 0.875f, 1.5f);
        GL11.glTranslatef((float)-1.5f, (float)0.0f, (float)0.0f);
        this.func_110776_a(this.frameTexture);
        this.body.renderAll();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.75f, (float)0.0f, (float)-1.34375f);
        GL11.glRotatef((float)(-93.0f * this.locoSSW.RSDoor.getStageRelative(tick)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.door_left.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.75f, (float)0.0f, (float)1.34375f);
        GL11.glRotatef((float)(93.0f * this.locoSSW.RSDoor.getStageRelative(tick)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.door_right.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.625f, (float)0.0f, (float)0.1875f);
        GL11.glRotatef((float)(20.0f * ((float)this.locoSSW.getReverse().ordinal() - 1.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        this.reverser.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.625f, (float)0.0f, (float)-0.1875f);
        GL11.glRotatef((float)(20.0f * (float)this.locoSSW.getRegulator().ordinal()), (float)0.0f, (float)1.0f, (float)0.0f);
        this.regulator.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.40625f, (float)0.0f, (float)1.25f);
        this.brake_loco.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.71875f, (float)0.0f, (float)1.1875f);
        GL11.glRotatef((float)(90.0f * (float)this.locoSSW.brakeStage / (float)this.locoSSW.brakeStageMax), (float)0.0f, (float)1.0f, (float)0.0f);
        this.brake_train.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-0.0375f * (this.locoSSW.hornStage > 15 ? 1.0f : 0.0f)), (float)0.0f);
        this.button_horn.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.8321875f, (float)(1.75f + 0.1375f * (-0.5f + (float)this.locoSSW.fuel / (float)this.locoSSW.fuelCap)), (float)0.1484375f);
        this.indicator.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.8321875f, (float)1.68125f, (float)-0.0078125f);
        this.indicator.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.875f, (float)2.09375f, (float)-0.125f);
        this.gauge.renderAll();
        GL11.glTranslatef((float)0.0f, (float)0.0625f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)(100.0f * (Math.min(UtilStock.mpti2kmph(Math.abs((float)this.locoSSW.projectedSpeed)), 25.0f) / 25.0f - 0.5f)), (float)1.0f, (float)0.0f, (float)0.0f);
        this.arrow_red.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glRotatef((float)-50.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.arrow_black.renderAll();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.875f, (float)2.09375f, (float)0.096875f);
        this.gauge.renderAll();
        GL11.glTranslatef((float)0.0f, (float)0.0625f, (float)0.0f);
        GL11.glRotatef((float)(100.0f * (this.locoSSW.getPressure() / this.locoSSW.getPressureCap() - 0.5f)), (float)1.0f, (float)0.0f, (float)0.0f);
        this.arrow_red.renderAll();
        GL11.glPopMatrix();
        float wa = this.locoSSW.wheelAngle[0];
        this.func_110776_a(this.wheelTexture);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)1.375f, (float)-0.6875f, (float)0.0f);
        GL11.glRotatef((float)wa, (float)0.0f, (float)0.0f, (float)1.0f);
        this.wheelset.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.375f, (float)-0.6875f, (float)0.0f);
        GL11.glRotatef((float)wa, (float)0.0f, (float)0.0f, (float)1.0f);
        this.wheelset.renderAll();
        GL11.glPopMatrix();
        if (this.locoSSW.isLightOn) {
            this.func_110776_a(this.lightTexture);
            Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-2.8125f, (float)0.5f, (float)0.875f);
            this.lightBufferGlow.renderAll();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.75f);
            this.lightBufferGlow.renderAll();
            GL11.glTranslatef((float)1.875f, (float)1.8125f, (float)0.875f);
            this.lightHeadGlow.renderAll();
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-2.8125f, (float)0.5f, (float)0.875f);
            this.lightBufferGlow.renderAll();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.75f);
            this.lightBufferGlow.renderAll();
            GL11.glTranslatef((float)1.875f, (float)1.8125f, (float)0.875f);
            this.lightHeadGlow.renderAll();
            GL11.glPopMatrix();
            Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
        }
        GL11.glTranslatef((float)0.0f, (float)-0.6875f, (float)0.0f);
        RenderUtils.renderCouplings(this, this.locoSSW);
        GL11.glPopMatrix();
    }
}

