/*
 * Decompiled with CFR 0.152.
 */
package net.row.renderer.stock;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.row.helpers.LabelHelper;
import net.row.renderer.stock.RoWRenderRollingStock;
import net.row.renderer.util.RenderUtils;
import net.row.stock.core.RoWRollingStock;
import net.row.stock.tender.TenderOv;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderTenderOv
extends RoWRenderRollingStock {
    private final WavefrontObject body = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/tender/ov/tender_ov_body.obj"));
    private final WavefrontObject wheelset = (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/tender/ov/tender_ov_wheelset.obj"));
    private final List<WavefrontObject> coal = new ArrayList<WavefrontObject>();
    private final ResourceLocation frameTexture = new ResourceLocation("row:textures/stock/tender/ov/tender_ov_frame.png");
    private final ResourceLocation wheelTexture = new ResourceLocation("row:textures/stock/tender/ov/tender_ov_wheelset.png");
    private final ResourceLocation coalTexture = new ResourceLocation("row:textures/stock/tender/ov/tender_ov_coal.png");
    private TenderOv tender;

    public RenderTenderOv() {
        this.field_76989_e = 1.5f;
        for (int i = 1; i <= 7; i = (int)((byte)(i + 1))) {
            this.coal.add((WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("row:models/stock/tender/ov/tender_ov_coal_" + i + ".obj")));
        }
    }

    @Override
    public void render(RoWRollingStock stock, float dx, float dy, float dz, float yaw, float pitch, float tick) {
        this.tender = (TenderOv)stock;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)(-yaw + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        LabelHelper.drawStockLabel(this.tender.label, 1.375f, 1.5625f);
        this.func_110776_a(this.frameTexture);
        this.body.renderAll();
        if (this.tender.fuel > 0 && this.tender.fuel <= this.tender.fuelCap) {
            this.func_110776_a(this.coalTexture);
            this.coal.get((int)(Math.ceil((float)(this.coal.size() * this.tender.fuel) / (float)this.tender.fuelCap) - 1.0)).renderAll();
        }
        this.func_110776_a(this.wheelTexture);
        GL11.glTranslatef((float)0.0f, (float)-0.0625f, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.125f, (float)-0.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.tender.wheelAngle[0]), (float)0.0f, (float)0.0f, (float)1.0f);
        this.wheelset.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)1.6875f, (float)-0.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.tender.wheelAngle[0]), (float)0.0f, (float)0.0f, (float)1.0f);
        this.wheelset.renderAll();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-1.625f, (float)-0.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.tender.wheelAngle[0]), (float)0.0f, (float)0.0f, (float)1.0f);
        this.wheelset.renderAll();
        GL11.glPopMatrix();
        RenderUtils.renderCouplings(this, this.tender);
        GL11.glPopMatrix();
    }
}

