/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.cart;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.row.RoW;
import net.row.entity.EntityCartRider;
import net.row.helpers.RotativePoint;
import net.row.item.ItemKey;
import net.row.registry.RoWConfig;
import net.row.registry.RoWItems;
import net.row.stock.core.RoWRollingStock;
import net.row.stock.core.object.RSDoor;

public class CartNTV
extends RoWRollingStock
implements IInventory {
    private ItemStack[] items;
    public RSDoor RSDoor;
    public byte doorTime;

    public CartNTV(World par1World) {
        super(par1World);
        this.func_70105_a(2.875f, 3.75f);
        this.workingMass = this.bareMass = 6.961f;
        this.riderPos = new RotativePoint(this, 0.875f, 1.75f, 0.0f);
        this.frontCouplerShift = 3.9375f;
        this.rearCouplerShift = 3.9375f;
        this.walkableMinX = -1.0f;
        this.walkableMaxX = 1.0f;
        this.walkableMinZ = -0.5625f;
        this.walkableMaxZ = 0.5625f;
        this.wheelRadius = new float[]{0.5f};
        this.wheelAngle = new float[]{0.0f};
        this.axleShifts = new float[]{3.75f};
        this.items = new ItemStack[96];
        this.doorTime = (byte)30;
        this.RSDoor = new RSDoor(this.doorTime);
        this.couplerFrontType = RoWRollingStock.CouplerType.BnC_RUSS;
        this.couplerRearType = RoWRollingStock.CouplerType.BnC_RUSS;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == null) continue;
            while (itemstack.field_77994_a > 0) {
                int amount = this.field_70146_Z.nextInt(21) + 10;
                if (amount > itemstack.field_77994_a) {
                    amount = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= amount;
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * 0.8f) + (double)0.1f, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 0.8f) + (double)0.1f, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * 0.8f) + (double)0.1f, new ItemStack(itemstack.func_77973_b(), amount, itemstack.func_77960_j()));
                float motion = 0.05f;
                entityitem.field_70159_w = this.field_70146_Z.nextGaussian() * (double)motion;
                entityitem.field_70181_x = this.field_70146_Z.nextGaussian() * (double)motion + (double)0.2f;
                entityitem.field_70179_y = this.field_70146_Z.nextGaussian() * (double)motion;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    @Override
    public boolean func_130002_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack = player.func_71045_bC();
            if (stack != null) {
                if (stack.func_77973_b() instanceof ItemKey && stack.field_77994_a > 0 && this.RSDoor.tryTrigger()) {
                    return this.sendUpdateToClient();
                }
                if (stack.func_77973_b().equals(RoWItems.itemFreightWand) && this.modified == 0 && player.field_71075_bZ.field_75098_d) {
                    for (int i = 0; i < this.func_70302_i_(); ++i) {
                        this.func_70299_a(i, new ItemStack(Blocks.field_150347_e, 64));
                    }
                    this.func_70305_f();
                    return this.sendUpdateToClient();
                }
            }
            if (player.field_70154_o != null && player.field_70154_o == this.seat && this.modified == 0) {
                player.openGui((Object)RoW.instance, this.func_145782_y(), player.field_70170_p, 0, 0, 0);
                return true;
            }
            if (player.field_70154_o != this.seat && this.RSDoor.isFullyOpened() && this.modified == 0 && player.func_70093_af()) {
                player.openGui((Object)RoW.instance, this.func_145782_y(), player.field_70170_p, 0, 0, 0);
                return true;
            }
        }
        return super.func_130002_c(player);
    }

    @Override
    public boolean interactMount(EntityPlayer player) {
        if (this.canBeRidden() && player.field_70154_o == null && !player.func_70093_af() && this.RSDoor.isFullyOpened()) {
            this.seat = new EntityCartRider(this);
            this.field_70170_p.func_72838_d((Entity)this.seat);
            player.func_70078_a((Entity)this.seat);
            return true;
        }
        return false;
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        this.RSDoor.onUpdate();
    }

    @Override
    public void handleMass() {
    }

    @Override
    public void updateWalkableArea() {
        if (this.items == null) {
            return;
        }
        this.walkableMaxZ = 2.625f;
        this.walkableMinZ = -2.625f;
        for (int m = 0; m < 2; m = (int)((byte)(m + 1))) {
            for (int z = 0; z < 4; z = (int)((byte)(z + 1))) {
                for (int y = 0; y < 3; y = (int)((byte)(y + 1))) {
                    for (int x = 0; x < 4; x = (int)((byte)(x + 1))) {
                        int id = m * 48 + z * 12 + y * 4 + x;
                        if (this.func_70301_a(id) == null || this.func_70301_a(id).func_77973_b() == null || this.func_70301_a((int)id).field_77994_a <= 0) continue;
                        if (m == 0) {
                            this.walkableMaxZ = Math.min(this.walkableMaxZ, (42.0f - (float)(z + 1) * 11.0f) / 16.0f);
                            continue;
                        }
                        this.walkableMinZ = Math.max(this.walkableMinZ, (-42.0f + (float)(z + 1) * 11.0f) / 16.0f);
                    }
                }
            }
        }
    }

    @Override
    public ItemStack getDrops() {
        return new ItemStack(RoWItems.itemStock, 1, 13 + this.modified);
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int id) {
        if (id < 0 || id >= this.func_70302_i_()) {
            return null;
        }
        return this.items[id];
    }

    public ItemStack func_70298_a(int id, int amount) {
        if (this.func_70301_a(id) != null) {
            if (this.func_70301_a((int)id).field_77994_a <= amount) {
                ItemStack itemstack = this.func_70301_a(id);
                this.func_70299_a(id, null);
                return itemstack;
            }
            ItemStack itemstack = this.func_70301_a(id).func_77979_a(amount);
            if (this.func_70301_a((int)id).field_77994_a <= 0) {
                this.func_70299_a(id, null);
            } else {
                this.func_70299_a(id, this.func_70301_a(id));
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int id) {
        ItemStack stack = this.func_70301_a(id);
        this.func_70299_a(id, null);
        return stack;
    }

    public void func_70299_a(int id, ItemStack stack) {
        if (id < 0 || id >= this.func_70302_i_()) {
            return;
        }
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (stack != null && stack.field_77994_a == 0) {
            stack = null;
        }
        this.items[id] = stack;
    }

    public String func_145825_b() {
        return "NTV";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.applyInventoryGravity();
        this.sendUpdateToClient();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.field_70128_L && player.func_70032_d((Entity)this) <= 8.0f;
    }

    public void func_70295_k_() {
        this.applyInventoryGravity();
    }

    public void func_70305_f() {
        this.workingMass = this.bareMass;
        for (ItemStack item : this.items) {
            this.workingMass += item != null ? 0.171f * (float)item.field_77994_a / (float)this.func_70297_j_() : 0.0f;
        }
    }

    public boolean func_94041_b(int id, ItemStack stack) {
        return true;
    }

    private void applyInventoryGravity() {
        if (this.items != null && RoWConfig.applyInventoryGravity) {
            for (int m = 0; m < 2; m = (int)((byte)(m + 1))) {
                for (int z = 0; z < 4; z = (int)((byte)(z + 1))) {
                    for (int x = 0; x < 4; x = (int)((byte)(x + 1))) {
                        for (int y = 1; y < 3; y = (int)((byte)(y + 1))) {
                            int id = m * 48 + z * 12 + y * 4 + x;
                            int bottomId = m * 48 + z * 12 + (y - 1) * 4 + x;
                            if (this.func_70301_a(id) == null || this.func_70301_a(bottomId) != null) continue;
                            this.func_70299_a(bottomId, this.func_70304_b(id));
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean canMount() {
        return this.RSDoor.isFullyOpened();
    }

    @Override
    public boolean canDismount() {
        return this.RSDoor.isFullyOpened();
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.workingMass = tag.func_74760_g("cartWorkingMass");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound subtag = tagList.func_150305_b(i);
            byte j = subtag.func_74771_c("Slot");
            if (j < 0 || j >= this.items.length) continue;
            this.items[j] = ItemStack.func_77949_a((NBTTagCompound)subtag);
        }
        this.RSDoor = new RSDoor(this.doorTime, tag.func_74771_c("stage"), tag.func_74767_n("opened"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("cartWorkingMass", this.workingMass);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound subtag = new NBTTagCompound();
            subtag.func_74774_a("Slot", (byte)i);
            this.items[i].func_77955_b(subtag);
            nbttaglist.func_74742_a((NBTBase)subtag);
        }
        tag.func_74782_a("Items", (NBTBase)nbttaglist);
        tag.func_74757_a("opened", this.RSDoor.isOpened());
        tag.func_74774_a("stage", this.RSDoor.getStage());
    }
}

