/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.row.registry.RoWConfig;
import net.row.stock.core.RoWRollingStock;
import net.row.stock.core.plugin.IRSCompressor;
import net.row.stock.core.plugin.IRSRegulatorA;
import net.row.stock.core.plugin.IRSRegulatorD5;
import net.row.stock.core.plugin.IRSReverseD3;

public abstract class RoWLocomotive
extends RoWRollingStock {
    public boolean zeroReverse;
    public byte hornStage;
    public int reversePrev;
    public int reverse;
    public float fxChance;
    public float fuelChance;
    public float maxForce;
    public float releaseSpeed;
    public float forceScale;
    public float forceOrder;
    public float[] effortPol;
    public String hornSound;
    public static final float maxReverse = 300.0f;
    public static final float motionError = 0.001f;

    public RoWLocomotive(World world) {
        super(world);
        this.hasBrake = true;
        this.isBrakeOn = true;
        this.fxChance = 0.35f;
        this.fuelChance = 0.99f;
        this.maxForce = 4.0f;
        this.releaseSpeed = 0.2f;
        this.forceScale = 15.0f;
        this.forceOrder = 2.0f;
        this.effortPol = new float[]{-0.04399f, 7.685f, -524.3f, 15222.0f};
    }

    @Override
    public void func_70030_z() {
        this.reversePrev = this.reverse;
        if (this.zeroReverse) {
            if (this.reverse >= 1) {
                --this.reverse;
            } else if (this.reverse <= -1) {
                ++this.reverse;
            } else {
                this.zeroReverse = false;
            }
        }
        this.hornStage = this.hornStage > 1 ? (byte)(this.hornStage - 1) : (byte)0;
        if (this.field_70170_p.field_72995_K) {
            this.spawnWhistleFx();
        }
        if (this instanceof IRSCompressor) {
            ((IRSCompressor)((Object)this)).runCompressor(this.fuel > 0, 1.7f);
        }
        float trainMass = 0.0f;
        for (RoWRollingStock stock : this.trainData.keySet()) {
            trainMass += stock.workingMass;
        }
        float addedMotion = 0.0f;
        if (this.fuel > 0) {
            int decrement = 1;
            if (this instanceof IRSRegulatorD5) {
                decrement = ((IRSRegulatorD5)((Object)this)).getRegulator().ordinal();
            }
            if (Math.random() < (double)this.fuelChance) {
                this.fuel -= decrement;
            }
            addedMotion = 0.0025000002f * this.getForceAvailable() / trainMass;
            if (this.field_70170_p.field_72995_K) {
                this.spawnFx();
            }
        } else {
            this.fuel = 0;
        }
        for (Map.Entry entry : this.trainData.entrySet()) {
            ((RoWRollingStock)((Object)entry.getKey())).applyForwardMotion(addedMotion * (float)((Integer)entry.getValue()).intValue());
        }
        super.func_70030_z();
    }

    public float getForceAvailable() {
        return Math.min(Math.abs(this.getForceByControls()), this.getForceBySpeed()) * Math.signum(this.getForceByControls());
    }

    public float getForceByControls() {
        if (this.reverse != 0 || this instanceof IRSReverseD3 && ((IRSReverseD3)((Object)this)).getReverse() != IRSReverseD3.EnumReserveP3.NEUTRAL) {
            float rev = (float)this.reverse / 300.0f;
            float reg = 1.0f;
            if (this instanceof IRSReverseD3) {
                rev = (float)((IRSReverseD3)((Object)this)).getReverse().ordinal() - 1.0f;
            }
            if (this instanceof IRSRegulatorD5) {
                reg = (float)((IRSRegulatorD5)((Object)this)).getRegulator().ordinal() / 5.0f;
            }
            if (this instanceof IRSRegulatorA) {
                reg = (float)((IRSRegulatorA)((Object)this)).getRegulator() / (float)((IRSRegulatorA)((Object)this)).getRegulatorMax();
            }
            return (float)((double)this.maxForce * Math.pow(reg, 0.5) * (double)rev * (double)RoWConfig.tractiveEffortMult);
        }
        return 0.0f;
    }

    public float getForceBySpeed() {
        float speed = (float)Math.abs(this.projectedSpeed);
        if (speed < this.releaseSpeed) {
            return this.maxForce;
        }
        return MathHelper.func_76131_a((float)((float)((double)this.maxForce - (double)this.forceScale * Math.pow(speed - this.releaseSpeed, 1.0f / this.forceOrder))), (float)0.0f, (float)this.maxForce);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void spawnFx();

    @SideOnly(value=Side.CLIENT)
    public abstract void spawnWhistleFx();

    @Override
    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.reverse = tag.func_74762_e("reverse");
        this.zeroReverse = tag.func_74767_n("zero_reverse");
    }

    @Override
    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        tag.func_74768_a("reverse", this.reverse);
        tag.func_74757_a("zero_reverse", this.zeroReverse);
    }
}

