/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.row.RoW;
import net.row.entity.EntityCartRider;
import net.row.helpers.RotativePoint;
import net.row.stock.core.RoWLocomotive;
import net.row.stock.core.RoWTender;
import net.row.stock.core.plugin.IRSRegulatorA;

public abstract class RoWLocomotiveSteam
extends RoWLocomotive
implements IRSRegulatorA {
    private int regulator;
    public boolean isRegulatorZeroed;
    public boolean isStokerOn = false;
    public byte stokerStage;
    public byte stokerStageMax = (byte)10;
    public byte lastWheelQuad;
    public RotativePoint fireboxPos = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
    public RotativePoint chimneyPos = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
    public RotativePoint whistlePos = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
    public RotativePoint steamPosLeft = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
    public RotativePoint steamPosRight = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
    public String pistonSoundI;
    public String pistonSoundO;

    public RoWLocomotiveSteam(World world) {
        super(world);
    }

    @Override
    public void addLoopingSounds() {
        super.addLoopingSounds();
        RoW.proxy.playSoundFirebox(this);
    }

    @Override
    public boolean interactMount(EntityPlayer player) {
        if (this.canBeRidden() && !player.func_70093_af() && (player.field_70154_o == null || player.field_70154_o instanceof EntityCartRider && ((EntityCartRider)player.field_70154_o).parent instanceof RoWTender)) {
            this.seat = new EntityCartRider(this);
            this.field_70170_p.func_72838_d((Entity)this.seat);
            player.func_70078_a((Entity)this.seat);
            return true;
        }
        return false;
    }

    @Override
    public void func_70030_z() {
        int wheelQuad;
        if (this.getIsRegulatorZeroed()) {
            if (this.canRegulatorGoDown()) {
                this.regulatorGoDown(30);
            } else {
                this.setIsRegulatorZeroed(false);
            }
        }
        if (this.fuel > 0 && this.regulator > 0 && (wheelQuad = this.wheelAngle[0] < -90.0f ? 0 : (this.wheelAngle[0] < 0.0f && this.wheelAngle[0] > -90.0f ? 1 : (this.wheelAngle[0] < 90.0f && this.wheelAngle[0] > 0.0f ? 2 : 3))) != this.lastWheelQuad) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.projectedSpeed > 2.0) {
                    if (this.lastWheelQuad % 2 != 0) {
                        this.field_70170_p.func_72956_a((Entity)this, "row:" + this.pistonSoundO, 3.0f, 1.0f + 0.5f * (float)Math.abs(this.reverse) / 2048.0f);
                    }
                } else {
                    this.field_70170_p.func_72956_a((Entity)this, "row:" + (this.lastWheelQuad % 2 == 0 ? this.pistonSoundI : this.pistonSoundO), 3.0f, 1.0f + 0.5f * (float)Math.abs(this.reverse) / 2048.0f);
                }
            } else {
                this.processPistonFxs((byte)wheelQuad, this.lastWheelQuad);
            }
            this.lastWheelQuad = (byte)wheelQuad;
        }
        if (this.isStokerOn && this.stokerStage < this.stokerStageMax) {
            this.stokerStage = (byte)(this.stokerStage + 1);
        }
        if (!this.isStokerOn && this.stokerStage > 0) {
            this.stokerStage = (byte)(this.stokerStage - 1);
        }
        super.func_70030_z();
    }

    @Override
    public void updateRotatives() {
        super.updateRotatives();
        this.fireboxPos.onUpdate();
        this.chimneyPos.onUpdate();
        this.whistlePos.onUpdate();
        this.steamPosLeft.onUpdate();
        this.steamPosRight.onUpdate();
    }

    @Override
    public int getRegulatorMax() {
        return 180;
    }

    @Override
    public int getRegulator() {
        return this.regulator;
    }

    @Override
    public void setRegulator(int r) {
        this.regulator = r;
    }

    @Override
    public boolean getIsRegulatorZeroed() {
        return this.isRegulatorZeroed;
    }

    @Override
    public void setIsRegulatorZeroed(boolean b) {
        this.isRegulatorZeroed = b;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnWhistleFx() {
        if (this.hornStage > 20) {
            EntityExplodeFX steamfx = new EntityExplodeFX(this.field_70170_p, (double)this.whistlePos.getX(), (double)this.whistlePos.getY(), (double)this.whistlePos.getZ(), 0.0, 0.0, 0.0);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)steamfx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void spawnPistonFxLeft();

    @SideOnly(value=Side.CLIENT)
    public abstract void spawnPistonFxRight();

    public abstract void processPistonFxs(byte var1, byte var2);

    @Override
    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.isStokerOn = tag.func_74767_n("isStokerOn");
        this.stokerStage = tag.func_74771_c("stokerStage");
    }

    @Override
    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        tag.func_74757_a("isStokerOn", this.isStokerOn);
        tag.func_74774_a("stokerStage", this.stokerStage);
    }
}

