/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.row.RoW;
import net.row.block.BlockGagTrack;
import net.row.block.BlockTrackNormal;
import net.row.entity.EntityCartRider;
import net.row.helpers.GeomHelper;
import net.row.helpers.RotationHelper;
import net.row.helpers.RotativePoint;
import net.row.helpers.UtilSync;
import net.row.item.ItemRollingStock;
import net.row.network.PacketFuel;
import net.row.network.PacketLight;
import net.row.network.PacketRequestServerNBTData;
import net.row.network.PacketRequestTrackData;
import net.row.network.PacketSendClientNBTData;
import net.row.network.PacketSync;
import net.row.registry.RoWConfig;
import net.row.registry.RoWItems;
import net.row.stock.UtilStock;
import net.row.stock.core.RoWLocomotiveSteam;
import net.row.stock.core.RoWTender;
import net.row.stock.core.plugin.IRSCompressor;
import net.row.stock.core.plugin.IRSRegulatorA;
import net.row.stock.core.plugin.IRSRegulatorD5;
import net.row.stock.core.plugin.IRSReverseD3;
import net.row.stock.loco.LocoSSW;
import net.row.tileentity.TileEntityTrackNormal;

public abstract class RoWRollingStock
extends Entity {
    public boolean needsFirstUpdate;
    public boolean hasLight;
    public boolean isLightOn;
    public boolean hasBrake;
    public boolean isBrakeOn;
    public boolean wasLightOnLastTick;
    public boolean onSwitchSiding;
    public boolean justTeleported;
    public byte brakeStage;
    public byte brakeStageMax = (byte)10;
    public byte modified;
    public byte maxLabelSize;
    public byte dataCooldown;
    public int colourPrimary;
    public int colourSecondary;
    public int lastLightPosX;
    public int lastLightPosY;
    public int lastLightPosZ;
    public int fuel;
    public int fuelCap;
    public float bareMass;
    public float workingMass;
    public float C_drag;
    public float R_const;
    public float C_stiction;
    protected float[] axleShifts;
    private byte axleSelector;
    private float nextKnockDistance;
    private static final float railLength = 12.0f;
    public float health;
    public double projectedSpeed;
    public double stockTangentX;
    public double stockTangentZ;
    public double stockTangentY;
    public float walkableMinX;
    public float walkableMinZ;
    public float walkableMaxX;
    public float walkableMaxZ;
    public float dismountLimit;
    public double[] tangent = new double[3];
    public float[] wheelRadius;
    public float[] wheelAngle;
    public RotativePoint riderPos;
    public RotativePoint lightsPos;
    public float frontCouplerShift = 1.0f;
    public float rearCouplerShift = 1.0f;
    public RotativePoint couplerFrontPos;
    public RotativePoint couplerRearPos;
    public RotativePoint mountPos;
    public RotativePoint dismountPosRight;
    public RotativePoint dismountPosLeft;
    protected EntityCartRider seat;
    public String riderUUID = "no_rider";
    public String label = "";
    public String placer = "unknown";
    public String brakeSound = "row:brake_cart";
    public String UUID;
    public String frontCartUUID = "";
    public String rearCartUUID = "";
    public TileEntityTrackNormal track;
    public RoWRollingStock couplerFrontCart;
    public RoWRollingStock couplerRearCart;
    public Map<RoWRollingStock, Integer> trainData;
    public CouplerType couplerFrontType = CouplerType.NONE;
    public CouplerType couplerRearType = CouplerType.NONE;
    public static final int[] colours = new int[]{0x303030, 0xFF0000, 3887386, 5320730, 2437522, 8073150, 2651799, 0xA0A0A0, 0x606060, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xFFFFFF};
    private int mapId;
    private static final float speed_cr = UtilStock.kmph2mpti(10.0f);
    public static final float brakeConst = 8.0f;
    public static final float brakeError = 1.0E-5f;
    public static final float bufferConst = 0.01f;
    private static final float rigidity = 0.005f;
    private static final float damping = 0.08f;
    private static final float freeDistance = 0.25f;
    private static final float breakingStretch = 3.5f;
    public final float stockRaise = 0.4375f;

    public RoWRollingStock(World par1World) {
        super(par1World);
        this.field_70178_ae = true;
        this.field_70158_ak = RoWConfig.ignoreFrustrum;
        this.maxLabelSize = (byte)32;
        this.needsFirstUpdate = true;
        this.riderPos = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
        this.lightsPos = new RotativePoint(this, 0.0f, 0.0f, 0.0f);
        this.mountPos = new RotativePoint(this, -1.5f, 0.0f, 0.0f);
        this.couplerFrontPos = new RotativePoint(this, 0.0f, 0.0f, this.frontCouplerShift);
        this.couplerRearPos = new RotativePoint(this, 0.0f, 0.0f, -this.rearCouplerShift);
        this.dismountPosRight = new RotativePoint(this, -2.3125f, 1.0f, 0.0f);
        this.dismountPosLeft = new RotativePoint(this, 2.3125f, 1.0f, 0.0f);
        this.dismountLimit = 0.5f;
        this.UUID = String.valueOf(this.func_110124_au());
        this.health = 20.0f;
        this.C_drag = 5.0f;
        this.R_const = 11.98f;
        this.C_stiction = 478.0f;
        this.axleShifts = new float[]{2.0f};
        this.justTeleported = false;
        this.trainData = new HashMap<RoWRollingStock, Integer>();
        this.trainData.put(this, 1);
        this.mapId = RoW.stockMap.get(this.field_70170_p.field_72995_K ? 1 : 0).get(this.field_70170_p.field_73011_w.field_76574_g).size();
        RoW.stockMap.get(this.field_70170_p.field_72995_K ? 1 : 0).get(this.field_70170_p.field_73011_w.field_76574_g).put(this.mapId, this);
    }

    public void func_70106_y() {
        super.func_70106_y();
        RoW.stockMap.get(this.field_70170_p.field_72995_K ? 1 : 0).get(this.field_70170_p.field_73011_w.field_76574_g).put(this.mapId, null);
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70088_a() {
        if (this.field_70170_p.field_72995_K) {
            this.addLoopingSounds();
        }
    }

    public void addLoopingSounds() {
        RoW.proxy.playSoundRoll(this);
        RoW.proxy.playSoundSkirr(this);
    }

    public void updateWalkableArea() {
    }

    public void func_70078_a(Entity entity) {
        super.func_70078_a(entity);
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.interactFuel(player)) {
                return this.sendUpdateToClient();
            }
            if (this.interactDye(player)) {
                return this.sendUpdateToClient();
            }
            if (this.interactTag(player)) {
                return this.sendUpdateToClient();
            }
            if (this.interactMount(player)) {
                return this.sendUpdateToClient();
            }
        }
        return false;
    }

    public boolean interactMount(EntityPlayer player) {
        if (this.canBeRidden() && player.field_70154_o == null && !player.func_70093_af()) {
            this.seat = new EntityCartRider(this);
            this.field_70170_p.func_72838_d((Entity)this.seat);
            player.func_70078_a((Entity)this.seat);
            return true;
        }
        return false;
    }

    public boolean interactFuel(EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item != null) {
            boolean b2;
            boolean b1 = item.func_77973_b().equals(Items.field_151044_h) && (this instanceof RoWLocomotiveSteam || this instanceof RoWTender);
            boolean bl = b2 = item.func_77973_b().equals(RoWItems.itemBattery) && this instanceof LocoSSW;
            if (b1 || b2) {
                if (player.field_71075_bZ.field_75098_d) {
                    this.fuel = this.fuelCap;
                    RoW.network.sendToAll((IMessage)new PacketFuel(this.func_145782_y(), this.fuelCap));
                    return true;
                }
                int itemValue = RoWConfig.coalFuelValue;
                if (this instanceof LocoSSW) {
                    itemValue = RoWConfig.batteryFuelValue;
                }
                if (this.fuel + itemValue < this.fuelCap) {
                    if (this.fuel + item.field_77994_a * itemValue < this.fuelCap) {
                        this.fuel += item.field_77994_a * itemValue;
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    } else {
                        int canConsumeItems = Math.min((this.fuelCap - this.fuel) / itemValue, item.field_77994_a);
                        this.fuel += canConsumeItems * RoWConfig.coalFuelValue;
                        item.field_77994_a -= canConsumeItems;
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, item.field_77994_a == 0 ? null : item);
                    }
                    RoW.network.sendToAll((IMessage)new PacketFuel(this.func_145782_y(), this.fuel));
                    return true;
                }
            }
        }
        return false;
    }

    public boolean interactDye(EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item != null && item.func_77973_b() == Items.field_151100_aR && item.field_77994_a > 0) {
            if (player.func_70093_af()) {
                this.colourSecondary = colours[item.func_77960_j()];
            } else {
                this.colourPrimary = colours[item.func_77960_j()];
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --item.field_77994_a;
                if (item.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
            return true;
        }
        return false;
    }

    public boolean interactTag(EntityPlayer player) {
        ItemStack item = player.field_71071_by.func_70448_g();
        if (item != null && item.func_77973_b() == Items.field_151057_cb) {
            this.label = item.func_82833_r().substring(0, Math.min(this.maxLabelSize, item.func_82833_r().length()));
            return true;
        }
        return false;
    }

    public void func_70100_b_(EntityPlayer player) {
        this.func_70108_f((Entity)player);
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        super.func_70097_a(damageSource, damage);
        if (!this.field_70170_p.field_72995_K) {
            System.out.println(damageSource.func_76355_l());
            if (damageSource.func_76346_g() instanceof EntityPlayer && !Objects.equals(damageSource.func_76355_l(), "arrow") && !Objects.equals(damageSource.func_76355_l(), "thrown")) {
                EntityPlayer entityplayer = (EntityPlayer)damageSource.func_76346_g();
                if (entityplayer.func_70093_af()) {
                    if (entityplayer.field_71075_bZ.field_75098_d) {
                        this.health = 0.0f;
                    } else if (entityplayer.func_70005_c_().equals(this.placer)) {
                        this.health = 0.0f;
                        if (this.getDrops() == null) {
                            for (int i = 0; i < ItemRollingStock.RSEnum.values().length; ++i) {
                                if (!((Object)((Object)this)).getClass().getName().equals(ItemRollingStock.RSEnum.values()[i].RSClass)) continue;
                                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(RoWItems.itemStock, 1, i)));
                            }
                        } else {
                            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getDrops()));
                        }
                    }
                }
            } else if (damageSource.func_94541_c()) {
                this.health -= damage;
                this.field_70170_p.func_72956_a((Entity)this, "random.break", 1.0f, 0.5f);
            }
            if (this.health <= 0.0f) {
                this.func_70106_y();
                if (this.couplerFrontCart != null) {
                    if (this.equals((Object)this.couplerFrontCart.couplerRearCart)) {
                        this.couplerFrontCart.rearCartUUID = "";
                    } else {
                        this.couplerFrontCart.frontCartUUID = "";
                    }
                    this.couplerFrontCart.sendUpdateToClient();
                }
                if (this.couplerRearCart != null) {
                    if (this.equals((Object)this.couplerRearCart.couplerFrontCart)) {
                        this.couplerRearCart.frontCartUUID = "";
                    } else {
                        this.couplerRearCart.rearCartUUID = "";
                    }
                    this.couplerRearCart.sendUpdateToClient();
                }
                if (RoWConfig.enableDynamicLighting && this.hasLight) {
                    if (this.isLightOn) {
                        RoW.network.sendToAll((IMessage)new PacketLight(this.func_145782_y()));
                    }
                    this.isLightOn = false;
                    this.burnLight();
                }
                return true;
            }
        }
        return false;
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (!(entity.field_70154_o instanceof EntityCartRider) && this.projectedSpeed > 0.2) {
                entity.func_70097_a(DamageSource.field_76377_j, (float)(this.projectedSpeed * 50.0));
            }
            this.field_70144_Y = 1.0f;
        } else {
            this.field_70144_Y = entity instanceof RoWRollingStock ? 0.0f : 1.0f;
        }
        super.func_70108_f(entity);
    }

    public void func_70030_z() {
        if (this.needsFirstUpdate) {
            this.needsFirstUpdate = false;
            if (this.field_70170_p.field_72995_K) {
                RoW.network.sendToServer((IMessage)new PacketRequestServerNBTData(this.func_145782_y()));
            } else {
                this.updateCoupledStock(true);
            }
            this.couplerFrontPos = new RotativePoint(this, 0.0f, 0.0f, this.frontCouplerShift);
            this.couplerRearPos = new RotativePoint(this, 0.0f, 0.0f, -this.rearCouplerShift);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_82737_E() % 600L == 0L) {
                UtilSync.sync(this);
            } else if (this.field_70170_p.func_82737_E() % 300L == 0L) {
                RoW.network.sendToAll((IMessage)new PacketSync(this.func_145782_y(), (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, (float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y, true));
            } else if (this.field_70170_p.func_82737_E() % 60L == 0L) {
                RoW.network.sendToAll((IMessage)new PacketSync(this.func_145782_y(), (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, (float)this.field_70159_w, (float)this.field_70181_x, (float)this.field_70179_y, false));
            }
        }
        UtilStock.bufferParameters(this);
        this.handlePortal();
        this.updateRotatives();
        this.updateWalkableArea();
        int[] currentTrackCoords = new int[]{MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + (double)0.3f)), MathHelper.func_76128_c((double)this.field_70161_v)};
        this.handleTeleportation(currentTrackCoords);
        this.setVectors(this.getMasterTrackPos(currentTrackCoords), currentTrackCoords);
        this.projectMotion();
        this.applyResistance();
        if (RoWConfig.allowBufferPhysics) {
            this.updateBuffers();
        }
        this.updateBrakes();
        this.updateCouplings();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.checkKnock();
        for (Object collidingEntity : this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D)) {
            if (collidingEntity == this.field_70153_n) continue;
            this.func_70108_f((Entity)collidingEntity);
        }
        this.projectMotion();
        for (int w = 0; w < this.wheelAngle.length; w = (int)((byte)(w + 1))) {
            this.wheelAngle[w] = (float)MathHelper.func_76138_g((double)((double)this.wheelAngle[w] - Math.toDegrees(this.projectedSpeed / (double)this.wheelRadius[w])));
        }
        if (RoWConfig.enableDynamicLighting && this.hasLight && this.field_70170_p.field_72995_K) {
            this.burnLight();
        }
        if (this.fuel > this.fuelCap) {
            this.fuel = this.fuelCap;
        }
        if (this.fuel < 0) {
            this.fuel = 0;
        }
        this.handleMass();
    }

    public void handleMass() {
        this.workingMass = this.bareMass + (float)this.fuel / 1000.0f;
    }

    public void handlePortal() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            this.field_70170_p.field_72984_F.func_76320_a("portal");
            MinecraftServer minecraftserver = ((WorldServer)this.field_70170_p).func_73046_m();
            int i = this.func_82145_z();
            if (this.field_71087_bX) {
                if (minecraftserver.func_71255_r()) {
                    if (this.field_82153_h++ >= i) {
                        this.field_82153_h = i;
                        this.field_71088_bW = this.func_82147_ab();
                        byte id = (byte)(this.field_70170_p.field_73011_w.field_76574_g * -1 - 1);
                        if (this.seat != null && this.seat.field_70153_n != null) {
                            this.riderUUID = this.seat.field_70153_n.func_110124_au().toString();
                            Entity ridden = this.seat.field_70153_n;
                            this.seat.field_70153_n.func_70078_a(null);
                            ridden.func_71027_c((int)id);
                        } else {
                            this.riderUUID = "no_rider";
                        }
                        this.func_71027_c(id);
                    }
                    this.field_71087_bX = false;
                }
            } else {
                if (this.field_82153_h > 0) {
                    this.field_82153_h -= 4;
                }
                if (this.field_82153_h < 0) {
                    this.field_82153_h = 0;
                }
            }
            if (this.field_71088_bW > 0) {
                --this.field_71088_bW;
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    public void handleTeleportation(int[] currentTrackCoords) {
        if (this.justTeleported) {
            int i;
            this.justTeleported = false;
            int range = 4;
            if (this.getMasterTrackPos(currentTrackCoords) == null) {
                block0: for (i = currentTrackCoords[0] - range; i < currentTrackCoords[0] + range; ++i) {
                    for (int j = currentTrackCoords[1] - range; j < currentTrackCoords[1] + range; ++j) {
                        for (int k = currentTrackCoords[2] - range; k < currentTrackCoords[2] + range; ++k) {
                            Block block = this.field_70170_p.func_147439_a(i, j, k);
                            if (!(block instanceof BlockTrackNormal) && !(block instanceof BlockGagTrack) || this.getMasterTrackPos(new int[]{i, j, k}) == null) continue;
                            currentTrackCoords = new int[]{i, j, k};
                            break block0;
                        }
                    }
                }
            }
            if (!Objects.equals(this.riderUUID, "no_rider")) {
                for (i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                    Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
                    if (entity == null || !entity.func_110124_au().toString().equals(this.riderUUID)) continue;
                    this.seat = new EntityCartRider(this);
                    this.field_70170_p.func_72838_d((Entity)this.seat);
                    entity.func_70078_a((Entity)this.seat);
                }
            }
        }
    }

    public void applyResistance() {
        float s0 = (float)Math.signum(this.projectedSpeed);
        float R = this.getResistance();
        this.applyForwardMotion(-1.0 * Math.signum(this.projectedSpeed) * (double)R * 0.002500000176951289 / 1000.0);
        float s1 = (float)Math.signum(this.projectedSpeed);
        if (this.track != null && (s0 != s1 || R == 0.0f)) {
            this.projectedSpeed = 0.0;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (!this.field_70170_p.field_72995_K && s0 != s1) {
                UtilSync.sync(this);
            }
        }
    }

    public float getResistance() {
        return this.getResistanceBase() + this.getResistanceAddition();
    }

    public float getResistanceBase() {
        if (Math.abs(this.projectedSpeed) > (double)speed_cr) {
            return this.R_const + (float)((double)this.C_drag * this.projectedSpeed * this.projectedSpeed / 0.002500000176951289);
        }
        if (Math.abs(this.projectedSpeed) > (double)0.001f) {
            return this.R_const + (float)((double)this.C_stiction * (1.0 - Math.sqrt(Math.abs(this.projectedSpeed) / (double)speed_cr)));
        }
        return 0.0f;
    }

    public float getResistanceAddition() {
        return this.getResistanceInTurn();
    }

    public float getResistanceInTurn() {
        if (this.track != null && this.track.isRadial()) {
            return 4860.0f / this.track.getRadius();
        }
        return 0.0f;
    }

    public void projectMotion() {
        this.updateUnits();
        if (this.track == null) {
            return;
        }
        if (this.stockTangentY == 0.0) {
            this.field_70181_x = 0.0;
        } else {
            UtilStock.applyGravitation(this, 0.02f);
        }
        this.projectedSpeed = this.field_70159_w * this.stockTangentX + this.field_70181_x * this.stockTangentY + this.field_70179_y * this.stockTangentZ;
        if (this.projectedSpeed == 0.0) {
            return;
        }
        double motion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        double scale = Math.abs(motion / this.projectedSpeed);
        if (this.stockTangentY != 0.0) {
            scale = 1.0;
        }
        this.field_70159_w = scale * this.projectedSpeed * this.stockTangentX;
        this.field_70181_x = scale * this.projectedSpeed * this.stockTangentY;
        this.field_70179_y = scale * this.projectedSpeed * this.stockTangentZ;
        this.projectedSpeed = this.field_70159_w * this.stockTangentX + this.field_70181_x * this.stockTangentY + this.field_70179_y * this.stockTangentZ;
    }

    public void updateUnits() {
        this.stockTangentX = -Math.sin(Math.toRadians(this.field_70177_z)) * Math.cos(Math.toRadians(this.field_70125_A));
        this.stockTangentZ = Math.cos(Math.toRadians(this.field_70177_z)) * Math.cos(Math.toRadians(this.field_70125_A));
        this.stockTangentY = Math.sin(Math.toRadians(this.field_70125_A));
        double module = Math.sqrt(this.stockTangentX * this.stockTangentX + this.stockTangentY * this.stockTangentY + this.stockTangentZ * this.stockTangentZ);
        double scale = 1.0 / module;
        this.stockTangentX *= scale;
        this.stockTangentZ *= scale;
        this.stockTangentY *= scale;
    }

    public void updateRotatives() {
        this.riderPos.onUpdate();
        this.lightsPos.onUpdate();
        this.couplerFrontPos.onUpdate();
        this.couplerRearPos.onUpdate();
        this.mountPos.onUpdate();
        this.dismountPosRight.onUpdate();
        this.dismountPosLeft.onUpdate();
    }

    public void updateBrakes() {
        if (this.isBrakeOn) {
            float trainMass = 0.0f;
            for (RoWRollingStock stock : this.trainData.keySet()) {
                trainMass += stock.workingMass;
            }
            double motion = 0.0;
            this.projectMotion();
            if (this.projectedSpeed > (double)1.0E-5f) {
                motion = -Math.min(1.0 / (8.0 * this.projectedSpeed * (double)trainMass), this.projectedSpeed);
            } else if (this.projectedSpeed < (double)-1.0E-5f) {
                motion = -Math.max(1.0 / (8.0 * this.projectedSpeed * (double)trainMass), this.projectedSpeed);
            }
            for (Map.Entry<RoWRollingStock, Integer> entry : this.trainData.entrySet()) {
                entry.getKey().applyForwardMotion(motion * (double)entry.getValue().intValue());
            }
        }
        if (!this.isBrakeOn && this.brakeStage == this.brakeStageMax && this instanceof IRSCompressor) {
            ((IRSCompressor)((Object)this)).bleed(30.0f);
        }
        if (this.isBrakeOn && this.brakeStage < this.brakeStageMax) {
            this.brakeStage = (byte)(this.brakeStage + 1);
        } else if (!this.isBrakeOn && this.brakeStage > 0) {
            this.brakeStage = (byte)(this.brakeStage - 1);
        }
    }

    public void updateBuffers() {
        for (Map.Entry<Integer, RoWRollingStock> entry : RoW.stockMap.get(this.field_70170_p.field_72995_K ? 1 : 0).get(this.field_70170_p.field_73011_w.field_76574_g).entrySet()) {
            float hypot;
            RoWRollingStock stock = entry.getValue();
            if (stock == null || stock == this) continue;
            this.updateUnits();
            stock.updateUnits();
            float dx = 0.0f;
            float dz = 0.0f;
            float df1 = (float)Math.hypot((double)stock.couplerFrontPos.getX() - this.field_70165_t, (double)stock.couplerFrontPos.getZ() - this.field_70161_v);
            float dr1 = (float)Math.hypot((double)stock.couplerRearPos.getX() - this.field_70165_t, (double)stock.couplerRearPos.getZ() - this.field_70161_v);
            float df2 = (float)Math.hypot((double)this.couplerFrontPos.getX() - stock.field_70165_t, (double)this.couplerFrontPos.getZ() - stock.field_70161_v);
            float dr2 = (float)Math.hypot((double)this.couplerRearPos.getX() - stock.field_70165_t, (double)this.couplerRearPos.getZ() - stock.field_70161_v);
            if (df2 < dr2) {
                if (df1 < this.frontCouplerShift) {
                    dx = -this.couplerFrontPos.getX() + stock.couplerFrontPos.getX();
                    dz = -this.couplerFrontPos.getZ() + stock.couplerFrontPos.getZ();
                }
                if (dr1 < this.frontCouplerShift) {
                    dx = -this.couplerFrontPos.getX() + stock.couplerRearPos.getX();
                    dz = -this.couplerFrontPos.getZ() + stock.couplerRearPos.getZ();
                }
            } else {
                if (df1 < this.rearCouplerShift) {
                    dx = -this.couplerRearPos.getX() + stock.couplerFrontPos.getX();
                    dz = -this.couplerRearPos.getZ() + stock.couplerFrontPos.getZ();
                }
                if (dr1 < this.rearCouplerShift) {
                    dx = -this.couplerRearPos.getX() + stock.couplerRearPos.getX();
                    dz = -this.couplerRearPos.getZ() + stock.couplerRearPos.getZ();
                }
            }
            if (dx == 0.0f && dz == 0.0f || !((hypot = (float)Math.hypot(dx, dz)) < 2.75f)) continue;
            this.func_70024_g(0.01f * dx, 0.0, 0.01f * dz);
        }
    }

    public void updateCoupledStock(boolean force) {
        boolean flag = false;
        if (force || this.couplerFrontCart == null && !this.frontCartUUID.equals("") || this.couplerRearCart == null && !this.rearCartUUID.equals("")) {
            for (int i = 0; i < this.field_70170_p.field_72996_f.size(); ++i) {
                Entity entity = (Entity)this.field_70170_p.field_72996_f.get(i);
                if (!(entity instanceof RoWRollingStock)) continue;
                if (((RoWRollingStock)entity).UUID.equals(this.frontCartUUID)) {
                    this.couplerFrontCart = (RoWRollingStock)entity;
                    flag = true;
                    continue;
                }
                if (!((RoWRollingStock)entity).UUID.equals(this.rearCartUUID)) continue;
                this.couplerRearCart = (RoWRollingStock)entity;
                flag = true;
            }
        }
        if (this.frontCartUUID.equals("")) {
            this.couplerFrontCart = null;
            if (force && !this.field_70170_p.field_72995_K) {
                System.out.println(this.getLastNameLetters(5) + " could not load the front car!");
            }
        }
        if (this.rearCartUUID.equals("")) {
            this.couplerRearCart = null;
            if (force && !this.field_70170_p.field_72995_K) {
                System.out.println(this.getLastNameLetters(5) + " could not load the rear car!");
            }
        }
        if (flag) {
            this.updateTrain();
        }
        if (force && !this.field_70170_p.field_72995_K) {
            UtilSync.sync(this);
        }
    }

    public void updateCouplings() {
        String msg;
        this.updateCoupledStock(false);
        float currentDistance = 0.0f;
        float idealDistance = 0.0f;
        float stretch = 0.0f;
        double damper = 0.0;
        if (this.couplerFrontPos != null && this.couplerFrontCart != null) {
            currentDistance = (float)Math.hypot(this.field_70165_t - this.couplerFrontCart.field_70165_t, this.field_70161_v - this.couplerFrontCart.field_70161_v);
            if (this.equals((Object)this.couplerFrontCart.couplerRearCart)) {
                idealDistance = this.couplerFrontPos.getRelZ() - this.couplerFrontCart.couplerRearPos.getRelZ();
                stretch = currentDistance - idealDistance;
                damper = (this.projectedSpeed - this.couplerFrontCart.projectedSpeed) * (double)0.08f;
            } else if (this.equals((Object)this.couplerFrontCart.couplerFrontCart)) {
                idealDistance = this.couplerFrontPos.getRelZ() + this.couplerFrontCart.couplerFrontPos.getRelZ();
                stretch = currentDistance - idealDistance;
                damper = (this.projectedSpeed + this.couplerFrontCart.projectedSpeed) * (double)0.08f;
            }
            if (Math.abs(stretch) < 0.25f) {
                stretch = 0.0f;
            }
            if (RoWConfig.allowBreakingCouplings && Math.abs(stretch) > RoWConfig.couplingBreakingStretch) {
                if (!this.field_70170_p.field_72995_K) {
                    if (this.equals((Object)this.couplerFrontCart.couplerFrontCart)) {
                        this.couplerFrontCart.frontCartUUID = "";
                        this.couplerFrontCart.couplerFrontCart = null;
                    } else if (this.equals((Object)this.couplerFrontCart.couplerRearCart)) {
                        this.couplerFrontCart.rearCartUUID = "";
                        this.couplerFrontCart.couplerRearCart = null;
                    }
                    this.couplerFrontCart.sendUpdateToClient();
                    this.couplerFrontCart = null;
                    this.frontCartUUID = "";
                    this.sendUpdateToClient();
                    this.func_85030_a("row:coupler_break", 4.0f, 1.0f);
                } else {
                    msg = StatCollector.func_74838_a((String)"row.msg.coupler_broke");
                    FMLClientHandler.instance().getClient().field_71439_g.func_146105_b((IChatComponent)new ChatComponentText(msg));
                }
            } else if (Math.signum(stretch) > 0.0f || !RoWConfig.allowBufferPhysics) {
                this.applyForwardMotion((double)(0.005f * stretch) - damper);
            }
        }
        if (this.couplerRearPos != null && this.couplerRearCart != null) {
            currentDistance = (float)Math.hypot(this.field_70165_t - this.couplerRearCart.field_70165_t, this.field_70161_v - this.couplerRearCart.field_70161_v);
            if (this.equals((Object)this.couplerRearCart.couplerRearCart)) {
                idealDistance = -this.couplerRearPos.getRelZ() + -this.couplerRearCart.couplerRearPos.getRelZ();
                stretch = currentDistance - idealDistance;
                damper = (this.projectedSpeed + this.couplerRearCart.projectedSpeed) * (double)0.08f;
            } else if (this.equals((Object)this.couplerRearCart.couplerFrontCart)) {
                idealDistance = -this.couplerRearPos.getRelZ() + this.couplerRearCart.couplerFrontPos.getRelZ();
                stretch = currentDistance - idealDistance;
                damper = (this.projectedSpeed - this.couplerRearCart.projectedSpeed) * (double)0.08f;
            }
            if (Math.abs(stretch) < 0.25f) {
                stretch = 0.0f;
            }
            if (RoWConfig.allowBreakingCouplings && Math.abs(stretch) > RoWConfig.couplingBreakingStretch) {
                if (!this.field_70170_p.field_72995_K) {
                    if (this.equals((Object)this.couplerRearCart.couplerFrontCart)) {
                        this.couplerRearCart.frontCartUUID = "";
                        this.couplerRearCart.couplerFrontCart = null;
                    } else if (this.equals((Object)this.couplerRearCart.couplerRearCart)) {
                        this.couplerRearCart.rearCartUUID = "";
                        this.couplerRearCart.couplerRearCart = null;
                    }
                    this.couplerRearCart.sendUpdateToClient();
                    this.rearCartUUID = "";
                    this.couplerRearCart = null;
                    this.sendUpdateToClient();
                    this.func_85030_a("row:coupler_break", 4.0f, 1.0f);
                } else {
                    msg = StatCollector.func_74838_a((String)"row.msg.coupler_broke");
                    FMLClientHandler.instance().getClient().field_71439_g.func_146105_b((IChatComponent)new ChatComponentText(msg));
                }
            } else if (Math.signum(stretch) > 0.0f || !RoWConfig.allowBufferPhysics) {
                this.applyForwardMotion(-((double)(0.005f * stretch) + damper));
            }
        }
    }

    public int[] getMasterTrackPos(int[] currentPos) {
        Block blockLevel = this.field_70170_p.func_147439_a(currentPos[0], currentPos[1], currentPos[2]);
        Block blockBottom = this.field_70170_p.func_147439_a(currentPos[0], currentPos[1] - 1, currentPos[2]);
        if (!(blockLevel instanceof BlockGagTrack || blockLevel instanceof BlockTrackNormal || blockBottom instanceof BlockGagTrack || blockBottom instanceof BlockTrackNormal)) {
            if (this.track != null) {
                if (this.track.isArc() || this.track.isLane() || this.onSwitchSiding && this.track.isSwitchByType()) {
                    for (int i = -1; i <= 1; i = (int)((byte)(i + 1))) {
                        for (int j = -1; j <= 1; j = (int)((byte)(j + 1))) {
                            TileEntityTrackNormal tile;
                            int[] trackPos;
                            blockLevel = this.field_70170_p.func_147439_a(currentPos[0] + i, currentPos[1], currentPos[2] + j);
                            if (!(blockLevel instanceof BlockGagTrack) && !(blockLevel instanceof BlockTrackNormal) || (trackPos = RoW.getTrackManager(this.field_70170_p).getMasterTrackPos(new int[]{currentPos[0] + i, currentPos[1], currentPos[2] + j})) == null || (tile = (TileEntityTrackNormal)this.field_70170_p.func_147438_o(trackPos[0], trackPos[1], trackPos[2])) == null) continue;
                            this.track = tile;
                            return trackPos;
                        }
                    }
                }
                this.track = null;
            }
            this.track = null;
            this.field_70159_w *= 0.15;
            this.field_70179_y *= 0.15;
            UtilStock.applyGravitation(this, 1.0f);
            return null;
        }
        if (RoW.getTrackManager(this.field_70170_p) != null) {
            int[] posLevel = RoW.getTrackManager(this.field_70170_p).getMasterTrackPos(new int[]{currentPos[0], currentPos[1], currentPos[2]});
            int[] posBottom = RoW.getTrackManager(this.field_70170_p).getMasterTrackPos(new int[]{currentPos[0], currentPos[1] - 1, currentPos[2]});
            if (posLevel != null) {
                return posLevel;
            }
            if (posBottom != null) {
                return posBottom;
            }
            if (this.field_70170_p.field_72995_K) {
                if (this.dataCooldown == 0) {
                    this.dataCooldown = (byte)20;
                    RoW.network.sendToServer((IMessage)new PacketRequestTrackData());
                } else {
                    this.dataCooldown = (byte)(this.dataCooldown - 1);
                }
            }
        }
        return null;
    }

    public void setVectors(int[] masterTrackCoords, int[] currentPos) {
        TileEntity te;
        if (currentPos != null) {
            for (int x = currentPos[0] - 1; x <= currentPos[0] + 1; ++x) {
                for (int z = currentPos[2] - 1; z <= currentPos[2] + 1; ++z) {
                    this.field_70170_p.func_147444_c(x, currentPos[1], z, this.field_70170_p.func_147439_a(x, currentPos[1], z));
                }
            }
        }
        if (masterTrackCoords != null && currentPos != null && (te = this.field_70170_p.func_147438_o(masterTrackCoords[0], masterTrackCoords[1], masterTrackCoords[2])) != null && te instanceof TileEntityTrackNormal) {
            this.track = (TileEntityTrackNormal)te;
            this.track.hasTrain = true;
            this.track.cooldown = (byte)60;
            this.tangent = this.getTangent(this.track, masterTrackCoords, currentPos);
            float pitchAngle = (float)MathHelper.func_76138_g((double)Math.toDegrees(Math.atan(this.tangent[2])));
            float trackAngle = (float)MathHelper.func_76138_g((double)(Math.toDegrees(Math.atan2(this.tangent[1], this.tangent[0])) - 90.0));
            float deltaAngle = MathHelper.func_76142_g((float)(this.field_70177_z - trackAngle));
            if (Math.abs(deltaAngle) > 90.0f) {
                this.func_70101_b(MathHelper.func_76142_g((float)(trackAngle - 180.0f)), -pitchAngle);
            } else {
                this.func_70101_b(trackAngle, pitchAngle);
            }
            if (this.field_70177_z > 90.0f && this.field_70126_B < -90.0f) {
                this.field_70126_B += 360.0f;
            } else if (this.field_70177_z < -90.0f && this.field_70126_B > 90.0f) {
                this.field_70126_B -= 360.0f;
            }
        }
    }

    public double[] getTangent(TileEntityTrackNormal track, int[] masterPos, int[] currentPos) {
        this.func_70107_b(this.field_70165_t, (float)track.field_145848_d + 0.4375f, this.field_70161_v);
        int direction = this.field_70170_p.func_72805_g(track.field_145851_c, track.field_145848_d, track.field_145849_e) & 3;
        int[] stTg = RotationHelper.rotateXZByDir(0, 1, direction);
        float distSq = 0.0f;
        boolean isOnSpacer = true;
        if (track.isArc() || track.isLane() || track.isSwitchByType()) {
            float[] vector = RotationHelper.rotateXZByDir(0.0f, 1.0f, direction);
            vector[0] = vector[0] + ((float)track.field_145851_c + 0.5f);
            vector[1] = vector[1] + ((float)track.field_145849_e + 0.5f);
            distSq = (float)((this.field_70165_t - (double)vector[0]) * (this.field_70165_t - (double)vector[0]) + (this.field_70161_v - (double)vector[1]) * (this.field_70161_v - (double)vector[1]));
            float flag = (float)(this.field_70161_v - (double)vector[1]);
            if (direction == 1) {
                flag = -((float)(this.field_70165_t - (double)vector[0]));
            } else if (direction == 2) {
                flag = -((float)(this.field_70161_v - (double)vector[1]));
            } else if (direction == 3) {
                flag = (float)(this.field_70165_t - (double)vector[0]);
            }
            isOnSpacer = flag < 0.0f;
            boolean bl = this.onSwitchSiding = !isOnSpacer && this.onSwitchSiding;
            if (isOnSpacer) {
                this.onSwitchSiding = track.activated;
            } else if (distSq > 182.25f) {
                this.onSwitchSiding = currentPos[0] != masterPos[0] && currentPos[2] != masterPos[2];
            } else {
                track.activated = this.onSwitchSiding;
            }
        }
        if (track.isStraight()) {
            if (direction == 0 || direction == 2) {
                this.func_70107_b((float)track.field_145851_c + 0.5f, (float)track.field_145848_d + 0.4375f, this.field_70161_v);
            } else {
                this.func_70107_b(this.field_70165_t, (float)track.field_145848_d + 0.4375f, (float)track.field_145849_e + 0.5f);
            }
            return new double[]{stTg[0], stTg[1], 0.0};
        }
        if (track.type == 2) {
            this.func_70107_b(this.field_70165_t, (float)track.field_145848_d + 0.4375f, this.field_70161_v);
            return new double[]{this.stockTangentX, this.stockTangentZ, 0.0};
        }
        if (track.type == 4 || track.type == 5) {
            double angle = Math.toRadians((double)(this.field_70170_p.func_72805_g(track.field_145851_c, track.field_145848_d, track.field_145849_e) & 3) * 90.0 - 45.0);
            float[] centre = new float[]{(float)track.field_145851_c + 0.5f, (float)track.field_145849_e + 0.5f};
            float[] project = GeomHelper.projectD2L(centre[0], centre[1], (float)Math.tan(angle), (float)this.field_70165_t, (float)this.field_70161_v);
            this.func_70107_b(project[0], (float)track.field_145848_d + 0.4375f, project[1]);
            return new double[]{Math.cos(angle), Math.sin(angle), 0.0};
        }
        if (track.isSlope()) {
            double gradient = 1.0 / (track.type == 6 ? 12.0 : 25.0 * (double)(track.type - 6));
            double zenith = Math.atan(gradient);
            double cos = Math.cos(zenith);
            float shiftZ = -0.5f;
            float[] vec = RotationHelper.rotateXZByDir(0.0f, shiftZ, direction);
            vec[0] = (float)((double)vec[0] + ((double)((float)track.field_145851_c + 0.5f) - this.field_70165_t));
            vec[1] = (float)((double)vec[1] + ((double)((float)track.field_145849_e + 0.5f) - this.field_70161_v));
            float dist = (float)Math.sqrt(vec[0] * vec[0] + vec[1] * vec[1]);
            float elevation = (float)((double)dist * gradient + 0.4375);
            if (direction == 0 || direction == 2) {
                this.func_70107_b((float)track.field_145851_c + 0.5f, (float)track.field_145848_d + elevation, this.field_70161_v);
            } else {
                this.func_70107_b(this.field_70165_t, (float)track.field_145848_d + elevation, (float)track.field_145849_e + 0.5f);
            }
            return new double[]{(double)stTg[0] * cos, (double)stTg[1] * cos, Math.sin(zenith)};
        }
        if (track.isRadial()) {
            float mirror = (track.type & 1) == 0 ? 1.0f : -1.0f;
            double radius = track.getRadius();
            double shiftZ = -0.15f;
            double shiftX = (double)mirror * radius;
            double[] vector = RotationHelper.rotateXZByDir(shiftX, shiftZ, direction);
            vector[0] = vector[0] + (double)((float)track.field_145851_c + 0.5f);
            vector[1] = vector[1] + (double)((float)track.field_145849_e + 0.5f);
            double radiusAngle = Math.atan2(vector[1] - this.field_70161_v, vector[0] - this.field_70165_t);
            if (isOnSpacer) {
                this.onSwitchSiding = track.activated;
                if (direction == 0 || direction == 2) {
                    this.func_70107_b((float)track.field_145851_c + 0.5f, (float)track.field_145848_d + 0.4375f, this.field_70161_v);
                } else {
                    this.func_70107_b(this.field_70165_t, (float)track.field_145848_d + 0.4375f, (float)track.field_145849_e + 0.5f);
                }
                return new double[]{stTg[0], stTg[1], 0.0};
            }
            if (distSq < 240.25f) {
                track.activated = this.onSwitchSiding;
            } else {
                boolean bl = this.onSwitchSiding = currentPos[0] != masterPos[0] && currentPos[2] != masterPos[2];
            }
            if (track.isArc() || track.isLane() || this.onSwitchSiding && track.isSwitchByType()) {
                this.func_70107_b(vector[0] + Math.cos(radiusAngle) * -radius, (float)track.field_145848_d + 0.4375f, vector[1] + Math.sin(radiusAngle) * -radius);
                return new double[]{-Math.sin(radiusAngle), Math.cos(radiusAngle), 0.0};
            }
            return new double[]{stTg[0], stTg[1], 0.0};
        }
        return this.tangent;
    }

    public void burnLight() {
        if (this.isLightOn) {
            this.wasLightOnLastTick = true;
            int x = MathHelper.func_76128_c((double)this.lightsPos.getX());
            int y = MathHelper.func_76128_c((double)this.lightsPos.getY());
            int z = MathHelper.func_76128_c((double)this.lightsPos.getZ());
            if (x != this.lastLightPosX || y != this.lastLightPosY || z != this.lastLightPosZ) {
                this.field_70170_p.func_147463_c(EnumSkyBlock.Block, this.lastLightPosX, this.lastLightPosY, this.lastLightPosZ);
                this.field_70170_p.func_72915_b(EnumSkyBlock.Block, x, y, z, 15);
                this.field_70170_p.func_147463_c(EnumSkyBlock.Block, x, y + 1, z);
                this.field_70170_p.func_147463_c(EnumSkyBlock.Block, x, y - 1, z);
                this.lastLightPosX = x;
                this.lastLightPosY = y;
                this.lastLightPosZ = z;
            }
        } else {
            if (this.wasLightOnLastTick) {
                this.wasLightOnLastTick = false;
                this.field_70170_p.func_72915_b(EnumSkyBlock.Block, this.lastLightPosX, this.lastLightPosY, this.lastLightPosZ, 0);
                for (int i = -2; i < 3; ++i) {
                    for (int j = -2; j < 3; ++j) {
                        for (int k = -2; k < 3; ++k) {
                            this.field_70170_p.func_147463_c(EnumSkyBlock.Block, this.lastLightPosX + i, this.lastLightPosY + j, this.lastLightPosZ + k);
                        }
                    }
                }
            }
            this.lastLightPosZ = 0;
            this.lastLightPosY = 0;
            this.lastLightPosX = 0;
        }
    }

    public boolean canBeRidden() {
        return true;
    }

    public boolean canMount() {
        return false;
    }

    public boolean canDismount() {
        return true;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public boolean func_70067_L() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int par9) {
    }

    public void applyForwardMotion(double v) {
        this.func_70024_g(this.stockTangentX * v, this.stockTangentY * v, this.stockTangentZ * v);
    }

    public void updateTrain() {
        this.trainData = this.getStockInTrain();
        for (RoWRollingStock stock : this.trainData.keySet()) {
            stock.trainData = stock.getStockInTrain();
        }
    }

    public Map<RoWRollingStock, Integer> getStockInTrain() {
        HashMap<RoWRollingStock, Integer> stockMap = new HashMap<RoWRollingStock, Integer>();
        RoWRollingStock cart = this;
        int currentDir = 1;
        boolean goneForwards = false;
        stockMap.put(this, currentDir);
        while (true) {
            if (cart.couplerRearCart != null && !cart.couplerRearCart.field_70128_L && !stockMap.containsKey((Object)cart.couplerRearCart)) {
                if (!cart.equals((Object)cart.couplerRearCart.couplerFrontCart)) {
                    currentDir *= -1;
                }
                cart = cart.couplerRearCart;
                stockMap.put(cart, currentDir);
                continue;
            }
            if (cart.couplerFrontCart != null && !cart.couplerFrontCart.field_70128_L && !stockMap.containsKey((Object)cart.couplerFrontCart)) {
                if (!cart.equals((Object)cart.couplerFrontCart.couplerRearCart)) {
                    currentDir *= -1;
                }
                cart = cart.couplerFrontCart;
                stockMap.put(cart, currentDir);
                continue;
            }
            if (goneForwards) break;
            goneForwards = true;
            cart = this;
        }
        return stockMap;
    }

    public boolean sendUpdateToClient() {
        if (!this.field_70170_p.field_72995_K) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.func_70109_d(nbttagcompound);
            RoW.network.sendToAll((IMessage)new PacketSendClientNBTData(this.func_145782_y(), nbttagcompound));
            return true;
        }
        return false;
    }

    public ItemStack getDrops() {
        return null;
    }

    protected void checkKnock() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        Block block = this.field_70170_p.func_147439_a(i, j, k);
        float distanceWalked = this.field_82151_R / 0.6f;
        if (distanceWalked > this.nextKnockDistance && (block instanceof BlockTrackNormal || block instanceof BlockGagTrack)) {
            if (this.axleSelector >= this.axleShifts.length) {
                this.nextKnockDistance = distanceWalked + 12.0f;
                this.axleSelector = 0;
            } else {
                this.nextKnockDistance = distanceWalked + this.axleShifts[this.axleSelector];
                this.axleSelector = (byte)(this.axleSelector + 1);
            }
            this.playKnock();
        }
    }

    protected void playKnock() {
        this.func_85030_a("row:wheelset_knock", 0.5f, 1.0f);
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
    }

    public String getLastNameLetters(int n) {
        return this.func_110124_au().toString().substring(this.func_110124_au().toString().length() - n);
    }

    public void func_82141_a(Entity from, boolean flag) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        from.func_70109_d(nbttagcompound);
        this.func_70020_e(nbttagcompound);
        this.field_71088_bW = from.field_71088_bW;
        this.field_82152_aq = from.func_82148_at();
        this.justTeleported = true;
        this.needsFirstUpdate = true;
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.onSwitchSiding = tag.func_74767_n("switched");
        this.isLightOn = tag.func_74767_n("isLightOn");
        this.isBrakeOn = tag.func_74767_n("isBrakeOn");
        this.brakeStage = tag.func_74771_c("brakeStage");
        this.modified = tag.func_74771_c("mod");
        this.colourPrimary = tag.func_74762_e("colour");
        this.colourSecondary = tag.func_74762_e("colour2");
        this.fuel = tag.func_74762_e("fuel");
        this.health = tag.func_74760_g("health");
        this.placer = tag.func_74779_i("placer");
        this.label = tag.func_74779_i("label");
        this.UUID = tag.func_74779_i("UUID");
        this.riderUUID = tag.func_74779_i("riderUUID");
        this.frontCartUUID = tag.func_74779_i("frontCartUUID");
        this.rearCartUUID = tag.func_74779_i("rearCartUUID");
        if (this instanceof IRSReverseD3) {
            ((IRSReverseD3)((Object)this)).setReverse(IRSReverseD3.EnumReserveP3.values()[tag.func_74771_c("reverseP3")]);
        }
        if (this instanceof IRSRegulatorD5) {
            ((IRSRegulatorD5)((Object)this)).setRegulator(IRSRegulatorD5.EnumRegulatorP5.values()[tag.func_74771_c("regulatorP5")]);
        }
        if (this instanceof IRSRegulatorA) {
            ((IRSRegulatorA)((Object)this)).setRegulator(tag.func_74762_e("regulatorA"));
            ((IRSRegulatorA)((Object)this)).setIsRegulatorZeroed(tag.func_74767_n("regulatorA_isZeroed"));
        }
        if (this instanceof IRSCompressor) {
            ((IRSCompressor)((Object)this)).setPressure(tag.func_74760_g("compressorPressure"));
            ((IRSCompressor)((Object)this)).setTriggered(tag.func_74767_n("compressorTriggered"));
        }
        this.updateTrain();
    }

    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        tag.func_74757_a("switched", this.onSwitchSiding);
        tag.func_74757_a("isLightOn", this.isLightOn);
        tag.func_74757_a("isBrakeOn", this.isBrakeOn);
        tag.func_74774_a("brakeStage", this.brakeStage);
        tag.func_74774_a("mod", this.modified);
        tag.func_74768_a("colour", this.colourPrimary);
        tag.func_74768_a("colour2", this.colourSecondary);
        tag.func_74768_a("fuel", this.fuel);
        tag.func_74776_a("health", this.health);
        tag.func_74778_a("placer", this.placer);
        tag.func_74778_a("label", this.label);
        tag.func_74778_a("UUID", this.UUID);
        tag.func_74778_a("riderUUID", this.riderUUID);
        tag.func_74778_a("frontCartUUID", this.frontCartUUID);
        tag.func_74778_a("rearCartUUID", this.rearCartUUID);
        if (this instanceof IRSReverseD3) {
            tag.func_74774_a("reverseP3", (byte)((IRSReverseD3)((Object)this)).getReverse().ordinal());
        }
        if (this instanceof IRSRegulatorD5) {
            tag.func_74774_a("regulatorP5", (byte)((IRSRegulatorD5)((Object)this)).getRegulator().ordinal());
        }
        if (this instanceof IRSRegulatorA) {
            tag.func_74768_a("regulatorA", ((IRSRegulatorA)((Object)this)).getRegulator());
            tag.func_74757_a("regulatorA_isZeroed", ((IRSRegulatorA)((Object)this)).getIsRegulatorZeroed());
        }
        if (this instanceof IRSCompressor) {
            tag.func_74776_a("compressorPressure", ((IRSCompressor)((Object)this)).getPressure());
            tag.func_74757_a("compressorTriggered", ((IRSCompressor)((Object)this)).getTriggered());
        }
    }

    protected void func_70037_a(NBTTagCompound tag) {
    }

    protected void func_70014_b(NBTTagCompound tag) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distanceSq) {
        return distanceSq < 65536.0;
    }

    public static enum CouplerType {
        NONE(0.0f, 0.0f, 0.0f),
        CHER(0.0625f, 0.75f, 0.1875f),
        BnC_RUSS(0.09375f, 0.75f, 0.5625f),
        LT_Ov(0.09375f, 0.75f, 0.5625f);

        public final float plate2beam;
        public final float height;
        public final float maxDist;

        private CouplerType(float d, float p, float h) {
            this.maxDist = d;
            this.plate2beam = p;
            this.height = h;
        }

        public final float getMaxDist() {
            return this.maxDist;
        }
    }
}

