/*
 * Decompiled with CFR 0.152.
 */
package net.row.stock.core.object;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.row.stock.core.RoWRollingStock;

public class RSInventoryFurnace
implements IInventory {
    RoWRollingStock parent;
    private ItemStack[] furnaceItemStacks = new ItemStack[3];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;

    public RSInventoryFurnace(RoWRollingStock stock) {
        this.parent = stock;
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int id) {
        return this.furnaceItemStacks[id];
    }

    public ItemStack func_70298_a(int id, int amount) {
        if (this.furnaceItemStacks[id] != null) {
            if (this.furnaceItemStacks[id].field_77994_a <= amount) {
                ItemStack result = this.furnaceItemStacks[id];
                this.furnaceItemStacks[id] = null;
                return result;
            }
            ItemStack result = this.furnaceItemStacks[id].func_77979_a(amount);
            if (this.furnaceItemStacks[id].field_77994_a == 0) {
                this.furnaceItemStacks[id] = null;
            }
            return result;
        }
        return null;
    }

    public ItemStack func_70304_b(int id) {
        if (this.furnaceItemStacks[id] != null) {
            ItemStack result = this.furnaceItemStacks[id];
            this.furnaceItemStacks[id] = null;
            return result;
        }
        return null;
    }

    public void func_70299_a(int id, ItemStack stack) {
        this.furnaceItemStacks[id] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "container.furnace";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.parent.field_70128_L && player.func_70032_d((Entity)this.parent) <= 8.0f;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int id, ItemStack stack) {
        return id != 2 && (id != 1 || RSInventoryFurnace.isItemFuel(stack));
    }

    public void updateFurnace() {
        boolean wasBurning = this.isFurnaceBurning();
        boolean hasChanged = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.parent.field_70170_p.field_72995_K) {
            if (this.furnaceBurnTime != 0 || this.furnaceItemStacks[1] != null && this.furnaceItemStacks[0] != null) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = RSInventoryFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
                    if (this.furnaceBurnTime > 0) {
                        hasChanged = true;
                        if (this.furnaceItemStacks[1] != null) {
                            --this.furnaceItemStacks[1].field_77994_a;
                            if (this.furnaceItemStacks[1].field_77994_a == 0) {
                                this.furnaceItemStacks[1] = this.furnaceItemStacks[1].func_77973_b().getContainerItem(this.furnaceItemStacks[1]);
                            }
                        }
                    }
                }
                if (this.isFurnaceBurning() && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 200) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        hasChanged = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
            if (wasBurning != this.isFurnaceBurning()) {
                hasChanged = true;
            }
        }
        if (hasChanged) {
            this.func_70296_d();
        }
    }

    public boolean isFurnaceBurning() {
        return this.furnaceBurnTime > 0;
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.furnaceItemStacks[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[2].func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
            if (this.furnaceItemStacks[2] == null) {
                this.furnaceItemStacks[2] = itemstack.func_77946_l();
            } else if (this.furnaceItemStacks[2].func_77973_b() == itemstack.func_77973_b()) {
                this.furnaceItemStacks[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public static boolean isItemFuel(ItemStack stack) {
        return RSInventoryFurnace.getItemBurnTime(stack) > 0;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int factor) {
        return factor * this.furnaceCookTime / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int factor) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return factor * this.furnaceBurnTime / this.currentItemBurnTime;
    }

    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("FurnaceItems", 10);
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound subtag = list.func_150305_b(i);
            byte id = subtag.func_74771_c("Slot");
            if (id < 0 || id >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[id] = ItemStack.func_77949_a((NBTTagCompound)subtag);
        }
        this.furnaceBurnTime = tag.func_74765_d("FurnaceBurnTime");
        this.furnaceCookTime = tag.func_74765_d("FurnaceCookTime");
        this.currentItemBurnTime = RSInventoryFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74777_a("FurnaceBurnTime", (short)this.furnaceBurnTime);
        tag.func_74777_a("FurnaceCookTime", (short)this.furnaceCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound subtag = new NBTTagCompound();
            subtag.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(subtag);
            list.func_74742_a((NBTBase)subtag);
        }
        tag.func_74782_a("FurnaceItems", (NBTBase)list);
    }
}

